/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

public class CvsLogUtils {
    public static boolean isInAttic(String rcsFilename, String workingFilename) {
        int lastDelim = workingFilename.lastIndexOf("/");
        String filename = workingFilename.substring(lastDelim + 1, workingFilename.length());
        int rcsPathLength = rcsFilename.length() - filename.length() - 2;
        String rcsPath = rcsFilename.substring(0, rcsPathLength);
        return rcsPath.endsWith("/Attic/");
    }

    public static boolean isOnMainBranch(String revisionNumber) {
        int index = 0;
        int dotCount = 0;
        while (revisionNumber.indexOf(46, index) != -1) {
            index = revisionNumber.indexOf(46, index) + 1;
            ++dotCount;
        }
        return dotCount == 1;
    }

    public static String getModuleName(String rcsFilename, String workingFilename) {
        String cvsroot;
        int lastSlash;
        int localLenght = workingFilename.length() + ",v".length();
        if (CvsLogUtils.isInAttic(rcsFilename, workingFilename)) {
            localLenght += "/Attic".length();
        }
        if ((lastSlash = (cvsroot = rcsFilename.substring(0, rcsFilename.length() - localLenght - 1)).lastIndexOf("/")) == -1) {
            return "";
        }
        return cvsroot.substring(lastSlash + 1);
    }

    public static boolean isBinaryKeywordSubst(String kws) {
        if ("kv".equals(kws)) {
            return false;
        }
        if ("kvl".equals(kws)) {
            return false;
        }
        if ("k".equals(kws)) {
            return false;
        }
        if ("o".equals(kws)) {
            return false;
        }
        if ("b".equals(kws)) {
            return true;
        }
        if ("v".equals(kws)) {
            return false;
        }
        if ("u".equals(kws)) {
            return false;
        }
        throw new IllegalArgumentException("unknown keyword substitution: " + kws);
    }
}

