/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.LogPageMaker;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.LinkColumn;
import net.sf.statcvs.reportmodel.SimpleTextColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.TableReport;

public class TagReport
implements TableReport {
    private final ReportConfig config;
    private final Repository repository;
    private Table table;

    public TagReport(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public void calculate() {
        LinkColumn tags = new LinkColumn("Name");
        SimpleTextColumn dates = new SimpleTextColumn("Date");
        IntegerColumn loc = new IntegerColumn("Lines");
        loc.setShowPercentages(false);
        IntegerColumn churn = new IntegerColumn("LOC Churn");
        IntegerColumn developers = new IntegerColumn("Developers");
        developers.setShowPercentages(false);
        this.table = new Table("Repository Tags");
        this.table.setKeysInFirstColumn(true);
        this.table.addColumn(tags);
        this.table.addColumn(dates);
        this.table.addColumn(loc);
        this.table.addColumn(churn);
        this.table.addColumn(developers);
        ArrayList<SymbolicName> tagList = new ArrayList<SymbolicName>(this.repository.getSymbolicNames());
        tagList.add(this.repository.getHead());
        Collections.reverse(tagList);
        Iterator it = tagList.iterator();
        while (it.hasNext()) {
            SymbolicName tag = (SymbolicName)it.next();
            Date startDate = this.getStartDate(tag);
            List revisions = this.getRevisionsBetween(startDate, tag.getDate());
            if (tag == this.repository.getHead()) {
                tags.addValue(null, "(now)");
            } else {
                tags.addValue(LogPageMaker.getURL(tag.getDate()) + "#" + LogPageMaker.getAnchor(tag), tag.getName());
            }
            dates.addValue(HTML.getDate(tag.getDate()));
            loc.addValue(this.getLOC(tag));
            churn.addValue(this.getLOCChurn(revisions));
            developers.addValue(this.countDevelopers(revisions));
        }
    }

    public Table getTable() {
        return this.table;
    }

    private int getLOC(SymbolicName tag) {
        int loc = 0;
        Iterator it = tag.getRevisions().iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            loc += revision.getLines();
        }
        return loc;
    }

    private List getRevisionsBetween(Date start, Date end) {
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        Iterator it = this.repository.getRevisions().iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            long time = revision.getDate().getTime();
            if (time <= start.getTime() || time > end.getTime()) continue;
            revisions.add(revision);
        }
        return revisions;
    }

    private int getLOCChurn(List revisions) {
        int churn = 0;
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            churn += revision.getNewLines();
        }
        return churn;
    }

    private Date getStartDate(SymbolicName tag) {
        SortedSet<SymbolicName> earlierTags = this.repository.getSymbolicNames().headSet(tag);
        if (earlierTags.isEmpty()) {
            return this.repository.getFirstDate();
        }
        return earlierTags.last().getDate();
    }

    private int countDevelopers(Collection revisions) {
        HashSet<Author> authors = new HashSet<Author>();
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            authors.add(revision.getAuthor());
        }
        int result = 0;
        it = authors.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            if (!this.config.isDeveloper(author)) continue;
            ++result;
        }
        return result;
    }
}

