/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.LogPageMaker;
import net.sf.statcvs.reportmodel.AuthorColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.LinkColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.TableReport;
import net.sf.statcvs.util.IntegerMap;

public class DevelopersOfTheMonthTable
implements TableReport {
    private final Repository repository;
    private Table table;
    private static final String[] MONTH_NAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public DevelopersOfTheMonthTable(ReportConfig config) {
        this.repository = config.getRepository();
    }

    public void calculate() {
        LinkColumn months = new LinkColumn("Month");
        AuthorColumn developers = new AuthorColumn();
        IntegerColumn loc = new IntegerColumn("Lines");
        loc.setShowPercentages(false);
        this.table = new Table("Repository Tags");
        this.table.setKeysInFirstColumn(true);
        this.table.addColumn(months);
        this.table.addColumn(developers);
        this.table.addColumn(loc);
        Date start = this.repository.getFirstDate();
        Date end = this.repository.getLastDate();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(end);
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.setTime(start);
        while (true) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            String month_year = MONTH_NAME[month] + " " + year;
            IntegerMap developerMap = this.getMostActiveUserOfMonth(month, year);
            if (developerMap.size() > 0) {
                months.addValue(LogPageMaker.getURL(calendar.getTime()), month_year);
                Iterator it = developerMap.iteratorSortedByValueReverse();
                Author developer = (Author)it.next();
                developers.addValue(developer);
                loc.addValue(developerMap.get(developer));
            }
            if (calendar.get(1) == startCal.get(1) && calendar.get(2) == startCal.get(2)) break;
            ((Calendar)calendar).add(2, -1);
        }
    }

    private IntegerMap getMostActiveUserOfMonth(int month, int year) {
        SortedSet revisions = this.repository.getRevisions();
        GregorianCalendar calendar = new GregorianCalendar();
        IntegerMap developerMap = new IntegerMap();
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            calendar.setTime(revision.getDate());
            if (calendar.get(1) != year || calendar.get(2) != month || revision.getAuthor() == null) continue;
            if (developerMap.contains(revision.getAuthor())) {
                int loc = developerMap.get(revision.getAuthor());
                developerMap.put(revision.getAuthor(), revision.getNewLines() + loc);
                continue;
            }
            developerMap.put(revision.getAuthor(), revision.getNewLines());
        }
        return developerMap;
    }

    public Table getTable() {
        return this.table;
    }
}

