/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reportmodel;

import net.sf.statcvs.renderer.TableCellRenderer;
import net.sf.statcvs.reportmodel.Column;
import net.sf.statcvs.reportmodel.IntegerColumn;

public class RatioColumn
extends Column {
    private final String title;
    private final IntegerColumn col1;
    private final IntegerColumn col2;

    public RatioColumn(String title, IntegerColumn col1, IntegerColumn col2) {
        this.title = title;
        this.col1 = col1;
        this.col2 = col2;
    }

    public int getRows() {
        return this.col1.getRows();
    }

    public void renderHead(TableCellRenderer renderer) {
        renderer.renderCell(this.title);
    }

    public void renderCell(int rowIndex, TableCellRenderer renderer) {
        renderer.renderCell(this.getRatio(this.col1.getValue(rowIndex), this.col2.getValue(rowIndex)));
    }

    public void renderTotal(TableCellRenderer renderer) {
        renderer.renderCell(this.getRatio(this.col1.getSum(), this.col2.getSum()));
    }

    private String getRatio(int val1, int val2) {
        if (val2 == 0) {
            return "-";
        }
        int ratioTimes10 = val1 * 10 / val2;
        double ratio = (double)ratioTimes10 / 10.0;
        return Double.toString(ratio);
    }
}

