/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reportmodel;

import java.util.ArrayList;
import java.util.List;
import net.sf.statcvs.renderer.TableCellRenderer;
import net.sf.statcvs.reportmodel.Column;

public class LinkColumn
extends Column {
    private final String title;
    private final List urls = new ArrayList();
    private final List labels = new ArrayList();
    private String total = null;

    public LinkColumn(String title) {
        this.title = title;
    }

    public void setTotal(String value) {
        this.total = value;
    }

    public void addValue(String url, String label) {
        if (url == null) {
            this.urls.add("");
        } else {
            this.urls.add(url);
        }
        this.labels.add(label);
    }

    public int getRows() {
        return this.urls.size();
    }

    public void renderHead(TableCellRenderer renderer) {
        renderer.renderCell(this.title);
    }

    public void renderCell(int rowIndex, TableCellRenderer renderer) {
        String url = (String)this.urls.get(rowIndex);
        renderer.renderLinkCell("".equals(url) ? null : url, (String)this.labels.get(rowIndex));
    }

    public void renderTotal(TableCellRenderer renderer) {
        if (this.total == null) {
            renderer.renderEmptyCell();
        } else {
            renderer.renderCell(this.total);
        }
    }
}

