/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.DirectoryTreeFormatter;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.PageGroup;
import net.sf.statcvs.renderer.TableRenderer;
import net.sf.statcvs.reports.TableReport;

public class Page
implements NavigationNode {
    private static final NumberFormat[] DOUBLE_FORMATS = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.0"), new DecimalFormat("0.00"), new DecimalFormat("0.000"), new DecimalFormat("0.0000")};
    private static final Logger logger = Logger.getLogger("sf.net.statcvs");
    private final ReportConfig config;
    private final String fileName;
    private final String shortTitle;
    private final String fullTitle;
    private final MarkupSyntax outputFormat;
    private StringBuffer contents = new StringBuffer();
    private NavigationNode parent = null;
    private String siblingsTitle = null;
    private List siblings = Collections.EMPTY_LIST;
    private final List children = new ArrayList();
    private final List attributeKeys = new ArrayList();
    private final List attributeValues = new ArrayList();
    private boolean showLinkToPreviousSibling = false;
    private boolean inSection = false;
    private boolean written = false;

    public Page(ReportConfig config, String fileName, String shortTitle, String fullTitle) {
        this.config = config;
        this.fileName = fileName;
        this.shortTitle = shortTitle;
        this.fullTitle = fullTitle;
        this.outputFormat = config.getMarkup();
    }

    public void setParent(NavigationNode parent) {
        this.parent = parent;
    }

    public void setSiblings(String siblingsTitle, List siblingPages) {
        this.siblingsTitle = siblingsTitle;
        this.siblings = siblingPages;
    }

    public void addChild(NavigationNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public String getURL() {
        return this.fileName + ".html";
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getFullTitle() {
        return this.fullTitle;
    }

    public void setShowLinkToPreviousSibling(boolean showLink) {
        this.showLinkToPreviousSibling = showLink;
    }

    public void addAttribute(String key, int value) {
        this.addAttribute(key, Integer.toString(value));
    }

    public void addAttribute(String key, int value, String unit) {
        this.addAttribute(key, Integer.toString(value) + " " + unit);
    }

    public void addAttribute(String key, Date value) {
        this.addRawAttribute(key, HTML.getDateAndTime(value));
    }

    public void addAttribute(String key, String value) {
        this.addRawAttribute(key, HTML.escape(value));
    }

    public void addAttribute(String key, double value, int decimalPlaces) {
        this.addAttribute(key, DOUBLE_FORMATS[decimalPlaces].format(value));
    }

    public void addAttribute(String key, double value, int decimalPlaces, String unit) {
        this.addAttribute(key, DOUBLE_FORMATS[decimalPlaces].format(value) + " " + unit);
    }

    public void addRawAttribute(String key, String rawValue) {
        this.attributeKeys.add(key);
        this.attributeValues.add(rawValue);
    }

    public void addRawContent(String s) {
        this.contents.append(s);
    }

    public void addSection(String title) {
        if (this.inSection) {
            this.contents.append(this.outputFormat.endSection2());
        }
        this.contents.append(this.outputFormat.startSection2(title));
        this.inSection = true;
    }

    public void addLink(String url, String text) {
        this.addRawContent("<p>" + HTML.getLink(url, text) + "</p>\n");
    }

    public void add(ChartImage chart) {
        if (chart == null) {
            return;
        }
        this.addRawContent("<p class=\"chart\"><img src=\"" + HTML.escape(chart.getURL()) + "\" alt=\"" + HTML.escape(chart.getFullTitle()) + "\" width=\"" + chart.getWidth() + "\" height=\"" + chart.getHeight() + "\" /></p>");
        chart.write();
    }

    public void add(ChartImage chart, String linkURL) {
        if (chart == null) {
            return;
        }
        this.addRawContent("<p class=\"chart\"><a href=\"" + HTML.escape(linkURL) + "\"><img src=\"" + HTML.escape(chart.getURL()) + "\" alt=\"" + HTML.escape(chart.getFullTitle()) + "\" width=\"" + chart.getWidth() + "\" height=\"" + chart.getHeight() + "\" /></a></p>");
        chart.write();
    }

    public void add(TableReport table) {
        table.calculate();
        this.addRawContent(new TableRenderer(table.getTable(), this.outputFormat).getRenderedTable());
    }

    public void add(Directory directory, boolean withRootLinks) {
        this.addRawContent(new DirectoryTreeFormatter(directory, withRootLinks).getFormatted());
    }

    public void add(PageGroup pages) {
        this.addRawContent(pages.asLinkList());
        this.addChild(pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void write() {
        block14: {
            if (this.written) {
                return;
            }
            if (this.inSection) {
                this.contents.append(this.outputFormat.endSection2());
            }
            it = this.children.iterator();
            while (it.hasNext()) {
                page = (NavigationNode)it.next();
                page.write();
            }
            fileWithExtension = this.fileName + "." + this.config.getMarkup().getExtension();
            Page.logger.info("writing page '" + this.fullTitle + "' to " + fileWithExtension);
            w = null;
            try {
                w = new FileWriter(this.config.getRootDirectory() + fileWithExtension);
                w.write(this.outputFormat.getHeader(this.fullTitle, this.config.getCssHandler().getLink(), this.config.getCharSet()));
                w.write(this.outputFormat.startSection1(this.fullTitle));
                w.write(this.getLinkToParent());
                w.write(this.getNavigationLinks());
                w.write(this.getAttributes());
                w.write(this.contents.toString());
                w.write(this.getLinkToPreviousSibling());
                w.write(this.outputFormat.endSection1());
                w.write(this.getGeneratedByBlock());
                w.write(this.outputFormat.getEndOfPage());
                var6_4 = null;
                ** if (w == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        Page.logger.warning(e.getMessage());
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    w.close();
                }
                catch (IOException e) {
                    Page.logger.warning(e.getMessage());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (IOException ex) {
                    Page.logger.warning(ex.getMessage());
                    var6_5 = null;
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (IOException e) {
                            Page.logger.warning(e.getMessage());
                        }
                    }
                }
            }
        }
        this.written = true;
        this.contents = null;
    }

    public String asParentLink() {
        String result = "&#171; " + HTML.getLink(this.getURL(), this.getShortTitle());
        if (this.parent != null) {
            result = this.parent.asParentLink() + " " + result;
        }
        return result;
    }

    private String getLinkToParent() {
        if (this.parent == null) {
            return "";
        }
        return "<div id=\"parentlink\">" + this.parent.asParentLink() + "</div>\n";
    }

    private String getNavigationLinks() {
        if (this.siblingsTitle == null || this.siblings.isEmpty()) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        s.append(this.outputFormat.startSection2(this.siblingsTitle, "nav"));
        s.append("<ul>\n");
        Iterator it = this.siblings.iterator();
        while (it.hasNext()) {
            NavigationNode sibling = (NavigationNode)it.next();
            s.append("    <li>");
            if (sibling == this) {
                s.append("<span class=\"here\">" + HTML.escape(sibling.getShortTitle()) + "</span>");
            } else {
                s.append(HTML.getLink(sibling.getURL(), sibling.getShortTitle()));
            }
            s.append("</li>\n");
        }
        s.append("</ul>\n");
        s.append(this.outputFormat.endSection2());
        return s.toString();
    }

    private String getAttributes() {
        if (this.attributeKeys.isEmpty()) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        s.append("<dl class=\"attributes\">\n");
        for (int i = 0; i < this.attributeKeys.size(); ++i) {
            String key = (String)this.attributeKeys.get(i);
            String value = (String)this.attributeValues.get(i);
            s.append("    <dt>" + HTML.escape(key) + ":</dt>\n");
            s.append("    <dd>" + value + "</dd>\n");
        }
        s.append("</dl>\n");
        return s.toString();
    }

    private String getGeneratedByBlock() {
        StringBuffer s = new StringBuffer();
        s.append("<div id=\"generatedby\">");
        s.append(Messages.getString("PAGE_GENERATED_BY"));
        s.append(" ");
        s.append(HTML.getLink(Messages.getString("PROJECT_URL"), Messages.getString("PROJECT_SHORTNAME")) + " " + Messages.getString("PROJECT_VERSION"));
        s.append("</div>\n");
        return s.toString();
    }

    private String getLinkToPreviousSibling() {
        if (!this.showLinkToPreviousSibling) {
            return "";
        }
        NavigationNode sibling = this.findPreviousSibling();
        if (sibling == null) {
            return "";
        }
        return "<p class=\"previous\">" + HTML.getLink(sibling.getURL(), sibling.getShortTitle()) + " &#187; </p>\n";
    }

    private NavigationNode findPreviousSibling() {
        Iterator it = this.siblings.iterator();
        while (it.hasNext()) {
            NavigationNode sibling = (NavigationNode)it.next();
            if (sibling != this) continue;
            if (!it.hasNext()) {
                return null;
            }
            return (NavigationNode)it.next();
        }
        return null;
    }
}

