/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.Calendar;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.LOCChartMaker;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.pages.PageGroup;
import net.sf.statcvs.reports.TagReport;
import net.sf.statcvs.reports.TopDevelopersTableReport;

public class IndexPageMaker {
    private final ReportConfig config;
    private final Repository repository;
    private final String notesHTML;
    private final PageGroup reports;

    public IndexPageMaker(ReportConfig config, String notesHTML, PageGroup reports) {
        this.config = config;
        this.repository = config.getRepository();
        this.notesHTML = notesHTML;
        this.reports = reports;
    }

    public Page toFile() {
        ChartImage chart = new LOCChartMaker.MainLOCChartMaker(this.config, "loc_small.png", this.config.getSmallChartSize()).toFile();
        TopDevelopersTableReport topDevelopers = new TopDevelopersTableReport(this.config);
        String title = Messages.getString("INDEX_TITLE") + " " + this.config.getProjectName();
        Page page = this.config.createPage("index", title, title);
        page.addAttribute("Generated", Calendar.getInstance().getTime());
        String headRevisionNumber = this.getHeadRevisionNumber();
        if (headRevisionNumber != null && headRevisionNumber.indexOf(46) < 0) {
            page.addAttribute("Head revision", headRevisionNumber);
        }
        page.addRawAttribute("Report Period", this.getReportPeriod());
        page.addAttribute("Total Files", this.getCurrentFileCount());
        page.addAttribute("Total Lines of Code", this.repository.getCurrentLOC());
        page.addAttribute("Developers", topDevelopers.getDeveloperCount());
        if (this.notesHTML != null) {
            page.addRawContent(this.notesHTML);
        }
        page.add(this.reports);
        if (chart != null) {
            page.addSection(Messages.getString("LOC_TITLE"));
            page.add(chart, "loc.html");
        }
        if (topDevelopers.getDeveloperCount() > 1) {
            if (topDevelopers.getDeveloperCount() > 10) {
                page.addSection(Messages.getString("SECTION_TOP_AUTHORS"));
            } else {
                page.addSection("Developers");
            }
            page.add(topDevelopers);
            page.addRawContent(HTML.getLink("developers.html", Messages.getString("NAVIGATION_MORE")));
        }
        if (!this.repository.getSymbolicNames().isEmpty()) {
            page.addSection("Repository Tags");
            page.add(new TagReport(this.config));
        }
        page.addSection("Directories");
        page.add(this.repository.getRoot(), false);
        return page;
    }

    private String getReportPeriod() {
        return HTML.getDate(this.repository.getFirstDate()) + " to " + HTML.getDate(this.repository.getLastDate());
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }

    private String getHeadRevisionNumber() {
        Revision headRevision = (Revision)this.repository.getRevisions().last();
        if (headRevision != null) {
            return headRevision.getRevisionNumber();
        }
        return null;
    }
}

