/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.Set;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class TracIntegration
implements WebRepositoryIntegration {
    private String baseUrl;

    public TracIntegration(String baseURL) {
        this.baseUrl = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public String getName() {
        return "Trac";
    }

    public String getDirectoryUrl(Directory directory) {
        return this.baseUrl + "/browser/" + directory.getPath();
    }

    public String getFileHistoryUrl(VersionedFile file) {
        return this.baseUrl + "/log/" + file.getFilenameWithPath();
    }

    public String getFileViewUrl(Revision revision) {
        return this.baseUrl + "/browser/" + revision.getFile().getFilenameWithPath() + "?rev=" + revision.getRevisionNumber();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getDiffUrl(Revision oldRevision, Revision newRevision) {
        return this.baseUrl + "/changeset?" + "old=" + oldRevision.getRevisionNumber() + "@" + oldRevision.getFile().getFilenameWithPath() + "&new=" + newRevision.getRevisionNumber() + "@" + newRevision.getFile().getFilenameWithPath();
    }

    public String getFileViewUrl(VersionedFile file) {
        return this.baseUrl + "/browser/" + file.getFilenameWithPath();
    }

    public void setAtticFileNames(Set atticFileNames) {
    }
}

