/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.HashSet;
import java.util.Set;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class ChoraIntegration
implements WebRepositoryIntegration {
    private String baseURL;
    private Set atticFileNames = new HashSet();

    public ChoraIntegration(String baseURL) {
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public String getName() {
        return "Chora";
    }

    public String getDirectoryUrl(Directory directory) {
        return this.baseURL + "/" + directory.getPath();
    }

    public String getFileHistoryUrl(VersionedFile file) {
        if (this.isInAttic(file)) {
            String path = file.getDirectory().getPath();
            String filename = file.getFilename();
            return this.baseURL + "/" + path + "Attic/" + filename;
        }
        return this.baseURL + "/" + file.getFilenameWithPath();
    }

    public String getFileViewUrl(VersionedFile file) {
        return this.getFileHistoryUrl(file) + "?r=HEAD";
    }

    public String getFileViewUrl(Revision revision) {
        return this.getFileHistoryUrl(revision.getFile()) + "?r=" + revision.getRevisionNumber();
    }

    public String getDiffUrl(Revision oldRevision, Revision newRevision) {
        if (!oldRevision.getFile().equals(newRevision.getFile())) {
            throw new IllegalArgumentException("revisions must be of the same file");
        }
        return this.getFileHistoryUrl(oldRevision.getFile()) + "?r1=" + oldRevision.getRevisionNumber() + "&r2=" + newRevision.getRevisionNumber();
    }

    public void setAtticFileNames(Set atticFileNames) {
        this.atticFileNames = atticFileNames;
    }

    private boolean isInAttic(VersionedFile file) {
        return this.atticFileNames.contains(file.getFilenameWithPath());
    }

    public String getBaseUrl() {
        return this.baseURL;
    }
}

