/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public abstract class TimeBarChartMaker {
    private final ReportConfig config;
    private final SortedSet revisions;
    private final String title;
    private final String fileName;
    private final String[] barLabels;

    public TimeBarChartMaker(ReportConfig config, SortedSet revisions, String title, String fileName, String[] barLabels) {
        this.config = config;
        this.revisions = revisions;
        this.title = title;
        this.fileName = fileName;
        this.barLabels = barLabels;
    }

    public ChartImage toFile() {
        int[] barValues = new int[this.barLabels.length];
        for (int i = 0; i < barValues.length; ++i) {
            barValues[i] = 0;
        }
        Iterator it = this.revisions.iterator();
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            Date date = rev.getDate();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            int n = this.barNumberForTime(cal);
            barValues[n] = barValues[n] + 1;
        }
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        for (int i = 0; i < barValues.length; ++i) {
            data.addValue(barValues[i], (Comparable)((Object)"Commits"), (Comparable)((Object)this.barLabels[i]));
        }
        JFreeChart chart = ChartFactory.createBarChart(this.config.getProjectName() + ": " + this.title, "", "Commits", data, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.getRenderer().setSeriesPaint(0, Color.blue);
        return this.config.createChartImage(this.fileName, this.title, chart, this.config.getSmallChartSize());
    }

    protected abstract int barNumberForTime(Calendar var1);

    public static class WeekdayBarChartMaker
    extends TimeBarChartMaker {
        private static final String[] WEEKDAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

        public WeekdayBarChartMaker(ReportConfig config, SortedSet revisions, String title, String fileName) {
            super(config, revisions, title, fileName, WEEKDAYS);
        }

        protected int barNumberForTime(Calendar time) {
            return time.get(7) - 1;
        }
    }

    public static class HourBarChartMaker
    extends TimeBarChartMaker {
        private static final String[] HOURS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};

        public HourBarChartMaker(ReportConfig config, SortedSet revisions, String title, String fileName) {
            super(config, revisions, title, fileName, HOURS);
        }

        protected int barNumberForTime(Calendar time) {
            return time.get(11);
        }
    }
}

