/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartImage {
    private static final Logger logger = Logger.getLogger("sf.net.statcvs");
    private static final Color BACKGROUND_COLOR = new Color(204, 204, 187);
    private final String rootDirectory;
    private JFreeChart chart;
    private final String fileName;
    private final Dimension size;
    private final String title;
    private boolean written = false;

    public ChartImage(String rootDirectory, String fileName, String title, JFreeChart chart, Dimension size) {
        this.rootDirectory = rootDirectory;
        this.fileName = fileName;
        this.title = title;
        this.chart = chart;
        this.size = size;
        chart.setBackgroundPaint(BACKGROUND_COLOR);
    }

    public void write() {
        if (this.written) {
            return;
        }
        logger.info("writing chart '" + this.title + "' to " + this.fileName);
        try {
            ChartUtilities.saveChartAsPNG(new File(this.rootDirectory + this.fileName), this.chart, this.size.width, this.size.height);
        }
        catch (IOException e) {
            logger.warning("could not write chart '" + this.fileName + "': " + e);
        }
        this.written = true;
        this.chart = null;
    }

    public String getURL() {
        return this.fileName;
    }

    public String getFullTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }
}

