/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import yoyo.Context;
import yoyo.Function;
import yoyo.Listener;
import yoyo.NTEStream;
import yoyo.Symbol;
import yoyo.UberContext;
import yoyo.YoYo;

public class Toplevel
extends Frame
implements ActionListener,
ItemListener,
ClipboardOwner {
    static String[] sizes = new String[]{"6", "8", "9", "10", "11", "12", "14", "16", "18", "24", "36", "48", "72"};
    public static String bootfile;
    public static String bootpath;
    static Clipboard clip;
    public static UberContext ub;
    public static URL base;
    public Context c;
    public Listener cc;
    CheckboxMenuItem currentfont;
    CheckboxMenuItem currentsize;
    public boolean firstone;

    public void loadBootFile() {
        if (this.firstone && bootfile != null) {
            this.cc.runLine("load \"file:" + Toplevel.quote(bootfile) + "\"");
            this.c.waitUntilDone();
            if (bootpath != null) {
                this.cc.runLine("cd \"file:" + Toplevel.quote(bootpath) + "\"");
                this.c.waitUntilDone();
            }
            this.runStartup();
        }
    }

    public void runStartup() {
        Object object = null;
        object = this.c.getGlobalObj().lookupValue(Symbol.lookup("startup"));
        if (object != null && object instanceof Function) {
            this.cc.runLine("startup");
        }
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Toplevel.readArgs(stringArray);
        Toplevel toplevel = new Toplevel("YoYo", true);
    }

    public static void readArgs(String[] stringArray) {
        if (stringArray.length > 1) {
            bootpath = stringArray[0].trim();
            if (bootpath.equals("")) {
                bootpath = null;
            }
            if ((bootfile = stringArray[1].trim()).equals("")) {
                bootfile = null;
            }
        } else if (stringArray.length > 0 && (bootfile = stringArray[0].trim()).equals("")) {
            bootfile = null;
        }
    }

    void appInit() {
        try {
            base = new URL("file", "", System.getProperty(YoYo.pcp ? "user.home" : "user.dir") + "/");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        ub = new UberContext(base);
    }

    public void windowInit() {
        this.createComponents();
        this.addComponentsToLayout();
        this.addListeners();
        this.setupMenus();
        this.cc.requestFocus();
        this.sendWelcome();
    }

    public void createComponents() {
        this.cc = new Listener();
        this.cc.c = this.c = new Context(null, base, new PrintWriter(new NTEStream(this.cc), true), this.cc, ub);
    }

    public void addComponentsToLayout() {
        this.add(this.cc);
        this.pack();
        this.show();
    }

    public void addListeners() {
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Toplevel this$0;

            public final void windowClosing(WindowEvent windowEvent) {
                this.this$0.c.die();
                windowEvent.getWindow().dispose();
                System.exit(0);
            }
            {
                this.this$0 = toplevel;
                this.constructor$0(toplevel);
            }

            private final void constructor$0(Toplevel toplevel) {
            }
        });
        this.cc.addKeyListener(new KeyAdapter(this){
            private final /* synthetic */ Toplevel this$0;

            public final void keyPressed(KeyEvent keyEvent) {
                Listener listener = (Listener)keyEvent.getComponent();
                char c = keyEvent.getKeyChar();
                if (listener.c.runningnowp) {
                    listener.c.stop();
                    keyEvent.consume();
                    return;
                }
                if (!(c != '\n' && c != '\r' || keyEvent.isShiftDown())) {
                    listener.handlecr();
                    keyEvent.consume();
                }
                if (c == '\t') {
                    listener.c.out.print("   ");
                    listener.c.out.flush();
                    keyEvent.consume();
                }
            }

            public final void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\n' || c == '\r') {
                    if (!keyEvent.isShiftDown()) {
                        keyEvent.consume();
                    }
                } else if (c == '\t') {
                    keyEvent.consume();
                }
            }
            {
                this.this$0 = toplevel;
                this.constructor$0(toplevel);
            }

            private final void constructor$0(Toplevel toplevel) {
            }
        });
    }

    public void sendWelcome() {
        this.c.out.println("Welcome to YoYo!");
    }

    void setupMenus() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Edit");
        Menu menu3 = new Menu("Font");
        Menu menu4 = new Menu("Size");
        this.setupFileMenu(menu);
        menuBar.add(menu);
        this.setupEditMenu(menu2);
        menuBar.add(menu2);
        this.setupFontMenu(menu3);
        menuBar.add(menu3);
        this.setupSizeMenu(menu4);
        menuBar.add(menu4);
        this.setMenuBar(menuBar);
    }

    void setupFileMenu(Menu menu) {
        MenuItem menuItem = new MenuItem("New", new MenuShortcut(78));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Open...", new MenuShortcut(79));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Open URL...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem("New Listener");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Close Listener", new MenuShortcut(87));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        if (!YoYo.macosxp) {
            menu.addSeparator();
            menuItem = new MenuItem("Quit", new MenuShortcut(81));
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
    }

    void setupEditMenu(Menu menu) {
        MenuItem menuItem = new MenuItem("Undo", new MenuShortcut(90));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Cut", new MenuShortcut(88));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Copy", new MenuShortcut(67));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Paste", new MenuShortcut(86));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem("Select All", new MenuShortcut(65));
        menuItem.addActionListener(this);
        menu.add(menuItem);
    }

    void setupFontMenu(Menu menu) {
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(stringArray[n]);
            checkboxMenuItem.addItemListener(this);
            checkboxMenuItem.setFont(new Font(stringArray[n], 0, 11));
            if (stringArray[n].equals("Monospaced")) {
                checkboxMenuItem.setState(true);
                this.currentfont = checkboxMenuItem;
            }
            menu.add(checkboxMenuItem);
            ++n;
        }
    }

    void setupSizeMenu(Menu menu) {
        int n = 0;
        while (n < sizes.length) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(sizes[n]);
            checkboxMenuItem.addItemListener(this);
            if (sizes[n].equals("12")) {
                checkboxMenuItem.setState(true);
                this.currentsize = checkboxMenuItem;
            }
            menu.add(checkboxMenuItem);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        String string = menuItem.getLabel();
        if (string.equals("New Listener")) {
            new Toplevel("YoYo", false);
            return;
        }
        if (string.equals("Close Listener")) {
            this.c.die();
            this.dispose();
        }
        if (string.equals("Quit")) {
            System.exit(0);
            return;
        }
        if (string.equals("Cut")) {
            String string2 = this.cc.getSelectedText();
            if (string2.equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string2);
            clip.setContents(stringSelection, this);
            int n = this.cc.getSelectionStart();
            this.cc.replaceRange("", n, this.cc.getSelectionEnd());
            this.cc.select(n, n);
            return;
        }
        if (string.equals("Copy")) {
            String string3 = this.cc.getSelectedText();
            if (string3.equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string3);
            clip.setContents(stringSelection, this);
            return;
        }
        if (string.equals("Paste")) {
            Transferable transferable = clip.getContents(this);
            if (transferable != null) {
                try {
                    Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                    if (object instanceof String) {
                        String string4 = (String)object;
                        int n = string4.length();
                        int n2 = this.cc.getCaretPosition();
                        if (n == 0) {
                            this.cc.insert(string4, n2);
                            this.cc.select(n2 + n, n2 + n);
                        } else {
                            int n3 = this.cc.getSelectionStart();
                            this.cc.replaceRange(string4, n3, this.cc.getSelectionEnd());
                            this.cc.select(n3 + n, n3 + n);
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return;
        }
        if (string.equals("Select All")) {
            this.cc.selectAll();
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        String string = checkboxMenuItem.getLabel();
        try {
            int n = Integer.parseInt(string);
            Font font = this.cc.getFont();
            this.cc.setFont(new Font(font.getName(), font.getStyle(), n));
            this.currentsize.setState(false);
            checkboxMenuItem.setState(true);
            this.currentsize = checkboxMenuItem;
            return;
        }
        catch (Exception exception) {
            Font font = this.cc.getFont();
            this.cc.setFont(new Font(string, font.getStyle(), font.getSize()));
            this.currentfont.setState(false);
            checkboxMenuItem.setState(true);
            this.currentfont = checkboxMenuItem;
            return;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public Toplevel(String string, boolean bl) {
        super(string);
        YoYo.yoyoframe = this;
        this.firstone = bl;
        if (bl) {
            this.appInit();
        }
        this.windowInit();
        String string2 = this.c.toString();
        if (!bl) {
            this.setTitle(string2.substring(1, string2.length() - 1));
        }
        this.loadBootFile();
    }

    static {
        clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        base = null;
    }
}

