/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.Reader;
import yoyo.UberContext;
import yoyo.YoYoCaller;

class PromptedListener
implements Runnable,
YoYoCaller {
    static String prompt = "> ";
    BufferedReader in;
    PrintWriter out;
    boolean done = true;
    UberContext ub;
    Context c;
    volatile boolean wait = true;

    public void run() {
        String string = "";
        try {
            while (true) {
                this.print(prompt);
                String string2 = string + this.in.readLine();
                string2 = string2.trim();
                this.wait = true;
                if (string2.equals("")) {
                    this.println();
                    return;
                }
                if (string2.equals("?")) {
                    this.printHelp();
                    continue;
                }
                if (string2.equals("#logout") || string2.equals("exit") || string2.equals("bye")) {
                    this.ub.logoutUser();
                    this.in.close();
                    this.out.close();
                    return;
                }
                if (string2.equals("#detach")) {
                    this.in.close();
                    this.out.close();
                    return;
                }
                if (string2.startsWith("#attach ")) {
                    this.attach(string2);
                    continue;
                }
                if (string2.startsWith("#destroy ")) {
                    boolean bl = this.destroy(string2);
                    if (!bl) continue;
                    this.in.close();
                    this.out.close();
                    return;
                }
                this.runLine(string2);
                string = this.waitUntilOver();
            }
        }
        catch (IOException iOException) {
            this.println("error reading line from input");
            LogoError.error("Error reading line from input");
            return;
        }
    }

    public String waitUntilOver() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (this.wait) {
                if (this.in.ready()) {
                    int n = this.in.read();
                    stringBuffer.append((char)n);
                    continue;
                }
                Thread.currentThread();
                Thread.yield();
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            this.println("error reading line from input");
            LogoError.error("Error reading line from input");
            return null;
        }
    }

    void runLine(String string) {
        Object[] objectArray = Reader.read(string);
        this.c.runList(objectArray);
    }

    public void done(Context context) {
        this.wait = false;
    }

    public void println(String string) {
        this.out.println(string);
    }

    public void print(String string) {
        this.out.print(string);
        this.out.flush();
    }

    public void println() {
        this.out.println();
    }

    public void attach(String string) {
        string = string.substring(7).trim();
        try {
            int n = Integer.parseInt(string);
            UberContext uberContext = UberContext.getUberContext(n);
            if (uberContext != null) {
                this.ub = uberContext;
                this.c = uberContext.mainc;
                this.c.out = this.out;
                this.c.caller = this;
            } else {
                this.out.println("Sorry, context #" + n + " does not exist.");
            }
        }
        catch (Exception exception) {
            this.out.println(string + " is not a number");
        }
    }

    public boolean destroy(String string) {
        string = string.substring(8).trim();
        try {
            int n = Integer.parseInt(string);
            UberContext uberContext = UberContext.getUberContext(n);
            if (uberContext != null) {
                uberContext.logoutUser();
                return this.ub == uberContext;
            }
            this.out.println("Sorry, context #" + n + " does not exist.");
        }
        catch (Exception exception) {
            this.out.println(string + " is not a number");
        }
        return false;
    }

    public void printHello() {
        this.println("Welcome to YoYo!");
        this.println("You are in context #" + this.ub.id);
        this.println("Type '?' for help.");
        this.println();
    }

    public void printHelp() {
        this.println("You are in context #" + this.ub.id);
        this.println();
        this.println("Type any YoYo command or type '#logout' to exit.");
        this.println("Type '#attach <num>' to switch into a particular YoYo context.");
        this.println("Type '#detach' to exit YoYo and leave this context running.");
        this.println("Type '#destroy <num>' to destroy a particular context.");
        this.println("Type '?' for this help screen.");
        this.println();
    }

    PromptedListener(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.in = bufferedReader;
        this.out = printWriter;
    }
}

