/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import yoyo.CompoundSymbol;
import yoyo.Context;
import yoyo.Function;
import yoyo.Ilist;
import yoyo.LocalRef;
import yoyo.LogoError;
import yoyo.PrimFile;
import yoyo.Primitive;
import yoyo.Reader;
import yoyo.Sym;
import yoyo.Symbol;
import yoyo.TextDialog;
import yoyo.Ufun;
import yoyo.YoYo;
import yoyo.YoYoMethods;

public class Primitives
implements YoYoMethods {
    public String[] methodList() {
        String[] stringArray = new String[]{"print", "prim_print", "show", "prim_print", "type", "prim_type", "resett", "prim_resett", "timer", "prim_timer", "freememory", "prim_freememory", "not", "prim_not", "ignore", "prim_ignore", "system-quit", "prim_system_quit", "symbol?", "prim_symbolp", "boolean?", "prim_booleanp", ":", "prim_delay", "lambda", "prim_lambda", "to-string", "prim_to_string", "unquote", "prim_unquote", "ilist?", "prim_ilistp", "ilist-to-list", "prim_ilisttolist", "list-to-ilist", "prim_listtoilist", "ascii-to-integer", "prim_a2i", "integer-to-ascii", "prim_i2a", "trace", "prim_trace", "untrace", "prim_untrace", "get-string", "prim_get_string", "untrace-all", "prim_untrace_all", "load-sound", "prim_load_sound", "setup-sound", "prim_setup_sound", "play-sound", "prim_play_sound", "stop-sound", "prim_stop_sound", "system-os", "prim_system_os", "system-applet?", "prim_system_appletp", "system-language", "prim_system_language", "system-print", "prim_system_print", "system-type", "prim_system_type"};
        return stringArray;
    }

    public String[] infixList() {
        return null;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static void prim_print(Object object, Context context) {
        context.out.println(YoYo.printToString(object));
    }

    public static void prim_type(Object object, Context context) {
        context.out.print(YoYo.printToString(object));
    }

    public static void prim_system_print(Object object, Context context) {
        System.out.println(YoYo.printToString(object));
    }

    public static void prim_system_type(Object object, Context context) {
        System.out.print(YoYo.printToString(object));
    }

    public static Object prim_symbolp(Object object, Context context) {
        return object instanceof Sym || object instanceof LocalRef ? YoYo.symtrue : YoYo.symfalse;
    }

    public static Object prim_booleanp(Object object, Context context) {
        return object == YoYo.symtrue || object == YoYo.symfalse ? YoYo.symtrue : YoYo.symfalse;
    }

    public static Object prim_delay(Context context) {
        Object object = context.ilistNext();
        if (object instanceof Function) {
            return object;
        }
        if (object instanceof Symbol) {
            return YoYo.getSymbolValue(context, (Symbol)object, context);
        }
        if (object instanceof LocalRef) {
            return context.locals.lookupValue((LocalRef)object);
        }
        if (object instanceof CompoundSymbol) {
            return YoYo.getCompoundValue((CompoundSymbol)object, context);
        }
        return object;
    }

    public static Object prim_lambda(Object object, Object object2, Context context) {
        if (object instanceof Object[]) {
            Symbol[] symbolArray = new Symbol[((Object[])object).length];
            System.arraycopy((Object[])object, 0, symbolArray, 0, symbolArray.length);
            Object[] objectArray = YoYo.aList(context, object2);
            Symbol[] symbolArray2 = PrimFile.readlocals(symbolArray, new Symbol[0], objectArray, 0);
            return new Ufun(symbolArray, symbolArray2, objectArray, context.ufunenv);
        }
        LogoError.error(object + " is not a list", context);
        return null;
    }

    public static Object prim_unquote(Object object, Context context) {
        if (object instanceof String) {
            return Reader.read((String)object)[0];
        }
        return object;
    }

    public static void prim_resett(Context context) {
        context.time = System.currentTimeMillis();
    }

    public static Object prim_timer(Context context) {
        return new Double((double)(System.currentTimeMillis() - context.time) / 1000.0);
    }

    public static void prim_ignore(Object object, Context context) {
    }

    public static Object prim_freememory(Context context) {
        return new Integer((int)Runtime.getRuntime().freeMemory());
    }

    public static Object prim_not(Object object, Context context) {
        if (YoYo.aBoolean(context, object)) {
            return YoYo.symfalse;
        }
        return YoYo.symtrue;
    }

    public static void prim_system_quit(Context context) {
        Runtime.getRuntime().exit(0);
    }

    public static Object prim_to_string(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        Object[] objectArray2 = context.ilist;
        int n = context.ilistposptr;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            context.ilist = objectArray;
            context.ilistposptr = 0;
            while (context.ilistPeek() != null) {
                stringBuffer.append(YoYo.aString(context, YoYo.evalOneFromHere(context)));
            }
            String string = stringBuffer.toString();
            Object var7_7 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
            throw throwable;
        }
    }

    public static Object prim_ilistp(Object object, Context context) {
        if (object instanceof Ilist) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_ilisttolist(Object object, Context context) {
        if (object instanceof Ilist) {
            return ((Ilist)object).list;
        }
        LogoError.error(object + " is not an ilist");
        return null;
    }

    public static Object prim_listtoilist(Object object, Context context) {
        return YoYo.aIlist(context, object);
    }

    public static Object prim_a2i(Object object, Context context) {
        String string = YoYo.aString(context, object);
        return new Integer(string.charAt(0));
    }

    public static Object prim_i2a(Object object, Context context) {
        int n = YoYo.aInteger(context, object);
        char[] cArray = new char[]{(char)n};
        return new String(cArray);
    }

    public static void prim_trace(Object object, Context context) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                Primitives.traceObj(objectArray[n], context);
                ++n;
            }
        } else {
            Primitives.traceObj(object, context);
        }
    }

    static void traceObj(Object object, Context context) {
        if (object instanceof Function) {
            ((Function)object).trace();
            Vector vector = context.trace((Function)object);
            context.out.println("Tracing " + YoYo.vectorToString(vector));
            return;
        }
        if (object instanceof String) {
            Sym sym = YoYo.aSym(context, Reader.read(YoYo.aString(context, object))[0]);
            Object object2 = YoYo.lookupSymbol(sym, context);
            if (object2 == null) {
                LogoError.error("i don't know how to " + YoYo.printToString(object), context);
            }
            if (object2 instanceof Function) {
                ((Function)object2).trace();
                Vector vector = context.trace((Function)object2);
                context.out.println("Tracing " + YoYo.vectorToString(vector));
                return;
            }
        }
        LogoError.error(YoYo.printToString(object) + " is not a procedure", context);
    }

    public static void prim_untrace(Object object, Context context) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                Primitives.untraceObj(objectArray[n], context);
                ++n;
            }
        } else {
            Primitives.untraceObj(object, context);
        }
    }

    public static void untraceObj(Object object, Context context) {
        if (object instanceof Function) {
            ((Function)object).untrace();
            Vector vector = context.untrace((Function)object);
            context.out.println("Tracing " + YoYo.vectorToString(vector));
            return;
        }
        if (object instanceof String) {
            Sym sym = YoYo.aSym(context, Reader.read(YoYo.aString(context, object))[0]);
            Object object2 = YoYo.lookupSymbol(sym, context);
            if (object2 == null) {
                LogoError.error("i don't know how to " + YoYo.printToString(object), context);
            }
            if (object2 instanceof Function) {
                ((Function)object2).untrace();
                Vector vector = context.untrace((Function)object2);
                context.out.println("Tracing " + YoYo.vectorToString(vector));
                return;
            }
        }
        LogoError.error(YoYo.printToString(object) + " is not a procedure", context);
    }

    public static void prim_untrace_all(Context context) {
        context.untraceAll();
    }

    public static Object prim_get_string(Object object, Context context) {
        String string;
        if (YoYo.yoyoframe != null) {
            String string2 = YoYo.aString(context, object);
            TextDialog textDialog = new TextDialog(YoYo.yoyoframe, "YoYo Input", string2);
            String string3 = textDialog.getResult();
            if (string3 == null) {
                return YoYo.symfalse;
            }
            return string3;
        }
        Frame frame = Primitives.frameParent(YoYo.applet);
        TextDialog textDialog = new TextDialog(frame, "YoYo Input", string = YoYo.aString(context, object));
        String string4 = textDialog.getResult();
        if (string4 == null) {
            return YoYo.symfalse;
        }
        return string4;
    }

    public static Frame frameParent(Applet applet) {
        Container container = applet.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public static void prim_play_sound(Object object, Context context) {
    }

    public static void prim_stop_sound(Object object, Context context) {
    }

    public static Object prim_setup_sound(Object object, Context context) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object prim_load_sound(Object object, Context context) {
        URL uRL = null;
        try {
            uRL = new URL(YoYo.aString(context, object));
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.getFile();
                File file = new File(string);
                try {
                    if (!file.canRead()) {
                        LogoError.error(YoYo.printToString(object) + " is not readable");
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LogoError.error(fileNotFoundException.getMessage(), context);
                    return null;
                }
            }
            try {
                Object var6_17;
                InputStream inputStream = null;
                try {
                    try {
                        URLConnection uRLConnection = uRL.openConnection();
                        inputStream = uRLConnection.getInputStream();
                        var6_17 = null;
                        Object var5_12 = null;
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        System.out.println(exception.getMessage());
                        LogoError.error(exception.getMessage(), context);
                        Object var5_13 = null;
                        inputStream.close();
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_14 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return var6_17;
            }
            catch (IOException iOException) {
                LogoError.error("error reading url " + uRL, context);
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            LogoError.error("url " + YoYo.aString(context, object) + " does not exist", context);
            return null;
        }
        catch (Exception exception) {
            context.err.println("load sound: uh oh " + exception);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readStream(InputStream var0, int var1_1, Context var2_2) {
        block14: {
            block13: {
                var3_3 = null;
                if (var1_1 < 0) {
                    var1_1 = 4096;
                }
                var4_4 = new byte[var1_1];
                var5_5 = 0;
                try {
                    try {
                        var3_3 = new BufferedInputStream(var0, var1_1);
                        var10_6 = new byte[var1_1];
                        while ((var11_8 = var3_3.read(var10_6, 0, var1_1)) >= 0) {
                            if (var5_5 + var11_8 > var4_4.length) {
                                var12_10 = new byte[var4_4.length * 2];
                                System.arraycopy(var4_4, 0, var12_10, 0, var4_4.length);
                                var4_4 = var12_10;
                            }
                            System.arraycopy(var10_6, 0, var4_4, var5_5, var11_8);
                            var5_5 += var11_8;
                            if (var3_3.available() > 0) continue;
                        }
                        if (var5_5 <= var1_1) {
                            var8_11 = var10_6;
                            var7_13 = null;
                            if (var3_3 == null) return var8_11;
                            break block13;
                        }
                        var11_9 = new byte[var5_5];
                        System.arraycopy(var4_4, 0, var11_9, 0, var5_5);
                        var8_12 = var4_4;
                        break block14;
                    }
                    catch (IOException var10_7) {
                        LogoError.error(var10_7.getMessage(), var2_2);
                        var7_15 = null;
                        if (var3_3 == null) return null;
                        try {
                            var3_3.close();
                            return null;
                        }
                        catch (IOException var9_19) {
                            return null;
                        }
                    }
                }
                catch (Throwable var6_21) {
                    var7_16 = null;
                    if (var3_3 == null) throw var6_21;
                    ** try [egrp 2[TRYBLOCK] [2 : 187->194)] { 
lbl44:
                    // 1 sources

                    var3_3.close();
                    throw var6_21;
lbl46:
                    // 1 sources

                    catch (IOException var9_20) {
                        // empty catch block
                    }
                    throw var6_21;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 187->194)] { 
lbl51:
            // 1 sources

            var3_3.close();
            return var8_11;
lbl53:
            // 1 sources

            catch (IOException var9_17) {
                // empty catch block
            }
            return var8_11;
        }
        var7_14 = null;
        if (var3_3 == null) return var8_12;
        ** try [egrp 2[TRYBLOCK] [2 : 187->194)] { 
lbl60:
        // 1 sources

        var3_3.close();
        return var8_12;
lbl62:
        // 1 sources

        catch (IOException var9_18) {
            // empty catch block
        }
        return var8_12;
    }

    public static Object prim_system_os(Context context) {
        return System.getProperty("os.name");
    }

    public static Object prim_system_language(Context context) {
        switch (YoYo.language) {
            case 0: {
                return "english";
            }
            case 1: {
                return "spanish";
            }
        }
        return "unknown";
    }

    public static Object prim_system_appletp(Context context) {
        return YoYo.truefalse(YoYo.applet != null);
    }
}

