/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.Primitive;
import yoyo.YoYo;
import yoyo.YoYoMethods;

public class PrimTCP
implements YoYoMethods {
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");

    public String[] methodList() {
        String[] stringArray = new String[]{"tcp-open-receive", "prim_openserver", "tcp-accept", "prim_accept", "tcp-send-packet", "prim_sendpacket", "tcp-read-packet", "prim_readpacket", "tcp-close", "prim_closesocket"};
        return stringArray;
    }

    public String[] infixList() {
        return null;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static Object prim_openserver(Object object, Context context) {
        try {
            ServerSocket serverSocket = new ServerSocket(YoYo.aInteger(context, object));
            serverSocket.setSoTimeout(30);
            return serverSocket;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogoError.error("could not open socket on port: " + YoYo.printToString(object));
            return YoYo.symfalse;
        }
    }

    public static Object prim_accept(Object object, Context context) {
        while (true) {
            try {
                Socket socket = ((ServerSocket)object).accept();
                socket.setSoTimeout(20);
                return socket;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                LogoError.error("could not accept socket");
            }
            YoYo.pollStop(context);
        }
    }

    public static void prim_sendpacket(Object object, Object object2, Context context) {
        try {
            Socket socket = (Socket)object;
            Object[] objectArray = YoYo.aList(context, object2);
            OutputStream outputStream = socket.getOutputStream();
            byte[] byArray = PrimTCP.listToByteArray(objectArray);
            PrimTCP.writeInt(byArray.length, outputStream);
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogoError.error("could not send byte array " + YoYo.printToString(object2) + " to socket " + YoYo.printToString(object));
        }
    }

    public static byte[] listToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            byArray[n] = (byte)((Number)objectArray[n]).intValue();
            ++n;
        }
        return byArray;
    }

    public static Object[] byteArrayToList(byte[] byArray) {
        Object[] objectArray = new Object[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            objectArray[n] = new Integer(byArray[n] & 0xFF);
            ++n;
        }
        return objectArray;
    }

    public static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 24 & 0xFF));
        outputStream.write((byte)(n >> 16 & 0xFF));
        outputStream.write((byte)(n >> 8 & 0xFF));
        outputStream.write((byte)(n & 0xFF));
    }

    public static int readByte(InputStream inputStream, Context context) throws IOException {
        while (true) {
            try {
                return inputStream.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                YoYo.pollStop(context);
                continue;
            }
            break;
        }
    }

    public static int readInt(InputStream inputStream, Context context) throws IOException {
        return (PrimTCP.readByte(inputStream, context) & 0xFF) << 24 | (PrimTCP.readByte(inputStream, context) & 0xFF) << 16 | (PrimTCP.readByte(inputStream, context) & 0xFF) << 8 | PrimTCP.readByte(inputStream, context) & 0xFF;
    }

    public static Object prim_getstring(Object object, Context context) {
        try {
            Socket socket = (Socket)object;
            InputStream inputStream = socket.getInputStream();
            while (inputStream.available() < 4) {
                YoYo.pollStop(context);
            }
            int n = PrimTCP.readInt(inputStream, context);
            byte[] byArray = new byte[n];
            while (inputStream.available() < n) {
                YoYo.pollStop(context);
            }
            inputStream.read(byArray);
            return new String(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogoError.error("can't get string from socket " + YoYo.printToString(object));
            return YoYo.symfalse;
        }
    }

    public static Object prim_readpacket(Object object, Context context) {
        try {
            Socket socket = (Socket)object;
            InputStream inputStream = socket.getInputStream();
            int n = PrimTCP.readInt(inputStream, context);
            byte[] byArray = new byte[n];
            while (inputStream.available() < n) {
                YoYo.pollStop(context);
            }
            inputStream.read(byArray);
            return PrimTCP.byteArrayToList(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogoError.error("can't get string from socket " + YoYo.printToString(object));
            return YoYo.symfalse;
        }
    }

    public static void prim_closesocket(Object object, Context context) {
        try {
            if (object instanceof Socket) {
                ((Socket)object).close();
            } else if (object instanceof ServerSocket) {
                ((ServerSocket)object).close();
            } else {
                LogoError.error("can't tcp-close something that isn't a socket: " + YoYo.printToString(object));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogoError.error("can't close the socket. Java sucks.");
        }
    }
}

