/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import javax.swing.UIManager;
import starlogo.Interface;
import starlogo.StopWidget;
import starlogo.ToolTipWidget;
import starlogo.TrashWidget;
import starlogo.Widget;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class StatusToolbar
extends Widget {
    static final int MESSAGE_WIDTH = 300;
    private Interface iface;
    public Font font;
    FontMetrics fm;
    String statusMessage;
    StopWidget stopwidget;
    TrashWidget trashwidget;
    Integer xcor;
    Integer ycor;
    private ToolTipWidget coordinateToolTip;
    private ToolTipWidget statusToolTip;

    public void updatePosition() {
        this.position = new Rectangle(0, this.iface.getSize().height - this.iface.statusbarheight(), this.iface.getSize().width, this.iface.statusbarheight());
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        if (YoYo.macosxp) {
            graphics.setColor(UIManager.getColor("window"));
        } else {
            graphics.setColor(SystemColor.control);
        }
        graphics.fillRect(0, 0, this.iface.getSize().width, this.iface.statusbarheight());
        graphics.draw3DRect(17, 5, 28, 16, false);
        graphics.draw3DRect(62, 5, 28, 16, false);
        graphics.draw3DRect(95, 5, 300, 16, false);
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        graphics.drawString("X:", 5, 17);
        graphics.drawString("Y:", 50, 17);
        graphics.drawString(this.statusMessage, 100, 17);
        if (this.xcor != null && this.ycor != null) {
            graphics.drawString(this.xcor.toString(), 22, 17);
            graphics.drawString(this.ycor.toString(), 67, 17);
        }
        graphics.translate(-this.position.x, -this.position.y);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void setStatusMessage(String string) {
        if (string == null) {
            string = "";
        }
        while (this.fm.stringWidth(string) > 300) {
            string = string.substring(0, string.length() - 1);
        }
        this.statusMessage = string;
        this.iface.addToClipRect(this.position);
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
    }

    public void displayToolTip(Point point) {
        if (this.trashwidget.position.contains(point)) {
            this.trashwidget.displayToolTip(point);
            return;
        }
        if (this.stopwidget.position.contains(point)) {
            this.stopwidget.displayToolTip(point);
            return;
        }
        point.translate(-this.position.x, -this.position.y);
        if (point.x < 95) {
            this.coordinateToolTip.fixPosition(this.position.x + 5, this.position.y - this.coordinateToolTip.position.height - 2);
            this.setToolTip(this.coordinateToolTip);
            super.displayToolTip(point);
            return;
        }
        if (point.x > 95 && point.x < 400) {
            this.statusToolTip.fixPosition(this.position.x + 100, this.position.y - this.statusToolTip.position.height - 2);
            this.setToolTip(this.statusToolTip);
            super.displayToolTip(point);
            return;
        }
    }

    public void dropToolTip() {
        this.trashwidget.dropToolTip();
        this.stopwidget.dropToolTip();
        super.dropToolTip();
    }

    public StatusToolbar(Interface interface_) {
        super(interface_);
        this.iface = interface_;
        this.updatePosition();
        this.font = WidgetLite.WIDGET_FONT;
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.xcor = null;
        this.ycor = null;
        this.statusMessage = "";
        this.coordinateToolTip = new ToolTipWidget(interface_, "This displays the x,y coordinates of the patch the mouse is over");
        this.statusToolTip = new ToolTipWidget(interface_, "Messages are sometimes displayed here");
        if (YoYo.language == 1) {
            this.coordinateToolTip = new ToolTipWidget(interface_, "Esto muestra los coordenados x,y de la mancha ubicada debajo del cursor");
            this.statusToolTip = new ToolTipWidget(interface_, "Mensajes aparecen aqu\u00ed");
        }
    }
}

