/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.AltPatchCanvas;
import starlogo.Application;
import starlogo.NetworkPatchCanvas;
import starlogo.Observer;
import starlogo.Patch;
import starlogo.PatchCanvas;
import starlogo.Pictures;
import starlogo.SPEnumeration;
import starlogo.SpeedTimer;
import starlogo.StackProcess;
import starlogo.StackProcessList;
import starlogo.StackProcessParent;
import starlogo.StarLogoError;
import starlogo.Turtle;
import starlogo.Utilities;
import starlogo.VM;
import yoyo.Base64;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.Tokenizer;
import yoyo.YoYo;

public final class StarLogo
implements Runnable {
    public static final int MIN_CELLSIZE = 1;
    public static final int MAX_CELLSIZE = 32;
    public static final int DEFAULT_CELLSIZE = 8;
    public static final int DEFAULT_HALFHEIGHT = 25;
    public static final int DEFAULT_HALFWIDTH = 25;
    public static final int SQUARES = 0;
    public static final int IMAGEPRODUCER = 1;
    public static int altgraphics = YoYo.macosxp || YoYo.linuxp ? 1 : 0;
    public static Pictures PictInstance = null;
    public static boolean DEBUG = false;
    public static boolean DEBUG2 = false;
    public static boolean serverside = false;
    int numshapes = 64;
    int cellsize = 8;
    int halfheight = 25;
    int halfwidth = 25;
    public boolean inconsistent = false;
    public PatchCanvas patchcanvas;
    public boolean patchesneeddrawingp = false;
    public boolean patchesneedalittleredrawingp = false;
    Patch[] patches;
    public int height;
    public int width;
    int widthp2;
    int heightp2;
    double turhalfheight;
    double turhalfwidth;
    Turtle firstturtle = null;
    public Observer observer;
    int numturtles = 0;
    StackProcessList list;
    Context c;
    public Application app;
    int[][] iinstarray = new int[128][];
    Object[][] oinstarray = new Object[128][];
    String[] ninstarray = new String[128];
    int nextinst = 0;
    int[] whostack = new int[4096];
    int whop = -1;
    Vector deadbutgrabbed = new Vector();
    boolean offscreen = false;
    boolean patcheson = false;
    public volatile boolean locked = false;
    public Object runningp = new Object();
    public volatile boolean runningnowp = false;
    public volatile boolean pausedp = false;
    public Frame myframe;
    private volatile int speed = 100;
    public long waitres = 50L;
    public long MAX_WAIT_RESOLUTION = 50L;
    public long DIV_FACTOR = 4L;
    public volatile boolean go = true;
    private SpeedTimer speedtimer = new SpeedTimer(this);
    public int loops = 0;

    final void init() {
        this.list = new StackProcessList(this.app);
        int n = 0;
        while (n < this.heightp2) {
            int n2 = n * this.widthp2;
            int n3 = 0;
            while (n3 < this.widthp2) {
                this.patches[n2 + n3] = new Patch(n3, n, this);
                ++n3;
            }
            ++n;
        }
        this.list.create(this.observer);
        if (serverside) {
            this.patchcanvas = new NetworkPatchCanvas(this, null);
        } else {
            switch (altgraphics) {
                case 0: {
                    this.patchcanvas = new PatchCanvas(this);
                    break;
                }
                case 1: {
                    this.patchcanvas = new AltPatchCanvas(this);
                    break;
                }
            }
        }
    }

    final void init(Socket socket) {
        serverside = true;
        this.list = new StackProcessList(this.app);
        int n = 0;
        while (n < this.heightp2) {
            int n2 = n * this.widthp2;
            int n3 = 0;
            while (n3 < this.widthp2) {
                this.patches[n2 + n3] = new Patch(n3, n, this);
                ++n3;
            }
            ++n;
        }
        this.list.create(this.observer);
        this.patchcanvas = new NetworkPatchCanvas(this, socket);
    }

    final Turtle[] crt(int n) {
        return this.crt(n, 0.0, 0);
    }

    final Turtle[] crt(int n, double d, int n2) {
        Turtle[] turtleArray = new Turtle[n];
        Turtle turtle = null;
        double d2 = 360.0 / (double)n;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.whop < 0 ? this.numturtles : this.whostack[this.whop--];
            ++this.numturtles;
            turtle = new Turtle(this, 0.0, 0.0, d3, this.numturtles % 14 * 10 + 5, n4, d, n2);
            d3 += d2;
            turtleArray[n3] = turtle;
            if (this.firstturtle != null) {
                turtle.next = this.firstturtle;
                this.firstturtle.prev = turtle;
            }
            this.firstturtle = turtle;
            this.wrapandlink(turtle);
            this.list.create(turtle);
            Application.setTurtleMonitor(turtle);
            ++n3;
        }
        return turtleArray;
    }

    final Turtle cct(double d, double d2, double d3, double d4, double d5, int n) {
        return this.cct(d, d2, d3, d4, d5, n, false, true, 1, 1);
    }

    final Turtle cct(double d, double d2, double d3, double d4, double d5, int n, boolean bl, boolean bl2, int n2, int n3) {
        Turtle turtle = null;
        int n4 = this.whop < 0 ? this.numturtles : this.whostack[this.whop--];
        ++this.numturtles;
        turtle = new Turtle(this, d, d2, d3, d4, n4, d5, n, bl, bl2, n2, n3);
        if (this.firstturtle != null) {
            turtle.next = this.firstturtle;
            this.firstturtle.prev = turtle;
        }
        this.firstturtle = turtle;
        this.wrapandlink(turtle);
        this.list.create(turtle);
        Application.setTurtleMonitor(turtle);
        return turtle;
    }

    final int countBreeds(double d) {
        if (this.firstturtle == null) {
            return 0;
        }
        int n = 0;
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            if (turtle.breed == d) {
                ++n;
            }
            turtle = turtle.next;
        }
        return n;
    }

    final int countColor(double d) {
        if (this.firstturtle == null) {
            return 0;
        }
        int n = 0;
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            if (Math.round(turtle.color) == Math.round(d)) {
                ++n;
            }
            turtle = turtle.next;
        }
        return n;
    }

    final int countColor(double d, double d2) {
        if (this.firstturtle == null) {
            return 0;
        }
        int n = 0;
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            if (turtle.color >= d && turtle.color <= d2) {
                ++n;
            }
            turtle = turtle.next;
        }
        return n;
    }

    final Integer[] listTurtles() {
        return this.listTurtles(null);
    }

    final Integer[] listTurtles(Turtle turtle) {
        Integer[] integerArray = new Integer[this.numturtles - (turtle != null ? 1 : 0)];
        int n = 0;
        Turtle turtle2 = this.firstturtle;
        while (turtle2 != null) {
            if (turtle2 != turtle) {
                integerArray[n++] = turtle2.whoInt;
            }
            turtle2 = turtle2.next;
        }
        return integerArray;
    }

    final Integer[] listBreeds(double d) {
        return this.listBreeds(d, null);
    }

    final Integer[] listBreeds(double d, Turtle turtle) {
        Integer[] integerArray = new Integer[this.countBreeds(d) - (turtle != null && turtle.breed == d ? 1 : 0)];
        int n = 0;
        Turtle turtle2 = this.firstturtle;
        while (turtle2 != null) {
            if (turtle2.breed == d && turtle2 != turtle) {
                integerArray[n] = turtle2.whoInt;
                ++n;
            }
            turtle2 = turtle2.next;
        }
        return integerArray;
    }

    final int randomTurtle() {
        return this.randomTurtle(null);
    }

    final int randomTurtle(Turtle turtle) {
        if (this.firstturtle == null) {
            return -1;
        }
        if (this.numturtles == 1 && turtle != null) {
            return -1;
        }
        int n = (int)Math.floor(VM.rand.nextDouble() * (double)(this.numturtles - (turtle == null ? 0 : 1)));
        Turtle turtle2 = this.firstturtle;
        int n2 = 0;
        while (n2 < n) {
            turtle2 = turtle2.next;
            ++n2;
        }
        if (turtle2 == null) {
            return -1;
        }
        if (turtle2 == turtle) {
            turtle2 = turtle2.next;
        }
        if (turtle2 == null) {
            return -1;
        }
        return turtle2.who;
    }

    final int randomBreed(double d) {
        return this.randomBreed(d, null);
    }

    final int randomBreed(double d, Turtle turtle) {
        if (this.firstturtle == null) {
            return -1;
        }
        int n = this.countBreeds(d);
        if (n == 1 && turtle != null && turtle.breed == d) {
            return -1;
        }
        int n2 = (int)Math.floor(VM.rand.nextDouble() * (double)(n - (turtle != null && turtle.breed == d ? 1 : 0)));
        Turtle turtle2 = this.firstturtle;
        while (turtle2 != null) {
            if (turtle2.breed == d) {
                if (n2 == 0) {
                    if (turtle2 != turtle) {
                        return turtle2.who;
                    }
                } else {
                    --n2;
                }
            }
            turtle2 = turtle2.next;
        }
        return -1;
    }

    final Turtle getWho(int n) {
        if (n < 0) {
            return null;
        }
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            if (turtle.who == n) {
                return turtle;
            }
            turtle = turtle.next;
        }
        Enumeration enumeration = this.deadbutgrabbed.elements();
        while (enumeration.hasMoreElements()) {
            Turtle turtle2 = (Turtle)enumeration.nextElement();
            if (turtle2.who != n) continue;
            return turtle2;
        }
        return null;
    }

    final int patchat(double d, double d2) {
        if ((d2 %= (double)this.height) < 0.0) {
            d2 += (double)this.height;
        }
        if ((d %= (double)this.width) < 0.0) {
            d += (double)this.width;
        }
        int n = ((int)d2 + 1) * this.widthp2 + (int)d + 1;
        return n;
    }

    final int patchtowards(double d, double d2, double d3, double d4) {
        double d5 = d - (double)((int)d);
        if ((d = (double)((int)d) % 360.0) < 0.0) {
            d += 360.0;
        }
        double d6 = d2 * Math.sin(VM.deg2Rad(d += d5));
        double d7 = -d2 * Math.cos(VM.deg2Rad(d));
        return this.patchat(d3 + d6, d4 + d7);
    }

    final void killAll() {
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            this.unlink(turtle);
            this.die(turtle);
            turtle = turtle.next;
        }
        this.whostack = new int[4096];
        this.whop = -1;
    }

    final void wrapandlink(Turtle turtle) {
        turtle.ycor %= (double)this.height;
        if (turtle.ycor < 0.0) {
            turtle.ycor += (double)this.height;
        }
        turtle.xcor %= (double)this.width;
        if (turtle.xcor < 0.0) {
            turtle.xcor += (double)this.width;
        }
        this.link(turtle);
    }

    final void linkAll(int n, int n2) {
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            turtle.xcor += (double)n;
            turtle.ycor += (double)n2;
            this.link(turtle);
            turtle = turtle.next;
        }
    }

    final void link(Turtle turtle) {
        int n = ((int)turtle.ycor + 1) * this.widthp2 + (int)turtle.xcor + 1;
        Patch patch = this.patches[n];
        turtle.patch = n;
        if (turtle.shownp) {
            Turtle turtle2 = patch.topturtle;
            if (turtle2 != null) {
                turtle.underme = turtle2;
                turtle2.overme = turtle;
            }
            patch.topturtle = turtle;
            this.patchcanvas.drawTurtle(turtle);
        } else {
            Turtle turtle3 = patch.tophiddenturtle;
            if (turtle3 != null) {
                turtle.underme = turtle3;
                turtle3.overme = turtle;
            }
            patch.tophiddenturtle = turtle;
        }
    }

    final void unlink(Turtle turtle) {
        int n = ((int)turtle.ycor + 1) * this.widthp2 + (int)turtle.xcor + 1;
        Patch patch = this.patches[n];
        Turtle turtle2 = turtle.underme;
        Turtle turtle3 = turtle.overme;
        if (turtle.shownp) {
            if (turtle2 == null) {
                if (turtle3 == null) {
                    patch.topturtle = null;
                    this.patchcanvas.drawPatch(turtle.xcor, turtle.ycor, patch.pc);
                } else {
                    turtle3.underme = null;
                }
            } else if (turtle3 == null) {
                turtle2.overme = null;
                patch.topturtle = turtle2;
                this.patchcanvas.drawTurtle(turtle2);
            } else {
                turtle3.underme = turtle2;
                turtle2.overme = turtle3;
            }
        } else if (turtle2 == null) {
            if (turtle3 == null) {
                patch.tophiddenturtle = null;
            } else {
                turtle3.underme = null;
            }
        } else if (turtle3 == null) {
            turtle2.overme = null;
            patch.tophiddenturtle = turtle2;
        } else {
            turtle3.underme = turtle2;
            turtle2.overme = turtle3;
        }
        turtle.underme = null;
        turtle.overme = null;
        turtle.patch = -1;
    }

    final void unlinkAll(Patch[] patchArray, int n) {
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            int n2 = ((int)turtle.ycor + 1) * n + (int)turtle.xcor + 1;
            patchArray[n2].topturtle = null;
            patchArray[n2].tophiddenturtle = null;
            turtle.patch = -1;
            turtle.underme = null;
            turtle.overme = null;
            turtle = turtle.next;
        }
    }

    final void unlinkDuringResize(Turtle turtle, Patch[] patchArray, int n) {
        int n2 = ((int)turtle.ycor + 1) * n + (int)turtle.xcor + 1;
        Patch patch = patchArray[n2];
        Turtle turtle2 = turtle.underme;
        Turtle turtle3 = turtle.overme;
        if (turtle.shownp) {
            if (turtle2 == null) {
                if (turtle3 == null) {
                    patch.topturtle = null;
                    this.patchcanvas.drawPatch(turtle.xcor, turtle.ycor, patch.pc, patchArray);
                } else {
                    turtle3.underme = null;
                }
            } else if (turtle3 == null) {
                turtle2.overme = null;
                patch.topturtle = turtle2;
                this.patchcanvas.drawTurtle(turtle2, patchArray);
            } else {
                turtle3.underme = turtle2;
                turtle2.overme = turtle3;
            }
        } else if (turtle2 == null) {
            if (turtle3 == null) {
                patch.tophiddenturtle = null;
            } else {
                turtle3.underme = null;
            }
        } else if (turtle3 == null) {
            turtle2.overme = null;
            patch.tophiddenturtle = turtle2;
        } else {
            turtle3.underme = turtle2;
            turtle2.overme = turtle3;
        }
        turtle.underme = null;
        turtle.overme = null;
        turtle.patch = -1;
    }

    final void showTurtle(Turtle turtle) {
        int n = ((int)turtle.ycor + 1) * this.widthp2 + (int)turtle.xcor + 1;
        Patch patch = this.patches[n];
        Turtle turtle2 = turtle.underme;
        Turtle turtle3 = turtle.overme;
        if (turtle2 == null) {
            if (turtle3 == null) {
                patch.tophiddenturtle = null;
            } else {
                turtle3.underme = null;
            }
        } else if (turtle3 == null) {
            turtle2.overme = null;
            patch.tophiddenturtle = turtle2;
        } else {
            turtle3.underme = turtle2;
            turtle2.overme = turtle3;
        }
        Turtle turtle4 = patch.topturtle;
        if (turtle4 != null) {
            turtle.underme = turtle4;
            turtle4.overme = turtle;
        } else {
            turtle.underme = null;
        }
        turtle.overme = null;
        patch.topturtle = turtle;
        this.patchcanvas.drawTurtle(turtle);
    }

    final void hideTurtle(Turtle turtle) {
        int n = ((int)turtle.ycor + 1) * this.widthp2 + (int)turtle.xcor + 1;
        Patch patch = this.patches[n];
        Turtle turtle2 = turtle.underme;
        Turtle turtle3 = turtle.overme;
        if (turtle2 == null) {
            if (turtle3 == null) {
                patch.topturtle = null;
                this.patchcanvas.drawPatch(turtle.xcor, turtle.ycor, patch.pc);
            } else {
                turtle3.underme = null;
            }
        } else if (turtle3 == null) {
            turtle2.overme = null;
            patch.topturtle = turtle2;
            this.patchcanvas.drawTurtle(turtle2);
        } else {
            turtle3.underme = turtle2;
            turtle2.overme = turtle3;
        }
        Turtle turtle4 = patch.tophiddenturtle;
        if (turtle4 != null) {
            turtle.underme = turtle4;
            turtle4.overme = turtle;
        } else {
            turtle.underme = null;
        }
        turtle.overme = null;
        patch.tophiddenturtle = turtle;
    }

    final void die(Turtle turtle) {
        turtle.alive = false;
        turtle.die();
        Turtle turtle2 = turtle.prev;
        Turtle turtle3 = turtle.next;
        if (turtle3 == null) {
            if (turtle2 == null) {
                this.firstturtle = null;
            } else {
                turtle2.next = null;
            }
        } else if (turtle2 == null) {
            turtle3.prev = null;
            this.firstturtle = turtle3;
        } else {
            turtle2.next = turtle3;
            turtle3.prev = turtle2;
        }
        --this.numturtles;
        if (turtle.grabber == null) {
            this.recycleWho(turtle);
        } else {
            this.deadbutgrabbed.addElement(turtle);
        }
        this.done(turtle);
        this.app.iface.erasePointsOnAllWidgets(turtle.who);
    }

    final void recycleDeadWho(Turtle turtle) {
        this.recycleWho(turtle);
        this.deadbutgrabbed.removeElement(turtle);
    }

    final void recycleWho(Turtle turtle) {
        if (this.whop == this.whostack.length - 1) {
            int[] nArray = this.whostack;
            this.whostack = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, this.whostack, 0, nArray.length);
        }
        this.whostack[++this.whop] = turtle.who;
    }

    public final void turtlePrint(String string) {
        if (YoYo.applet == null) {
            this.app.procWin.turtlePrint(string);
        } else {
            YoYo.applet.showStatus(string);
        }
    }

    public final void observerPrint(String string) {
        if (YoYo.applet == null) {
            this.app.procWin.observerPrint(string);
        } else {
            YoYo.applet.showStatus(string);
        }
    }

    public final void turtlePrintln(String string) {
        if (YoYo.applet == null) {
            this.app.procWin.turtlePrintln(string);
        } else {
            YoYo.applet.showStatus(string);
        }
    }

    public final void observerPrintln(String string) {
        if (YoYo.applet == null) {
            this.app.procWin.observerPrintln(string);
        } else {
            YoYo.applet.showStatus(string);
        }
    }

    public final void setSpeed(int n) {
        this.speed = n;
        if (n == 0) {
            this.speedtimer.pause();
            this.pausedp = true;
        } else {
            this.pausedp = false;
            if (n == 100) {
                this.speedtimer.pause();
            } else {
                int n2 = 4 * n - 48;
                if (n < 16) {
                    n2 = 3 * n - 16;
                }
                if (n < 8) {
                    n2 = 2 * n - 4;
                }
                if (n < 4) {
                    n2 = n;
                }
                long l = 2000 / n2;
                this.waitres = Math.min(this.MAX_WAIT_RESOLUTION, l / this.DIV_FACTOR);
                this.speedtimer.setWaitPeriod(l);
                if (!this.speedtimer.isAlive()) {
                    Object object = this.runningp;
                    synchronized (object) {
                        this.runningp.notify();
                        this.speedtimer.restart();
                    }
                }
            }
        }
    }

    public final void run() {
        StackProcessList stackProcessList = this.list;
        Context context = this.c;
        Thread thread = Thread.currentThread();
        while (true) {
            try {
                Object object = this.runningp;
                synchronized (object) {
                    Object var7_8;
                    if (this.locked || stackProcessList.size() == 0 || this.pausedp) {
                        this.runningnowp = false;
                        this.speedtimer.pause();
                        this.runningp.wait();
                        if (this.speed < 100) {
                            this.speedtimer.restart();
                        }
                        this.runningnowp = true;
                    }
                    this.patchcanvas.setDrawingSurface();
                    try {
                        try {
                            SPEnumeration sPEnumeration = stackProcessList.elements();
                            while (sPEnumeration.hasMoreElements()) {
                                StackProcess stackProcess = sPEnumeration.nextElement();
                                stackProcess.switchme(context);
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            this.stopAll();
                            var7_8 = null;
                            if (this.patchesneeddrawingp || this.patchesneedalittleredrawingp) {
                                ++this.loops;
                            }
                            if (this.patchesneeddrawingp) {
                                this.redraw();
                                this.patchesneeddrawingp = false;
                                this.patchesneedalittleredrawingp = false;
                            } else if (this.patchesneedalittleredrawingp) {
                                this.refresh();
                                this.patchesneedalittleredrawingp = false;
                            }
                            this.patchcanvas.deleteDrawingSurface();
                            this.app.flushTextAreas();
                        }
                        var7_8 = null;
                        if (this.patchesneeddrawingp || this.patchesneedalittleredrawingp) {
                            ++this.loops;
                        }
                        if (this.patchesneeddrawingp) {
                            this.redraw();
                            this.patchesneeddrawingp = false;
                            this.patchesneedalittleredrawingp = false;
                        } else if (this.patchesneedalittleredrawingp) {
                            this.refresh();
                            this.patchesneedalittleredrawingp = false;
                        }
                        this.patchcanvas.deleteDrawingSurface();
                        this.app.flushTextAreas();
                    }
                    catch (Throwable throwable) {
                        var7_8 = null;
                        if (this.patchesneeddrawingp || this.patchesneedalittleredrawingp) {
                            ++this.loops;
                        }
                        if (this.patchesneeddrawingp) {
                            this.redraw();
                            this.patchesneeddrawingp = false;
                            this.patchesneedalittleredrawingp = false;
                        } else if (this.patchesneedalittleredrawingp) {
                            this.refresh();
                            this.patchesneedalittleredrawingp = false;
                        }
                        this.patchcanvas.deleteDrawingSurface();
                        this.app.flushTextAreas();
                        throw throwable;
                    }
                }
                Toolkit.getDefaultToolkit().sync();
                Thread.yield();
                if (this.speed >= 100) continue;
                while (!this.go) {
                    Thread.sleep(this.waitres);
                }
                this.go = false;
                continue;
            }
            catch (LogoError logoError) {
                this.stopAll();
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.stopAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.stopAll();
                continue;
            }
            break;
        }
    }

    final int setInstructions(String string, Object[] objectArray, Object[] objectArray2) {
        if (DEBUG) {
            this.app.log.println("Set Instructions: " + string + " #" + this.nextinst + " to: ");
            this.app.log.println("ilist = " + YoYo.printToString(objectArray));
            this.app.log.println("olist = " + YoYo.printToString(objectArray2));
        }
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        return this.internalSetInstructions(string, nArray, objectArray2);
    }

    final synchronized int internalSetInstructions(String string, int[] nArray, Object[] objectArray) {
        if (this.nextinst >= this.iinstarray.length) {
            int[][] nArray2 = new int[this.iinstarray.length * 2][];
            Object[][] objectArray2 = new Object[this.iinstarray.length * 2][];
            String[] stringArray = new String[this.iinstarray.length * 2];
            System.arraycopy(this.iinstarray, 0, nArray2, 0, this.iinstarray.length);
            System.arraycopy(this.oinstarray, 0, objectArray2, 0, this.iinstarray.length);
            System.arraycopy(this.ninstarray, 0, stringArray, 0, this.iinstarray.length);
            this.iinstarray = nArray2;
            this.oinstarray = objectArray2;
            this.ninstarray = stringArray;
        }
        this.iinstarray[this.nextinst] = nArray;
        this.oinstarray[this.nextinst] = objectArray;
        this.ninstarray[this.nextinst] = string;
        return this.nextinst++;
    }

    final synchronized int internalSetInstructions(String string, int[] nArray, Object[] objectArray, int n) {
        if (n >= this.iinstarray.length) {
            int[][] nArray2 = new int[n + 5][];
            Object[][] objectArray2 = new Object[n + 5][];
            String[] stringArray = new String[n + 5];
            System.arraycopy(this.iinstarray, 0, nArray2, 0, this.iinstarray.length);
            System.arraycopy(this.oinstarray, 0, objectArray2, 0, this.iinstarray.length);
            System.arraycopy(this.ninstarray, 0, stringArray, 0, this.iinstarray.length);
            this.iinstarray = nArray2;
            this.oinstarray = objectArray2;
            this.ninstarray = stringArray;
        }
        this.iinstarray[n] = nArray;
        this.oinstarray[n] = objectArray;
        this.ninstarray[n] = string;
        return n;
    }

    final synchronized int[] internalGetIlist(int n) {
        return this.iinstarray[n];
    }

    final synchronized Object[] internalGetOlist(int n) {
        return this.oinstarray[n];
    }

    final synchronized String internalGetName(int n) {
        return this.ninstarray[n];
    }

    final synchronized int internalGetWhichip(String string) {
        int n = 0;
        while (n < this.nextinst) {
            if (this.ninstarray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final void done(StackProcess stackProcess) {
        this.list.remove(stackProcess);
    }

    final void done(Turtle turtle) {
        this.list.remove(turtle);
    }

    public final void stopAll() {
        if (this.list.size() != 0) {
            this.list.removeAllSPs();
        }
    }

    final void stopTurtles() {
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            this.list.remove(turtle);
            turtle = turtle.next;
        }
    }

    final void stopObserver() {
        this.list.remove(this.observer);
    }

    final void stopPatches() {
        int n = 1;
        while (n < this.height + 1) {
            int n2 = n * this.widthp2;
            int n3 = 1;
            while (n3 < this.width + 1) {
                this.list.remove(this.patches[n2 + n3]);
                ++n3;
            }
            ++n;
        }
    }

    public final void stopProcess(StackProcessParent stackProcessParent) {
        this.list.stop(stackProcessParent);
    }

    final void CA() {
        this.CG();
        this.CP();
        this.CO();
        this.killAll();
        if (YoYo.applet == null) {
            this.app.outWin.reset();
            this.app.iface.clearLineWidgets();
        }
    }

    final void CG() {
        this.setPC(0.0);
    }

    final void CP() {
        this.setPatchVars(new Integer(0));
    }

    final void CO() {
        this.setObserverVars(new Integer(0));
    }

    final void setPC(double d) {
        int n = 1;
        while (n < this.height + 1) {
            int n2 = n * this.widthp2;
            int n3 = 1;
            while (n3 < this.width + 1) {
                Patch patch = this.patches[n2 + n3];
                if (patch.pc != d) {
                    this.patches[n2 + n3].pc = d;
                }
                ++n3;
            }
            ++n;
        }
    }

    final int countPC(double d) {
        int n = 0;
        int n2 = 1;
        while (n2 < this.height + 1) {
            int n3 = n2 * this.widthp2;
            int n4 = 1;
            while (n4 < this.width + 1) {
                if (Math.round(this.patches[n3 + n4].pc) == Math.round(d)) {
                    ++n;
                }
                ++n4;
            }
            ++n2;
        }
        return n;
    }

    final int countPC(double d, double d2) {
        int n = 0;
        int n2 = 1;
        while (n2 < this.height + 1) {
            int n3 = n2 * this.widthp2;
            int n4 = 1;
            while (n4 < this.width + 1) {
                if (this.patches[n3 + n4].pc >= d && this.patches[n3 + n4].pc <= d2) {
                    ++n;
                }
                ++n4;
            }
            ++n2;
        }
        return n;
    }

    final void scalePC(int n, double d, double d2, double d3) {
        d = (d %= 140.0) < 0.0 ? d + 140.0 : d;
        d = (double)((int)(d / 10.0)) * 10.0;
        double d4 = d2 - d3;
        int n2 = 1;
        while (n2 < this.height + 1) {
            int n3 = n2 * this.widthp2;
            int n4 = 1;
            while (n4 < this.width + 1) {
                Patch patch = this.patches[n3 + n4];
                double d5 = patch.patchesowndoubles[n];
                double d6 = d5 - d3;
                double d7 = d6 / d4;
                if (d7 < 0.0) {
                    patch.pc = 0.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    patch.pc = d + (d7 *= 9.999999999);
                }
                ++n4;
            }
            ++n2;
        }
    }

    final void setTurtleVar(int n, Object object) {
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            turtle.turtlesown[n] = object;
            turtle = turtle.next;
        }
    }

    final void setPatchVar(int n, Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n2 = 1;
            while (n2 < this.height + 1) {
                int n3 = n2 * this.widthp2;
                int n4 = 1;
                while (n4 < this.width + 1) {
                    this.patches[n3 + n4].turtlesown[n] = object;
                    this.patches[n3 + n4].patchesowndoubles[n] = d;
                    ++n4;
                }
                ++n2;
            }
        } else {
            int n5 = 1;
            while (n5 < this.height + 1) {
                int n6 = n5 * this.widthp2;
                int n7 = 1;
                while (n7 < this.width + 1) {
                    this.patches[n6 + n7].turtlesown[n] = object;
                    ++n7;
                }
                ++n5;
            }
        }
    }

    final void setPatchVars(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = 1;
            while (n < this.height + 1) {
                int n2 = n * this.widthp2;
                int n3 = 1;
                while (n3 < this.width + 1) {
                    Object[] objectArray = this.patches[n2 + n3].turtlesown;
                    double[] dArray = this.patches[n2 + n3].patchesowndoubles;
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        objectArray[n4] = object;
                        dArray[n4] = d;
                        ++n4;
                    }
                    ++n3;
                }
                ++n;
            }
        } else {
            int n = 1;
            while (n < this.height + 1) {
                int n5 = n * this.widthp2;
                int n6 = 1;
                while (n6 < this.width + 1) {
                    Object[] objectArray = this.patches[n5 + n6].turtlesown;
                    int n7 = 0;
                    while (n7 < objectArray.length) {
                        objectArray[n7] = object;
                        ++n7;
                    }
                    ++n6;
                }
                ++n;
            }
        }
    }

    final void setObserverVars(Object object) {
        int n = 0;
        while (n < this.observer.turtlesown.length) {
            this.observer.turtlesown[n] = object;
            ++n;
        }
    }

    final void redraw() {
        this.patchcanvas.updateImage();
        this.patchcanvas.refresh();
    }

    final void refresh() {
        this.patchcanvas.refresh();
    }

    public final String saveSettings() {
        String string = "`settings`\r\npatch-size " + this.cellsize + "\r\n" + "num-shapes " + this.numshapes + "\r\n" + "screen-half-width " + this.halfwidth + "\r\n" + "screen-half-height " + this.halfheight + "\r\n" + "interface-window-xcor " + this.app.iface.frame().getLocation().x + "\r\n" + "interface-window-ycor " + this.app.iface.frame().getLocation().y + "\r\n" + "interface-window-size " + this.app.iface.getVisibleSize().width + " " + this.app.iface.getVisibleSize().height + "\r\n" + "output-window-xcor " + this.app.outWin.getLocation().x + "\r\n" + "output-window-ycor " + this.app.outWin.getLocation().y + "\r\n" + "output-window-width " + this.app.outWin.getSize().width + "\r\n" + "output-window-height " + this.app.outWin.getSize().height + "\r\n" + "info-window-xcor " + this.app.infoWin.getLocation().x + "\r\n" + "info-window-ycor " + this.app.infoWin.getLocation().y + "\r\n" + "info-window-width " + this.app.infoWin.getSize().width + "\r\n" + "info-window-height " + this.app.infoWin.getSize().height + "\r\n" + "control-center-xcor " + this.app.procWin.getLocation().x + "\r\n" + "control-center-ycor " + this.app.procWin.getLocation().y + "\r\n" + "control-center-width " + this.app.procWin.getSize().width + "\r\n" + "control-center-height " + this.app.procWin.getSize().height + "\r\n" + "turtle-command-center-height " + this.app.procWin.getCCHeight(0) + "\r\n" + "observer-command-center-height " + this.app.procWin.getCCHeight(1) + "\r\n";
        return string;
    }

    public final void restoreSettings(String string, boolean bl) {
        String string2 = "`settings`";
        int n = string.indexOf(string2);
        if (n == -1) {
            return;
        }
        int n2 = string.indexOf("`", n + string2.length());
        if (n2 == -1) {
            n2 = string.length();
        }
        Tokenizer tokenizer = new Tokenizer(string.substring(n + string2.length(), n2));
        Vector vector = tokenizer.tokenize();
        int n3 = this.halfheight;
        int n4 = this.halfwidth;
        int n5 = this.cellsize;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        if (!bl) {
            n6 = this.app.iface.frame().getLocation().x;
            n7 = this.app.iface.frame().getLocation().y;
            n8 = this.app.outWin.getLocation().x;
            n9 = this.app.outWin.getLocation().y;
            n10 = this.app.outWin.getSize().width;
            n11 = this.app.outWin.getSize().height;
            n12 = this.app.infoWin.getLocation().x;
            n13 = this.app.infoWin.getLocation().y;
            n14 = this.app.infoWin.getSize().width;
            n15 = this.app.infoWin.getSize().height;
            n16 = this.app.procWin.getLocation().x;
            n17 = this.app.procWin.getLocation().y;
            n18 = this.app.procWin.getSize().width;
            n19 = this.app.procWin.getSize().height;
            n24 = this.app.procWin.getCCHeight(0);
            n25 = this.app.procWin.getCCHeight(1);
        }
        int n26 = 0;
        while (n26 < vector.size()) {
            String string3 = vector.elementAt(n26).toString();
            if (string3.equals("patch-size")) {
                String string4 = vector.elementAt(n26 + 1).toString();
                n5 = Integer.parseInt(string4);
                n26 += 2;
                continue;
            }
            if (string3.equals("num-shapes")) {
                String string5 = vector.elementAt(n26 + 1).toString();
                this.numshapes = Integer.parseInt(string5);
                n26 += 2;
                continue;
            }
            if (string3.equals("screen-half-width")) {
                String string6 = vector.elementAt(n26 + 1).toString();
                n4 = Integer.parseInt(string6);
                n26 += 2;
                continue;
            }
            if (string3.equals("screen-half-height")) {
                String string7 = vector.elementAt(n26 + 1).toString();
                n3 = Integer.parseInt(string7);
                n26 += 2;
                continue;
            }
            if (string3.equals("interface-window-xcor")) {
                String string8 = vector.elementAt(n26 + 1).toString();
                n6 = Integer.parseInt(string8) < Toolkit.getDefaultToolkit().getScreenSize().width ? Integer.parseInt(string8) : 100;
                n26 += 2;
                continue;
            }
            if (string3.equals("interface-window-ycor")) {
                String string9 = vector.elementAt(n26 + 1).toString();
                n7 = Integer.parseInt(string9) < Toolkit.getDefaultToolkit().getScreenSize().height ? Integer.parseInt(string9) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("interface-window-size")) {
                int n27 = Integer.parseInt(vector.elementAt(n26 + 1).toString());
                int n28 = n27 + 50;
                int n29 = Integer.parseInt(vector.elementAt(n26 + 2).toString());
                int n30 = n29 + 80;
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n31 = 10;
                if (n28 > dimension.width) {
                    n27 -= n28 - (dimension.width - 2 * n31);
                    n6 = n31;
                } else if (n28 + n6 > dimension.width) {
                    n6 = (dimension.width - n28) / 2;
                }
                if (n30 > dimension.height) {
                    n29 -= n30 - (dimension.height - 2 * n31);
                    n7 = n31;
                } else if (n30 + n7 > dimension.height) {
                    n7 = (dimension.height - n30) / 2;
                }
                this.app.iface.setVisibleSize(n27, n29);
                n26 += 3;
                continue;
            }
            if (string3.equals("output-window-xcor")) {
                String string10 = vector.elementAt(n26 + 1).toString();
                n8 = Integer.parseInt(string10) < Toolkit.getDefaultToolkit().getScreenSize().width ? Integer.parseInt(string10) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("output-window-ycor")) {
                String string11 = vector.elementAt(n26 + 1).toString();
                n9 = Integer.parseInt(string11) < Toolkit.getDefaultToolkit().getScreenSize().height ? Integer.parseInt(string11) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("output-window-width")) {
                String string12 = vector.elementAt(n26 + 1).toString();
                n10 = Integer.parseInt(string12);
                n26 += 2;
                continue;
            }
            if (string3.equals("output-window-height")) {
                String string13 = vector.elementAt(n26 + 1).toString();
                n11 = Integer.parseInt(string13);
                n26 += 2;
                continue;
            }
            if (string3.equals("info-window-xcor")) {
                String string14 = vector.elementAt(n26 + 1).toString();
                n12 = Integer.parseInt(string14) < Toolkit.getDefaultToolkit().getScreenSize().width ? Integer.parseInt(string14) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("info-window-ycor")) {
                String string15 = vector.elementAt(n26 + 1).toString();
                n13 = Integer.parseInt(string15) < Toolkit.getDefaultToolkit().getScreenSize().height ? Integer.parseInt(string15) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("info-window-width")) {
                String string16 = vector.elementAt(n26 + 1).toString();
                n14 = Integer.parseInt(string16);
                n26 += 2;
                continue;
            }
            if (string3.equals("info-window-height")) {
                String string17 = vector.elementAt(n26 + 1).toString();
                n15 = Integer.parseInt(string17);
                n26 += 2;
                continue;
            }
            if (string3.equals("control-center-xcor")) {
                String string18 = vector.elementAt(n26 + 1).toString();
                n16 = Integer.parseInt(string18) < Toolkit.getDefaultToolkit().getScreenSize().width ? Integer.parseInt(string18) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("control-center-ycor")) {
                String string19 = vector.elementAt(n26 + 1).toString();
                n17 = Integer.parseInt(string19) < Toolkit.getDefaultToolkit().getScreenSize().height ? Integer.parseInt(string19) : 100;
                n26 += 2;
                continue;
            }
            if (string3.equals("control-center-width")) {
                String string20 = vector.elementAt(n26 + 1).toString();
                n18 = Integer.parseInt(string20);
                n26 += 2;
                continue;
            }
            if (string3.equals("control-center-height")) {
                String string21 = vector.elementAt(n26 + 1).toString();
                n19 = Integer.parseInt(string21);
                n26 += 2;
                continue;
            }
            if (string3.equals("turtle-command-center-height")) {
                String string22 = vector.elementAt(n26 + 1).toString();
                n24 = Integer.parseInt(string22);
                n26 += 2;
                continue;
            }
            if (string3.equals("observer-command-center-height")) {
                String string23 = vector.elementAt(n26 + 1).toString();
                n25 = Integer.parseInt(string23);
                n26 += 2;
                continue;
            }
            if (string3.equals("plot-window-xcor")) {
                String string24 = vector.elementAt(n26 + 1).toString();
                n20 = Integer.parseInt(string24) < Toolkit.getDefaultToolkit().getScreenSize().width ? Integer.parseInt(string24) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("plot-window-ycor")) {
                String string25 = vector.elementAt(n26 + 1).toString();
                n21 = Integer.parseInt(string25) < Toolkit.getDefaultToolkit().getScreenSize().height ? Integer.parseInt(string25) : 0;
                n26 += 2;
                continue;
            }
            if (string3.equals("plot-window-width")) {
                String string26 = vector.elementAt(n26 + 1).toString();
                n22 = Integer.parseInt(string26);
                n26 += 2;
                continue;
            }
            if (string3.equals("plot-window-height")) {
                String string27 = vector.elementAt(n26 + 1).toString();
                n23 = Integer.parseInt(string27);
                n26 += 2;
                continue;
            }
            n26 += 2;
        }
        if (!bl) {
            if (YoYo.macintoshp) {
                if (n7 < 20) {
                    n7 = 20;
                }
                if (n9 < 20) {
                    n9 = 20;
                }
                if (n13 < 20) {
                    n13 = 20;
                }
                if (n17 < 20) {
                    n17 = 20;
                }
            }
            if (YoYo.applet == null) {
                ((Component)this.app.iface.frame()).setLocation(n6, n7);
            }
            ((Component)this.app.outWin).setBounds(n8, n9, n10, n11);
            ((Component)this.app.infoWin).setBounds(n12, n13, n14, n15);
            this.app.procWin.setBounds(n16, n17, n18, n19);
            this.app.procWin.setCCHeight(0, n24);
            this.app.procWin.setCCHeight(1, n25);
        }
        this.resizePatches(n4, n3, n5);
    }

    public final boolean resizePatches(int n, int n2, int n3) {
        return this.resizePatches(n, n2, n3, this.patchcanvas.position.x, this.patchcanvas.position.y, 4);
    }

    public final void switchPatches() {
        PatchCanvas patchCanvas = this.patchcanvas;
        if (serverside) {
            this.patchcanvas = new NetworkPatchCanvas(this, patchCanvas);
        } else {
            switch (altgraphics) {
                case 0: {
                    this.patchcanvas = new PatchCanvas(this, patchCanvas);
                    break;
                }
                case 1: {
                    this.patchcanvas = new AltPatchCanvas(this, patchCanvas);
                    break;
                }
            }
        }
        this.app.iface.replacePatchCanvas(patchCanvas, this.patchcanvas);
    }

    public final boolean resizePatches(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.halfwidth != n || this.halfheight != n2 || this.cellsize != n3) {
            Object object = this.runningp;
            synchronized (object) {
                if (this.halfwidth != n || this.halfheight != n2) {
                    boolean bl = n > this.halfwidth;
                    boolean bl2 = n2 > this.halfheight;
                    this.halfwidth = n;
                    this.halfheight = n2;
                    this.patchcanvas.setDrawingSurface();
                    this.createPatches(n6, bl, bl2);
                    PatchCanvas patchCanvas = this.patchcanvas;
                    if (serverside) {
                        this.patchcanvas = new NetworkPatchCanvas(this, patchCanvas);
                    } else {
                        switch (altgraphics) {
                            case 0: {
                                this.patchcanvas = new PatchCanvas(this, patchCanvas);
                                break;
                            }
                            case 1: {
                                this.patchcanvas = new AltPatchCanvas(this, patchCanvas);
                                break;
                            }
                        }
                    }
                    this.app.iface.replacePatchCanvas(patchCanvas, this.patchcanvas, n4, n5);
                    patchCanvas.deleteDrawingSurface();
                }
                if (this.cellsize != n3) {
                    if (n3 > 8 && n3 < 16) {
                        n3 = 8;
                    } else if (n3 > 16 && n3 < 32) {
                        n3 = 16;
                    } else if (n3 > 32) {
                        n3 = 32;
                    }
                    this.cellsize = n3;
                    PatchCanvas patchCanvas = this.patchcanvas;
                    if (serverside) {
                        this.patchcanvas = new NetworkPatchCanvas(this, patchCanvas);
                    } else {
                        switch (altgraphics) {
                            case 0: {
                                this.patchcanvas = new PatchCanvas(this, patchCanvas);
                                break;
                            }
                            case 1: {
                                this.patchcanvas = new AltPatchCanvas(this, patchCanvas);
                                break;
                            }
                        }
                    }
                    this.app.iface.replacePatchCanvas(patchCanvas, this.patchcanvas, n4, n5);
                    this.app.iface.setCellScroll(this.cellsize);
                }
            }
            return true;
        }
        return false;
    }

    private final void createPatches(int n, boolean bl, boolean bl2) {
        int n2 = this.widthp2;
        int n3 = this.heightp2;
        Patch[] patchArray = this.patches;
        this.height = this.halfheight * 2 + 1;
        this.width = this.halfwidth * 2 + 1;
        this.widthp2 = this.width + 2;
        this.heightp2 = this.height + 2;
        this.turhalfheight = (double)this.height / 2.0;
        this.turhalfwidth = (double)this.width / 2.0;
        try {
            this.patches = new Patch[this.widthp2 * this.heightp2];
            int n4 = this.heightp2 - n3;
            int n5 = this.widthp2 - n2;
            if (n4 < 0) {
                n4 = -n4;
            }
            if (n5 < 0) {
                n5 = -n5;
            }
            switch (n) {
                case 4: {
                    int n6;
                    int n7;
                    if (bl) {
                        n7 = n2 - 1;
                        this.makePatchColumn(1, n2 - 1, this.heightp2 - 1, this.widthp2 - 1, this.patches, this.widthp2);
                    } else {
                        n7 = this.widthp2 - 1;
                        this.killTurtleColumn(1, this.widthp2 - 1, n3 - 1, n2 - 1, patchArray, n2);
                    }
                    if (bl2) {
                        n6 = n3 - 1;
                        this.makePatchColumn(n3 - 1, 1, this.heightp2 - 1, n7, this.patches, this.widthp2);
                    } else {
                        n6 = this.heightp2 - 1;
                        this.killTurtleColumn(this.heightp2 - 1, 1, n3 - 1, n2 - 1, patchArray, n2);
                    }
                    this.unlinkAll(patchArray, n2);
                    this.copyPatches(1, 1, n6, n7, patchArray, this.patches, 0, 0, n2, this.widthp2);
                    this.linkAll(0, 0);
                    break;
                }
                case 3: {
                    int n8;
                    int n9;
                    int n6;
                    if (bl) {
                        n9 = 1;
                        n8 = n5;
                        this.makePatchColumn(1, 1, this.heightp2 - 1, n5 + 1, this.patches, this.widthp2);
                    } else {
                        n9 = n5 + 1;
                        n8 = -n5;
                        this.killTurtleColumn(1, 1, n3 - 1, n5, patchArray, n2);
                    }
                    if (bl2) {
                        n6 = n3 - 1;
                        this.makePatchColumn(n3 - 1, bl ? n5 + 1 : 1, this.heightp2 - 1, this.widthp2 - 1, this.patches, this.widthp2);
                    } else {
                        n6 = this.heightp2 - 1;
                        this.killTurtleColumn(this.heightp2 - 1, 1, n3 - 1, n2 - 1, patchArray, n2);
                    }
                    this.unlinkAll(patchArray, n2);
                    this.copyPatches(1, n9, n6, n2 - 1, patchArray, this.patches, 0, n8, n2, this.widthp2);
                    this.linkAll(n8, 0);
                    break;
                }
                case 1: {
                    int n10;
                    int n11;
                    int n8;
                    int n9;
                    if (bl) {
                        n9 = 1;
                        n8 = n5;
                        this.makePatchColumn(1, 1, this.heightp2 - 1, n5 + 1, this.patches, this.widthp2);
                    } else {
                        n9 = n5 + 1;
                        n8 = -n5;
                        this.killTurtleColumn(1, 1, n3 - 1, n5, patchArray, n2);
                    }
                    if (bl2) {
                        n11 = 1;
                        n10 = n4;
                        this.makePatchColumn(1, bl ? n5 + 1 : 1, n4 + 1, this.widthp2 - 1, this.patches, this.widthp2);
                    } else {
                        n11 = n4 + 1;
                        n10 = -n4;
                        this.killTurtleColumn(1, 1, n4, n2 - 1, patchArray, n2);
                    }
                    this.unlinkAll(patchArray, n2);
                    this.copyPatches(n11, n9, n3 - 1, n2 - 1, patchArray, this.patches, n10, n8, n2, this.widthp2);
                    this.linkAll(n8, n10);
                    break;
                }
                case 2: {
                    int n10;
                    int n11;
                    int n7;
                    if (bl) {
                        n7 = n2 - 1;
                        this.makePatchColumn(1, n2 - 1, this.heightp2 - 1, this.widthp2 - 1, this.patches, this.widthp2);
                    } else {
                        n7 = this.widthp2 - 1;
                        this.killTurtleColumn(1, this.widthp2 - 1, n3 - 1, n2 - 1, patchArray, n2);
                    }
                    if (bl2) {
                        n11 = 1;
                        n10 = n4;
                        this.makePatchColumn(1, 1, n4 + 1, bl ? n2 - 1 : this.widthp2 - 1, this.patches, this.widthp2);
                    } else {
                        n11 = n4 + 1;
                        n10 = -n4;
                        this.killTurtleColumn(1, 1, n4, n2 - 1, patchArray, n2);
                    }
                    this.unlinkAll(patchArray, n2);
                    this.copyPatches(n11, 1, n3 - 1, n7, patchArray, this.patches, n10, 0, n2, this.widthp2);
                    this.linkAll(0, n10);
                    break;
                }
                default: {
                    this.app.err.println("uh oh, unknown resize anchor corner in resizing patch canvas");
                }
            }
            int n12 = 0;
            while (n12 < this.heightp2) {
                this.patches[n12 * this.widthp2] = new Patch(0.0, n12, this);
                this.patches[(n12 + 1) * this.widthp2 - 1] = new Patch(this.widthp2 - 1, n12, this);
                ++n12;
            }
            int n13 = 1;
            while (n13 < this.widthp2 - 1) {
                this.patches[n13] = new Patch(n13, 0.0, this);
                this.patches[this.widthp2 * (this.heightp2 - 1) + n13] = new Patch(n13, this.heightp2 - 1, this);
                ++n13;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.patches = patchArray;
            throw new LogoError("Fatal Error: Ran out of memory trying to create new patchcanvas. Please quit StarLogo immediately.");
        }
    }

    final void copyPatches(int n, int n2, int n3, int n4, Patch[] patchArray, Patch[] patchArray2, int n5, int n6, int n7, int n8) {
        int n9 = n;
        while (n9 < n3) {
            int n10 = n2;
            while (n10 < n4) {
                Patch patch;
                patchArray2[(n9 + n5) * n8 + (n10 + n6)] = patch = patchArray[n9 * n7 + n10];
                patch.xcor = n10 + n6;
                patch.ycor = n9 + n5;
                ++n10;
            }
            ++n9;
        }
    }

    final void makePatchColumn(int n, int n2, int n3, int n4, Patch[] patchArray, int n5) {
        int n6 = n;
        while (n6 < n3) {
            int n7 = n2;
            while (n7 < n4) {
                patchArray[n6 * n5 + n7] = new Patch(n7, n6, this);
                ++n7;
            }
            ++n6;
        }
    }

    final void killTurtleColumn(int n, int n2, int n3, int n4, Patch[] patchArray, int n5) {
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            if ((int)turtle.xcor >= n2 - 1 && (int)turtle.xcor <= n4 - 1 && (int)turtle.ycor >= n - 1 && (int)turtle.ycor <= n3 - 1) {
                this.unlinkDuringResize(turtle, patchArray, n5);
                this.die(turtle);
            }
            turtle = turtle.next;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String saveWorld(boolean bl) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        String string2 = "";
        byte[] byArray2 = null;
        try {
            try {
                DataOutputStream dataOutputStream;
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
                this.saveObserver(dataOutputStream2);
                dataOutputStream2.close();
                byte[] byArray3 = byteArrayOutputStream2.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream3);
                this.savePatches(dataOutputStream3);
                dataOutputStream3.close();
                byte[] byArray4 = byteArrayOutputStream3.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream4);
                this.saveTurtles(dataOutputStream4);
                dataOutputStream4.close();
                byte[] byArray5 = byteArrayOutputStream4.toByteArray();
                if (bl) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    this.saveByteCodes(dataOutputStream);
                    dataOutputStream.close();
                    byArray2 = byteArrayOutputStream.toByteArray();
                }
                ByteArrayOutputStream byteArrayOutputStream5 = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream5);
                Utilities.dumpStringTable(dataOutputStream);
                dataOutputStream.close();
                byte[] byArray6 = byteArrayOutputStream5.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream6 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream5 = new DataOutputStream(byteArrayOutputStream6);
                Utilities.dumpSymbolTable(dataOutputStream5);
                dataOutputStream5.close();
                byte[] byArray7 = byteArrayOutputStream6.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream7 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream6 = new DataOutputStream(byteArrayOutputStream7);
                Utilities.dumpDoubleTable(dataOutputStream6);
                dataOutputStream6.close();
                byte[] byArray8 = byteArrayOutputStream7.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream8 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream7 = new DataOutputStream(byteArrayOutputStream8);
                Utilities.dumpListTable(dataOutputStream7);
                dataOutputStream7.close();
                byte[] byArray9 = byteArrayOutputStream8.toByteArray();
                byte[] byArray10 = Utilities.gzipByteArray(byArray3);
                byte[] byArray11 = Utilities.gzipByteArray(byArray4);
                byte[] byArray12 = Utilities.gzipByteArray(byArray5);
                if (bl) {
                    byArray = Utilities.gzipByteArray(byArray2);
                }
                byte[] byArray13 = Utilities.gzipByteArray(byArray6);
                byte[] byArray14 = Utilities.gzipByteArray(byArray7);
                byte[] byArray15 = Utilities.gzipByteArray(byArray8);
                byte[] byArray16 = Utilities.gzipByteArray(byArray9);
                String string3 = Base64.encode(byArray10);
                String string4 = Base64.encode(byArray11);
                String string5 = Base64.encode(byArray12);
                if (bl) {
                    string2 = Base64.encode(byArray);
                }
                String string6 = Base64.encode(byArray13);
                String string7 = Base64.encode(byArray14);
                String string8 = Base64.encode(byArray15);
                String string9 = Base64.encode(byArray16);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("`string table`\r\n");
                stringBuffer.append(string6);
                stringBuffer.append("\r\n`symbol table`\r\n");
                stringBuffer.append(string7);
                stringBuffer.append("\r\n`double table`\r\n");
                stringBuffer.append(string8);
                stringBuffer.append("\r\n`list table`\r\n");
                stringBuffer.append(string9);
                if (bl) {
                    stringBuffer.append("\r\n`bytecodes`\r\n");
                    stringBuffer.append(string2);
                }
                stringBuffer.append("\r\n`observer world`\r\n");
                stringBuffer.append(string3);
                stringBuffer.append("\r\n`patch world`\r\n");
                stringBuffer.append(string4);
                stringBuffer.append("\r\n`turtle world`\r\n");
                stringBuffer.append(string5);
                string = stringBuffer.toString();
                Object var35_47 = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var35_48 = null;
                Utilities.clearTable();
                return null;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                String string10 = "error";
                Object var35_49 = null;
                Utilities.clearTable();
                return string10;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var35_50 = null;
                Utilities.clearTable();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var35_51 = null;
            Utilities.clearTable();
            throw throwable;
        }
        Utilities.clearTable();
        return string;
    }

    public final void restoreTables(String string, Context context) {
        this.extractPeace(string, "`string table`", context);
        this.extractPeace(string, "`symbol table`", context);
        this.extractPeace(string, "`double table`", context);
        this.extractPeace(string, "`list table`", context);
    }

    public final void restoreWorld(String string, Context context) {
        block5: {
            try {
                if (!this.extractPeace(string, "`observer world`", context)) {
                    this.list.deleteObserver();
                    this.observer = new Observer(this);
                    this.list.create(this.observer);
                    Observer.setVars(new Object[0], this, context);
                }
                if (!this.extractPeace(string, "`patch world`", context)) {
                    this.list.deletePatches();
                    this.createPatches(3, false, false);
                    this.CG();
                    Object[] objectArray = new Object[]{};
                    Patch.setVars(objectArray, this, context);
                }
                if (!this.extractPeace(string, "`turtle world`", context)) {
                    this.killAll();
                    Turtle.setVars(new Object[0], this, context);
                    Turtle.setBreeds(new Object[0], context);
                }
                if (YoYo.applet == null) break block5;
                this.extractPeace(string, "`bytecodes`", context);
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                Utilities.clearTable();
                VM.initStateOffsets();
                throw throwable;
            }
        }
        Object var7_4 = null;
        Utilities.clearTable();
        VM.initStateOffsets();
    }

    public final boolean extractPeace(String string, String string2, Context context) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2 = string.indexOf("`", n + string2.length());
            if (n2 == -1) {
                n2 = string.length();
            }
            String string3 = string.substring(n + string2.length(), n2).trim() + "\r\n";
            try {
                byte[] byArray = Utilities.gunzipByteArray(Base64.decode(string3.getBytes()));
                if (byArray == null) {
                    return false;
                }
                try {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    if (string2.equals("`observer world`")) {
                        this.restoreObserver(dataInputStream, context);
                    } else if (string2.equals("`patch world`")) {
                        this.restorePatches(dataInputStream, context);
                    } else if (string2.equals("`turtle world`")) {
                        this.restoreTurtles(dataInputStream, context);
                    } else if (string2.equals("`bytecodes`")) {
                        this.restoreByteCodes(dataInputStream, context);
                    } else if (string2.equals("`symbol table`")) {
                        Utilities.loadSymbolTable(dataInputStream);
                    } else if (string2.equals("`string table`")) {
                        Utilities.loadStringTable(dataInputStream);
                    } else if (string2.equals("`double table`")) {
                        Utilities.loadDoubleTable(dataInputStream);
                    } else if (string2.equals("`list table`")) {
                        Utilities.loadListTable(dataInputStream);
                    }
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    streamCorruptedException.printStackTrace(this.app.log);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(this.app.log);
            }
            return true;
        }
        return false;
    }

    public final void saveByteCodes(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("`bytecodes`");
        dataOutputStream.writeDouble(2.1);
        dataOutputStream.writeInt(this.nextinst);
        int n = 0;
        while (n < this.nextinst) {
            int[] nArray = this.iinstarray[n];
            Object[] objectArray = this.oinstarray[n];
            dataOutputStream.writeUTF(this.ninstarray[n]);
            dataOutputStream.writeInt(nArray.length);
            int n2 = 0;
            while (n2 < nArray.length) {
                dataOutputStream.writeInt(nArray[n2]);
                ++n2;
            }
            dataOutputStream.writeInt(Utilities.addIntoTable(objectArray, this));
            ++n;
        }
    }

    public final void restoreByteCodes(DataInputStream dataInputStream, Context context) throws IOException {
        String string = "";
        try {
            string = dataInputStream.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            uTFDataFormatException.printStackTrace();
            return;
        }
        if (!string.equals("`bytecodes`")) {
            return;
        }
        double d = dataInputStream.readDouble();
        if (d > 2.1 || d < 2.0) {
            StarLogoError.error(this.app, "Error loading project file: Failed to read byte codes. Data version is unknown: " + d, YoYo.applet != null);
            return;
        }
        try {
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                String string2 = d >= 2.1 ? dataInputStream.readUTF() : "unknown";
                int[] nArray = new int[dataInputStream.readInt()];
                int n3 = 0;
                while (n3 < nArray.length) {
                    nArray[n3] = dataInputStream.readInt();
                    ++n3;
                }
                Object[] objectArray = (Object[])Utilities.lookupInTable(dataInputStream.readInt());
                this.internalSetInstructions(string2, nArray, objectArray, n2);
                ++n2;
            }
            this.nextinst = n;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            StarLogoError.error(this.app, "Error loading project file: Failed to read byte codes.", true);
            return;
        }
    }

    public final void saveTurtles(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("`turtle state`");
        dataOutputStream.writeDouble(2.0);
        byte[] byArray = Turtle.getStateDesc();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeInt(Turtle.numVars);
        int n = 0;
        while (n < Turtle.numVars) {
            dataOutputStream.writeUTF(Turtle.getVarName(n));
            dataOutputStream.writeInt(Turtle.getVarPos(n));
            ++n;
        }
        dataOutputStream.writeInt(Turtle.numBreeds);
        n = 0;
        while (n < Turtle.numBreeds) {
            dataOutputStream.writeUTF(Turtle.getBreedName(n));
            dataOutputStream.writeInt(Turtle.getBreedNum(n));
            ++n;
        }
        dataOutputStream.writeInt(this.whop);
        n = 0;
        while (n < this.whop + 1) {
            dataOutputStream.writeInt(this.whostack[n]);
            ++n;
        }
        dataOutputStream.writeInt(this.numturtles);
        n = Turtle.getLength();
        int n2 = 0;
        byte[] byArray2 = new byte[this.numturtles * n];
        Turtle turtle = this.firstturtle;
        while (turtle != null) {
            turtle.save(byArray2, n2);
            turtle = turtle.next;
            n2 += n;
        }
        dataOutputStream.write(byArray2);
    }

    public final void restoreTurtles(DataInputStream dataInputStream, Context context) throws IOException {
        int n;
        Object[] objectArray;
        int n2;
        String string = "";
        try {
            string = dataInputStream.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.killAll();
            return;
        }
        if (!string.equals("`turtle state`")) {
            return;
        }
        double d = dataInputStream.readDouble();
        if (d > 2.0 || d < 2.0) {
            this.killAll();
            StarLogoError.error(this.app, "Error loading project file: Failed to read turtles. Data version is unknown: " + d, false);
            return;
        }
        this.killAll();
        int n3 = dataInputStream.readInt();
        byte[] byArray = new byte[n3];
        dataInputStream.read(byArray);
        Turtle.setStateDesc(byArray);
        try {
            Object[] objectArray2;
            n2 = dataInputStream.readInt();
            objectArray = new Object[n2];
            n = 0;
            while (n < n2) {
                objectArray2 = new Object[]{dataInputStream.readUTF(), new Integer(dataInputStream.readInt()), YoYo.symfalse};
                objectArray[n] = objectArray2;
                ++n;
            }
            Turtle.setVars(objectArray, this, context);
            n = dataInputStream.readInt();
            objectArray2 = new Object[n];
            int n4 = 0;
            while (n4 < n) {
                Object[] objectArray3 = new Object[]{dataInputStream.readUTF(), new Integer(dataInputStream.readInt())};
                objectArray2[n4] = objectArray3;
                ++n4;
            }
            Turtle.setBreeds(objectArray2, context);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            StarLogoError.error(this.app, "Error loading project file: Failed to read turtle variables. Continuing...", false);
            return;
        }
        try {
            this.whop = dataInputStream.readInt();
            if (this.whop > 4096) {
                this.whostack = new int[this.whop + 1];
            }
            n2 = 0;
            while (n2 < this.whop + 1) {
                this.whostack[n2] = dataInputStream.readInt();
                ++n2;
            }
            this.numturtles = dataInputStream.readInt();
            n2 = Turtle.getLength();
            objectArray = new byte[this.numturtles * n2];
            dataInputStream.read((byte[])objectArray);
            n = 0;
            int n5 = 0;
            while (n < this.numturtles) {
                Turtle turtle = Turtle.restore(this, (byte[])objectArray, n5);
                turtle.runstate = false;
                turtle.timer = 0L;
                turtle.count = 0;
                if (this.firstturtle != null) {
                    turtle.next = this.firstturtle;
                    this.firstturtle.prev = turtle;
                }
                this.firstturtle = turtle;
                this.wrapandlink(turtle);
                this.list.create(turtle);
                ++n;
                n5 += n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            this.killAll();
            this.whop = -1;
            StarLogoError.error(this.app, "Error loading project file: Failed to read turtles from project file. Continuing...", false);
            this.redraw();
            return;
        }
        this.redraw();
    }

    public final void savePatches(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("`patch state`");
        dataOutputStream.writeDouble(2.0);
        byte[] byArray = Patch.getStateDesc();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeInt(this.halfwidth);
        dataOutputStream.writeInt(this.halfheight);
        dataOutputStream.writeInt(Patch.numVars);
        int n = 0;
        while (n < Patch.numVars) {
            dataOutputStream.writeUTF(Patch.getVarName(n));
            dataOutputStream.writeInt(Patch.getVarPos(n));
            ++n;
        }
        int n2 = Patch.getLength();
        byte[] byArray2 = new byte[this.height * this.width * n2];
        int n3 = 0;
        int n4 = this.widthp2;
        int n5 = 0;
        while (n3 < this.height) {
            n = 0;
            while (n < this.width) {
                int n6 = n4 + n + 1;
                this.patches[n6].save(byArray2, n5);
                ++n;
                n5 += n2;
            }
            ++n3;
            n4 += this.widthp2;
        }
        dataOutputStream.write(byArray2);
    }

    public final void restorePatches(DataInputStream dataInputStream, Context context) throws IOException {
        Object object;
        int n;
        String string = "";
        try {
            string = dataInputStream.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.list.deletePatches();
            this.createPatches(3, false, false);
            return;
        }
        if (!string.equals("`patch state`")) {
            return;
        }
        double d = dataInputStream.readDouble();
        if (d > 2.0 || d < 2.0) {
            this.list.deletePatches();
            this.createPatches(3, false, false);
            StarLogoError.error(this.app, "Error loading project file: Failed to read patches. Data version is unknown: " + d, false);
            return;
        }
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.read(byArray);
        Patch.setStateDesc(byArray);
        this.halfwidth = dataInputStream.readInt();
        this.halfheight = dataInputStream.readInt();
        this.height = this.halfheight * 2 + 1;
        this.width = this.halfwidth * 2 + 1;
        this.widthp2 = this.width + 2;
        this.heightp2 = this.height + 2;
        this.turhalfheight = (double)this.height / 2.0;
        this.turhalfwidth = (double)this.width / 2.0;
        Patch[] patchArray = this.patches;
        this.patches = null;
        int n3 = 0;
        Object[] objectArray = null;
        try {
            n3 = dataInputStream.readInt();
            objectArray = new Object[n3];
            n = 0;
            while (n < n3) {
                Object[] objectArray2 = new Object[]{dataInputStream.readUTF(), new Integer(dataInputStream.readInt()), YoYo.symfalse};
                objectArray[n] = objectArray2;
                ++n;
            }
            Patch.setVars(objectArray, this, context);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            StarLogoError.error(this.app, "Error loading project file: Failed to read patch variables. Continuing...", false);
            this.patches = patchArray;
            this.list.deletePatches();
            this.createPatches(3, false, false);
            return;
        }
        Patch[] patchArray2 = new Patch[this.widthp2 * this.heightp2];
        int n4 = Patch.getLength();
        try {
            object = new byte[this.width * this.height * n4];
            dataInputStream.read((byte[])object);
            int n5 = 0;
            int n6 = this.widthp2;
            int n7 = 0;
            while (n5 < this.height) {
                int n8 = n6 + 1;
                n = 0;
                while (n < this.width) {
                    Patch patch = Patch.restore(this, object, n7);
                    patchArray2[n8++] = patch;
                    patch.runstate = false;
                    patch.timer = 0L;
                    patch.count = 0;
                    this.list.create(patch);
                    ++n;
                    n7 += n4;
                }
                ++n5;
                n6 += this.widthp2;
            }
            n6 = this.widthp2 * (this.heightp2 - 1);
            n = 0;
            while (n < this.widthp2) {
                patchArray2[n] = new Patch(n, 0.0, this);
                patchArray2[n + n6] = new Patch(n, this.heightp2 - 1, this);
                ++n;
            }
            n5 = this.widthp2;
            while (n5 < (this.heightp2 - 1) * this.widthp2) {
                patchArray2[n5] = new Patch(0.0, n5, this);
                patchArray2[n5 + this.width + 1] = new Patch(this.widthp2 - 1, n5, this);
                n5 += this.widthp2;
            }
            this.patches = patchArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            this.patches = patchArray;
            this.list.deletePatches();
            this.createPatches(3, false, false);
            StarLogoError.error(this.app, "Error reading project file: Failed to read patches from project file. Continuing...", false);
        }
        object = this.patchcanvas;
        if (serverside) {
            this.patchcanvas = new NetworkPatchCanvas(this, ((NetworkPatchCanvas)object).socket);
        } else {
            switch (altgraphics) {
                case 0: {
                    this.patchcanvas = new PatchCanvas(this);
                    break;
                }
                case 1: {
                    this.patchcanvas = new AltPatchCanvas(this);
                    break;
                }
            }
        }
        this.app.iface.replacePatchCanvas((PatchCanvas)object, this.patchcanvas);
    }

    public final void saveObserver(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF("`observer state`");
        dataOutputStream.writeDouble(2.0);
        byte[] byArray = Observer.getStateDesc();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeInt(Observer.numVars);
        int n = 0;
        while (n < Observer.numVars) {
            dataOutputStream.writeUTF(Observer.getVarName(n));
            dataOutputStream.writeInt(Observer.getVarPos(n));
            ++n;
        }
        byte[] byArray2 = new byte[Observer.getLength()];
        this.observer.save(byArray2, 0);
        dataOutputStream.write(byArray2);
    }

    public final void restoreObserver(DataInputStream dataInputStream, Context context) throws IOException {
        String string = "";
        try {
            string = dataInputStream.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return;
        }
        if (!string.equals("`observer state`")) {
            return;
        }
        double d = dataInputStream.readDouble();
        if (d > 2.0 || d < 2.0) {
            this.list.deleteObserver();
            this.observer = new Observer(this);
            this.list.create(this.observer);
            StarLogoError.error(this.app, "Error loading project file: Failed to read observer. Data version is unknown: " + d, false);
            return;
        }
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        Observer.setStateDesc(byArray);
        try {
            int n2 = dataInputStream.readInt();
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                Object[] objectArray2 = new Object[]{dataInputStream.readUTF(), new Integer(dataInputStream.readInt()), YoYo.symfalse};
                objectArray[n3] = objectArray2;
                ++n3;
            }
            Observer.setVars(objectArray, this, context);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            StarLogoError.error(this.app, "Error loading project file: Failed to read global variables. Continuing...", false);
            this.list.deleteObserver();
            this.observer = new Observer(this);
            this.list.create(this.observer);
            return;
        }
        this.list.remove(this.observer);
        try {
            byte[] byArray2 = new byte[Observer.getLength()];
            dataInputStream.read(byArray2);
            this.observer = Observer.restore(this, byArray2, 0);
            this.observer.runstate = false;
            this.observer.timer = 0L;
            this.observer.count = 0;
            this.list.create(this.observer);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
            this.list.deleteObserver();
            this.observer = new Observer(this);
            this.list.create(this.observer);
            StarLogoError.error(this.app, "Error loading project file: Failed to read observer from project file. Continuing...", false);
        }
    }

    StarLogo(Context context) {
        this.width = this.halfwidth * 2 + 1;
        this.height = this.halfheight * 2 + 1;
        this.turhalfheight = (double)this.height / 2.0;
        this.turhalfwidth = (double)this.width / 2.0;
        this.widthp2 = this.width + 2;
        this.heightp2 = this.height + 2;
        this.c = new Context(context);
        this.patches = new Patch[this.widthp2 * this.heightp2];
        this.observer = new Observer(this);
    }

    static {
        try {
            PictInstance = (Pictures)(YoYo.quicktimeavailablep ? Class.forName("starlogo.QTPictures").newInstance() : Class.forName("starlogo.NonQTPictures").newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

