/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import javax.swing.Icon;
import javax.swing.Timer;
import starlogo.Application;
import starlogo.Colors;
import starlogo.JShapeEditor;
import starlogo.StarLogo;
import starlogo.TurtleShapes;
import starlogo.WidgetDrag;

public class ShapeIcon
extends WidgetDrag
implements Icon,
ActionListener,
ImageProducer {
    JShapeEditor parent;
    int shapeNum;
    int tcolmask;
    int pcolmask;
    Image image;
    ImageConsumer ic;
    int[] pixels;
    private int size;
    int rowbytes;
    int width;
    int height;
    int heading;
    Application app;
    StarLogo sl;
    private boolean selected;
    private boolean rotatable;
    boolean rotating;
    TurtleShapes tempShape;
    Timer timer;
    boolean frozen = false;
    int delay = 500;
    ActionListener taskPerformer;

    public void refresh() {
        this.pixels = this.drawShape(this.shapeNum);
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public void updateSize(int n) {
        this.size = n;
        this.width = n;
        this.height = n;
        this.rowbytes = n;
        this.removeConsumer(null);
        this.image = this.parent.createImage(this);
        this.refresh();
    }

    public TurtleShapes getEditedShape() {
        return this.parent.editedShape;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setRotatable(boolean bl) {
        this.rotatable = bl;
        if (this.rotatable) {
            this.timer = new Timer(this.delay, this);
            this.timer.setInitialDelay(0);
        }
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public int getIconWidth() {
        return this.size;
    }

    public int getIconHeight() {
        return this.size;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.heading < 16) {
            this.rotating = true;
            ++this.heading;
            this.refresh();
            this.parent.repaint();
        } else {
            this.timer.stop();
            this.heading = 0;
        }
    }

    public void rotate() {
        this.rotating = true;
        this.heading += 4;
        this.refresh();
    }

    public int[] drawShape(int n) {
        int[] nArray;
        double[] dArray;
        int[] nArray2 = new int[this.size * this.size];
        int n2 = 0;
        if (!this.isRotatable()) {
            this.tempShape = this.getEditedShape().copy();
        } else if (!this.rotating) {
            this.tempShape = this.getEditedShape().copy();
        } else {
            this.tempShape = this.getEditedShape().copy();
            dArray = new double[this.tempShape.getColorsForSize(this.size)[0].length];
            nArray = new int[this.tempShape.getMasksForSize(this.size)[0].length];
            TurtleShapes.rotate(this.heading, this.tempShape.getColorsForSize(this.size)[0], this.tempShape.getMasksForSize(this.size)[0], dArray, nArray);
            this.tempShape.setColorsForSize(dArray, this.size);
            this.tempShape.setMasksForSize(nArray, this.size);
            this.tempShape.reRotateShapes();
        }
        dArray = this.tempShape.getColorsForSize(this.size)[0];
        nArray = this.tempShape.getMasksForSize(this.size)[0];
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray2[n2++] = nArray[2 * n3] == -1 ? this.tcolmask : (nArray[2 * n3 + 1] == -1 ? this.pcolmask : Colors.colorarrayints[(int)(dArray[n3] * 32.0)]);
            ++n3;
        }
        return nArray2;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.cm);
            imageConsumer.setDimensions(this.width, this.height);
        }
        imageConsumer.setHints(2);
        if (this.pixels == null) {
            this.pixels = this.drawShape(this.shapeNum);
        }
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        if (this.pixels == null) {
            this.pixels = this.drawShape(this.shapeNum);
        }
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.translate(this.position.x, this.position.y);
        graphics.drawImage(this.image, 0, 0, this);
        if (this.selected) {
            graphics.setColor(Color.red);
            graphics.drawRoundRect(0, 0, this.getIconWidth(), this.getIconHeight(), 2, 2);
        }
        graphics.translate(-this.position.x, -this.position.y);
    }

    public void toggleRotation() {
        if (this.rotatable) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else {
                this.timer.start();
            }
        }
    }

    ShapeIcon(int n, int n2, JShapeEditor jShapeEditor) {
        this.tcolmask = jShapeEditor.jsc.mainPanel.tcolmask;
        this.pcolmask = jShapeEditor.jsc.mainPanel.pcolmask;
        this.shapeNum = n;
        this.rotatable = false;
        this.size = n2;
        this.width = n2;
        this.height = n2;
        this.rowbytes = n2;
        this.parent = jShapeEditor;
        this.image = jShapeEditor.createImage(this);
        this.refresh();
    }
}

