/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.util.StringTokenizer;
import starlogo.Application;
import starlogo.ImageWaiter;
import starlogo.MessageDialog;
import starlogo.PrintingCanceledException;
import starlogo.RotateImageFilter;

public class Print {
    public static final int SCALE_FIT = 0;
    public static final int SCALE_XY = 1;
    public static final int SCALE_BOUNDS = 2;
    public static final int SCALE_X = 3;
    public static final int SCALE_Y = 4;
    public static final int SCALE_MIN = 5;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private PrintJob printJob;
    private Graphics pg;
    private int pixelsPerInch;
    private Dimension size;
    private Dimension actualSize;
    private boolean resIndependant;
    private Image printImage;
    private Graphics printGraphics;
    private Point offset;
    private Rectangle printRegion;
    private Point textPos;
    private int xBound;
    private int yBound;
    private boolean canceled = false;
    private boolean cleanedUp = false;
    private Frame parent;
    private int layout;
    private double topMargin;
    private double bottomMargin;
    private double leftMargin;
    private double rightMargin;
    private MessageDialog printMessage;

    private final void setupNextPage() {
        this.offset = new Point((int)(this.leftMargin * (double)this.pixelsPerInch), (int)(this.topMargin * (double)this.pixelsPerInch));
        this.textPos = new Point(this.offset);
        Dimension dimension = new Dimension(this.size);
        switch (this.layout) {
            case 0: {
                this.printImage = this.parent.createImage(this.size.width, this.size.height);
                this.printGraphics = this.printImage.getGraphics();
                this.printGraphics.setColor(Color.white);
                this.printGraphics.fillRect(0, 0, this.size.width, this.size.height);
                dimension.setSize(this.size.width - this.offset.x - (int)(this.rightMargin * (double)this.pixelsPerInch), this.size.height - this.offset.y - (int)(this.bottomMargin * (double)this.pixelsPerInch));
                break;
            }
            case 1: {
                this.printImage = this.parent.createImage(this.size.height, this.size.width);
                this.printGraphics = this.printImage.getGraphics();
                this.printGraphics.setColor(Color.white);
                this.printGraphics.fillRect(0, 0, this.size.height, this.size.width);
                dimension.setSize(this.size.height - this.offset.x - (int)(this.rightMargin * (double)this.pixelsPerInch), this.size.width - this.offset.y - (int)(this.bottomMargin * (double)this.pixelsPerInch));
                break;
            }
            default: {
                throw new PrintingException("invalid page orientation value");
            }
        }
        this.printRegion = new Rectangle(this.offset, dimension);
        this.pg = this.printJob.getGraphics();
        this.xBound = this.printRegion.x + this.printRegion.width;
        this.yBound = this.printRegion.y + this.printRegion.height;
    }

    public boolean canceled() {
        return this.canceled;
    }

    public Graphics getGraphics() throws PrintingCanceledException {
        this.testCanceled();
        return this.printGraphics;
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point point) {
        this.offset = point;
    }

    public int getPixelsinch() {
        return this.pixelsPerInch;
    }

    public Point getTextPosition() {
        return this.textPos;
    }

    public void setTextPosition(Point point) {
        this.textPos = point;
    }

    public Rectangle getPrintBounds() {
        return this.printRegion;
    }

    public int getYBound() {
        return this.yBound;
    }

    public int getXBound() {
        return this.xBound;
    }

    public Dimension getRoomLeft() {
        return new Dimension(this.xBound - this.offset.x, this.yBound - this.offset.y);
    }

    public void printText(String string, Font font, boolean bl) throws PrintingCanceledException {
        while (!string.equals("")) {
            if ((string = this.printText(string, font, Color.black, this.xBound, this.yBound, bl, true, true)).equals("")) continue;
            this.nextPage();
        }
    }

    private final String genLeftOvers(StringTokenizer stringTokenizer, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken(""));
        }
        if (bl) {
            this.offset.y = this.textPos.y;
        }
        return stringBuffer.toString();
    }

    public String printText(String string, Font font, Color color, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws PrintingCanceledException {
        this.testCanceled();
        n2 = Math.min(this.yBound, n2);
        n = Math.min(n, this.xBound);
        Font font2 = font;
        FontMetrics fontMetrics = this.parent.getToolkit().getFontMetrics(font2);
        if (n - this.offset.x < fontMetrics.getMaxAdvance()) {
            throw new PrintingException();
        }
        int n3 = fontMetrics.getMaxAscent();
        int n4 = fontMetrics.getMaxDescent();
        int n5 = n3 + n4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", true);
        String string2 = "";
        this.printGraphics.setFont(font2);
        this.printGraphics.setColor(color);
        while (stringTokenizer.hasMoreTokens()) {
            int n6;
            this.testCanceled();
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\n")) {
                this.textPos.setLocation(this.offset.x, this.textPos.y + n5);
                if (this.textPos.y + n5 < n2) continue;
                return this.genLeftOvers(stringTokenizer, string2, bl3);
            }
            if (string3.equals("\r")) {
                this.textPos.setLocation(this.offset.x, this.textPos.y + n5);
                if (this.textPos.y + n5 >= n2) {
                    return this.genLeftOvers(stringTokenizer, string2, bl3);
                }
                if (!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken()).equals("\n")) continue;
            }
            if (this.textPos.x + (n6 = fontMetrics.stringWidth(string3)) < n) {
                this.printGraphics.drawString(string3, this.textPos.x, this.textPos.y + n3);
                this.textPos.x += n6;
                continue;
            }
            if (bl || string3.equals(" ")) {
                this.textPos.setLocation(this.offset.x, this.textPos.y + n5);
                if (this.textPos.y + n5 >= n2) {
                    return this.genLeftOvers(stringTokenizer, string2, bl3);
                }
            }
            if (string3.equals(" ")) continue;
            if (this.textPos.x + n6 < n) {
                this.printGraphics.drawString(string3, this.textPos.x, this.textPos.y + n3);
                this.textPos.x += n6;
                continue;
            }
            char[] cArray = string3.toCharArray();
            int n7 = 0;
            while (n7 < cArray.length) {
                int n8 = n7;
                while (this.textPos.x + (n6 = fontMetrics.charsWidth(cArray, n7, n8 - n7 + 1)) < n && ++n8 < cArray.length) {
                }
                if (--n8 >= n7) {
                    this.printGraphics.drawChars(cArray, n7, n8 - n7 + 1, this.textPos.x, this.textPos.y + n3);
                    this.textPos.x += fontMetrics.charsWidth(cArray, n7, n8 - n7 + 1);
                }
                if (n8 < cArray.length - 1) {
                    this.textPos.setLocation(this.offset.x, this.textPos.y + n5);
                    if (this.textPos.y + n5 >= n2) {
                        string2 = string2 + String.copyValueOf(cArray, n8 + 1, cArray.length - n8 - 1);
                        return this.genLeftOvers(stringTokenizer, string2, bl3);
                    }
                }
                n7 = n8 + 1;
            }
        }
        if (bl3) {
            this.offset.y = this.textPos.y + n5;
        }
        if (bl2) {
            this.textPos.setLocation(this.offset.x, this.textPos.y + n5);
        }
        return string2;
    }

    private final Image getImage(Component component) throws PrintingCanceledException {
        this.testCanceled();
        Dimension dimension = component.getSize();
        Image image = component.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        component.printAll(graphics);
        graphics.dispose();
        return image;
    }

    public void printComponent(Component component) throws PrintingCanceledException {
        Image image = this.getImage(component);
        this.printImage(image);
    }

    public void printComponent(Component component, Rectangle rectangle, Dimension dimension) throws PrintingCanceledException {
        Image image = this.getImage(component);
        this.printImage(image, rectangle, dimension);
    }

    public void printComponent(Component component, Rectangle rectangle, int n) throws PrintingCanceledException {
        Image image = this.getImage(component);
        this.printImage(image, rectangle, n);
    }

    public void printComponent(Component component, Dimension dimension) throws PrintingCanceledException {
        Image image = this.getImage(component);
        this.printImage(image, dimension);
    }

    public void printComponent(Component component, int n) throws PrintingCanceledException {
        Image image = this.getImage(component);
        this.printImage(image, n);
    }

    public void printImage(Image image) throws PrintingCanceledException {
        this.printImage(image, 1);
    }

    public void printImage(Image image, Dimension dimension) throws PrintingCanceledException {
        int n = ImageWaiter.getValue(image, 1);
        int n2 = ImageWaiter.getValue(image, 2);
        this.printImage(image, new Rectangle(0, 0, n, n2), dimension);
    }

    public void printImage(Image image, int n) throws PrintingCanceledException {
        int n2 = ImageWaiter.getValue(image, 1);
        int n3 = ImageWaiter.getValue(image, 2);
        this.printImage(image, new Rectangle(0, 0, n2, n3), n);
    }

    public void printImage(Image image, Rectangle rectangle, Dimension dimension) throws PrintingCanceledException {
        this.testCanceled();
        dimension.setSize(Math.min(dimension.width, this.xBound - this.offset.x), Math.min(dimension.height, this.yBound - this.offset.y));
        image = this.parent.getToolkit().createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height)));
        if (!ImageWaiter.drawImage(this.printGraphics, image.getScaledInstance(dimension.width, dimension.height, 4), this.offset.x, this.offset.y)) {
            throw new PrintingException("error printing image");
        }
    }

    public void printImage(Image image, Rectangle rectangle, int n) throws PrintingCanceledException {
        this.testCanceled();
        int n2 = ImageWaiter.getValue(image, 1);
        int n3 = ImageWaiter.getValue(image, 2);
        int n4 = this.xBound - this.offset.x;
        int n5 = this.yBound - this.offset.y;
        switch (n) {
            case 0: {
                n2 = n4;
                n3 = n5;
                break;
            }
            case 1: {
                double d = Math.min((double)n4 / (double)n2, (double)n5 / (double)n3);
                n2 = (int)((double)n2 * d);
                n3 = (int)((double)n3 * d);
                break;
            }
            case 2: {
                double d = Math.min((double)n4 / (double)n2, (double)n5 / (double)n3);
                if (!(d < 1.0)) break;
                n2 = (int)((double)n2 * d);
                n3 = (int)((double)n3 * d);
                break;
            }
            case 3: {
                n2 = n4;
                n3 = Math.min(n5, n3);
                break;
            }
            case 4: {
                n2 = Math.min(n4, n2);
                n3 = n5;
                break;
            }
            case 5: {
                n2 = Math.min(n4, n2);
                n3 = Math.min(n5, n3);
                break;
            }
            default: {
                throw new PrintingException("invalid scaling value");
            }
        }
        image = this.parent.getToolkit().createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height)));
        if (!ImageWaiter.drawImage(this.printGraphics, image.getScaledInstance(n2, n3, 4), this.offset.x, this.offset.y)) {
            throw new PrintingException("error printing image");
        }
    }

    public void print() throws PrintingCanceledException {
        this.testCanceled();
        this.printCurrentPage();
        this.printJob.end();
        this.canceled = true;
        this.cleanedUp = true;
        this.clearPrintingMessage();
    }

    public void nextPage(int n) throws PrintingCanceledException {
        this.testCanceled();
        this.printCurrentPage();
        this.layout = n;
        this.testCanceled();
        this.setupNextPage();
    }

    public void nextPage() throws PrintingCanceledException {
        this.testCanceled();
        this.printCurrentPage();
        this.testCanceled();
        this.setupNextPage();
    }

    public void nextPage(int n, double d, double d2, double d3, double d4) throws PrintingCanceledException {
        this.testCanceled();
        this.printCurrentPage();
        this.layout = n;
        this.topMargin = d;
        this.bottomMargin = d2;
        this.leftMargin = d3;
        this.rightMargin = d4;
        this.testCanceled();
        this.setupNextPage();
    }

    private final void printCurrentPage() {
        this.printGraphics.dispose();
        if (this.layout == 1) {
            this.printImage = this.parent.getToolkit().createImage(new FilteredImageSource(this.printImage.getSource(), new RotateImageFilter()));
        }
        if (this.resIndependant ? !ImageWaiter.drawImage(this.pg, this.printImage.getScaledInstance(this.actualSize.width, this.actualSize.height, 4), 0, 0) : !ImageWaiter.drawImage(this.pg, this.printImage, 0, 0)) {
            throw new PrintingException("error printing page buffer");
        }
        this.pg.dispose();
    }

    public void cancel() {
        this.canceled = true;
    }

    protected void finalize() throws Throwable {
        if (!this.cleanedUp) {
            this.printJob.end();
            this.pg.dispose();
            this.printGraphics.dispose();
        }
        super.finalize();
    }

    private final void testCanceled() throws PrintingCanceledException {
        if (this.canceled && !this.cleanedUp) {
            this.printJob.end();
            this.pg.dispose();
            this.printGraphics.dispose();
            this.cleanedUp = true;
            throw new PrintingCanceledException();
        }
        if (this.canceled) {
            throw new PrintingCanceledException();
        }
    }

    public void displayPrintingMessage(boolean bl) {
        new PrintingMessageDialog(this, this.parent, bl);
        Thread.currentThread();
        Thread.yield();
    }

    public void clearPrintingMessage() {
        if (this.printMessage != null) {
            this.printMessage.kill();
        }
    }

    static /* synthetic */ MessageDialog access$0(Print print) {
        return print.printMessage;
    }

    public Print(Frame frame, String string, int n, double d, double d2, double d3, double d4, boolean bl) throws PrintingCanceledException {
        this.parent = frame;
        this.resIndependant = bl;
        this.layout = n;
        this.topMargin = d;
        this.bottomMargin = d2;
        this.leftMargin = d3;
        this.rightMargin = d4;
        this.printJob = frame.getToolkit().getPrintJob(frame, string, null);
        if (this.printJob == null) {
            this.canceled = true;
            this.cleanedUp = true;
            throw new PrintingCanceledException();
        }
        this.pixelsPerInch = this.printJob.getPageResolution();
        this.size = this.printJob.getPageDimension();
        if (bl && this.pixelsPerInch != 72) {
            this.pixelsPerInch = 72;
            this.actualSize = this.size;
            this.size.setSize(612, 792);
        } else {
            bl = false;
        }
        this.setupNextPage();
    }

    private class PrintingMessageDialog
    implements Runnable {
        private Print printInstance;
        private boolean allowCancel;
        private Frame parent;

        public void run() {
            MessageDialog messageDialog = Application.createMessageDialog(this.parent, "Printing", "Printing in progress, please be patient", false, true, true, false, 1);
            this.printInstance.printMessage = messageDialog;
            messageDialog.show();
            if (messageDialog.canceled()) {
                this.printInstance.cancel();
            }
            messageDialog.dispose();
        }

        public PrintingMessageDialog(Print print2, Frame frame, boolean bl) {
            this.printInstance = print2;
            this.allowCancel = bl;
            this.parent = frame;
            Thread thread = new Thread(this);
            thread.setPriority(10);
            thread.start();
        }
    }

    private class PrintingException
    extends RuntimeException {
        public PrintingException() {
        }

        public PrintingException(String string) {
            super(string);
        }
    }
}

