/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import starlogo.SLDialog;
import yoyo.YoYo;

abstract class NSLDialog
extends Dialog
implements SLDialog {
    static Font TEXT_FONT;
    static Font LABEL_FONT;
    static int avgFontHeight;
    static int avgFontWidth;
    protected Frame parent;

    public void addNotify() {
        super.addNotify();
        ((Component)this).setBackground(SystemColor.control);
    }

    protected void initOKCancel(Button button, Button button2) {
        new OKCancel(button, button2);
    }

    protected void initFocus(Component component) {
        FocusGrabber focusGrabber = new FocusGrabber(component);
        this.addFocusListener(focusGrabber);
        this.addWindowListener(focusGrabber);
    }

    protected void initShortcuts() {
        NSLDialog.addKeyListeners(this, new Shortcuts(this));
    }

    protected void initLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        Dimension dimension2 = this.getSize();
        int n2 = dimension2.width;
        if (!YoYo.solarisp) {
            ((Component)this).setLocation((n - n2) / 2, 60);
        }
    }

    public static void formatText(TextComponent textComponent) {
        textComponent.setFont(TEXT_FONT);
        NSLDialog.colorText(textComponent);
    }

    public static void formatLabel(Component component) {
        component.setFont(LABEL_FONT);
        NSLDialog.colorControl(component);
    }

    public static void colorControl(Component component) {
        component.setBackground(SystemColor.control);
        component.setForeground(SystemColor.controlText);
    }

    public static void colorText(TextComponent textComponent) {
        textComponent.setBackground(Color.white);
        textComponent.setForeground(Color.black);
    }

    protected void cancel() {
        ((Component)this).setVisible(false);
    }

    protected void ok() {
        ((Component)this).setVisible(false);
    }

    protected static void addKeyListeners(Container container, KeyListener keyListener) {
        container.addKeyListener(keyListener);
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                NSLDialog.addKeyListeners((Container)componentArray[n], keyListener);
            } else {
                componentArray[n].addKeyListener(keyListener);
            }
            ++n;
        }
    }

    public boolean shortcutsOn() {
        return true;
    }

    public void initAverages() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Font.getFont("Dialog"));
        avgFontHeight = fontMetrics.getHeight();
        int[] nArray = fontMetrics.getWidths();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        avgFontWidth = n / nArray.length;
    }

    public int dluToPixelsHorizontal(int n) {
        if (YoYo.pcp) {
            if (avgFontHeight == 0 || avgFontWidth == 0) {
                this.initAverages();
            }
            return n * avgFontWidth / 4;
        }
        return n;
    }

    public int dluToPixelsVertical(int n) {
        if (YoYo.pcp) {
            if (avgFontHeight == 0 || avgFontWidth == 0) {
                this.initAverages();
            }
            return n * avgFontHeight / 8;
        }
        return n;
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    protected NSLDialog(Frame frame, String string, boolean bl) {
        super(frame == null ? new Frame() : frame, string, bl);
        this.parent = frame;
        this.addWindowListener(new Closer());
        if (!YoYo.unixp) {
            this.setResizable(false);
        }
        this.addNotify();
    }

    static {
        try {
            TEXT_FONT = new Font("Monospaced", 0, 12);
            if (YoYo.macintoshp) {
                TEXT_FONT = Font.getFont("starlogo.text.font", TEXT_FONT);
            }
            LABEL_FONT = new Font("Dialog", 0, 12);
            if (YoYo.macintoshp) {
                LABEL_FONT = Font.getFont("starlogo.label.font", LABEL_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class OKCancel
    implements ActionListener {
        private final Button bok;
        private final Button bcancel;

        public void actionPerformed(ActionEvent actionEvent) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bok) {
                NSLDialog.this.ok();
            } else if (button == this.bcancel) {
                NSLDialog.this.cancel();
            }
        }

        public OKCancel(Button button, Button button2) {
            this.bok = button;
            this.bcancel = button2;
            if (button != null) {
                button.addActionListener(this);
            }
            if (button2 != null) {
                button2.addActionListener(this);
            }
        }
    }

    private class Shortcuts
    extends KeyAdapter {
        private NSLDialog sld;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\n' || c == '\r') {
                if (this.sld.shortcutsOn()) {
                    keyEvent.consume();
                    NSLDialog.this.ok();
                }
            } else if (c == '\u001b' && this.sld.shortcutsOn()) {
                keyEvent.consume();
                NSLDialog.this.cancel();
            }
        }

        public Shortcuts(NSLDialog nSLDialog2) {
            this.sld = nSLDialog2;
        }
    }

    private class Closer
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            NSLDialog.this.cancel();
        }

        Closer() {
        }
    }

    private class FocusGrabber
    extends WindowAdapter
    implements FocusListener {
        Component focus;

        public void focusGained(FocusEvent focusEvent) {
            this.focus.requestFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.focus.requestFocus();
        }

        public FocusGrabber(Component component) {
            this.focus = component;
        }
    }
}

