/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.ControlCenter;
import starlogo.NControlCenter;
import starlogo.NControlCenterTextArea;
import starlogo.NSLDialog;
import starlogo.Patch;
import starlogo.ProcMouseAdapter;
import starlogo.SLCommand;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import yoyo.Context;
import yoyo.Listener;
import yoyo.NTEStream;
import yoyo.Reader;
import yoyo.YoYo;

public class NSLCommand
extends Listener
implements SLCommand,
NControlCenterTextArea {
    public static final String obsPrefix = "compile-observer-cc ";
    public static final String turPrefix = "compile-turtle-cc ";
    public static final String patPrefix = "compile-patch-cc ";
    public static final String whoPrefix = "[if who = ";
    public static Font PROC_FONT;
    String who;
    StarLogo sl;
    PrintWriter pw;
    public boolean runningp = false;
    int which;
    boolean whop = false;
    Patch patch = null;
    Label label;
    NControlCenter ncc;
    private Vector spps = new Vector();
    private int sppcount = 0;

    public void runLine(String string) {
        if (this.runningp) {
            this.c.stop();
            this.stopAll();
        }
        if (!this.sl.app.maybeCompile()) {
            super.done(this.c);
            return;
        }
        this.runningp = true;
        if (string.equalsIgnoreCase("cc") || string.equalsIgnoreCase("clear-command-center")) {
            this.callerClearText();
        }
        if (string != "" && string != null) {
            Object[] objectArray = null;
            switch (this.which) {
                case 0: {
                    objectArray = Reader.read(turPrefix + (this.whop ? whoPrefix + this.who : "") + "[" + string + "]");
                    break;
                }
                case 2: {
                    objectArray = Reader.read("compile-observer-cc [" + string + "]");
                    break;
                }
                case 1: {
                    objectArray = Reader.read("compile-patch-cc [" + string + "]");
                    break;
                }
            }
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this;
            this.sl.app.cc.enqueue(objectArray2, this.sl.app.message, this.sl.app.err, null);
        }
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n2 = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
                switch (this.which) {
                    case 0: {
                        StackProcessParent.runTurtles(this.sl, n2, false, this);
                        break;
                    }
                    case 2: {
                        StackProcessParent.runObserver(this.sl, n2, false, this);
                        break;
                    }
                    case 1: {
                        StackProcessParent.runPatch(this.sl, n2, this.patch, false, this);
                        break;
                    }
                }
            }
        }
    }

    public void done(Context context) {
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0 && this.runningp) {
            super.done(null);
            this.runningp = false;
            this.linemark = -1;
        }
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void displayOneString(String string) {
        string = string + "\n";
        if (this.runningp) {
            super.done(null);
            int n = this.getCaretPosition();
            this.insert(string, n);
            this.select(n, n + string.length());
            this.linemark = -1;
            this.runningp = false;
        } else {
            int n = this.getCaretPosition();
            this.insert(string, n);
            this.select(n, n + string.length());
        }
    }

    public void displayAString(String string) {
        if (this.runningp) {
            int n = this.getCaretPosition();
            if (this.linemark > 0) {
                this.replaceRange(string, this.linemark, this.linemark + 1);
            } else {
                this.insert(string, n);
            }
            if (n > 0) {
                this.setCaretPosition(n > this.linemark ? n + string.length() : n + string.length() - 1);
            }
            this.select(n, n + string.length());
            this.linemark = -1;
        } else {
            int n = this.getCaretPosition();
            this.insert(string, n);
            this.select(n, n + string.length());
        }
    }

    public void callerPrintln(String string) {
        this.println(string);
    }

    public void callerClearText() {
        if (!this.getText().equals("")) {
            this.setText("");
        }
    }

    public void flush() {
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        int n = this.getCaretPosition();
        this.insert(string, n);
        this.setCaretPosition(n + string.length());
    }

    public NSLCommand(int n, StarLogo starLogo, NControlCenter nControlCenter) {
        super("", 1);
        this.pw = new PrintWriter(new NTEStream(this), true);
        this.sl = starLogo;
        this.which = n;
        this.ncc = nControlCenter;
        this.c = nControlCenter.app.cc;
        NSLDialog.colorText(this);
        this.setFont(PROC_FONT);
        switch (n) {
            case 0: {
                this.label = new Label("Turtle Command Center");
                this.label.setBackground(new Color(23, 118, 51));
                break;
            }
            case 2: {
                this.label = new Label("Observer Command Center");
                this.label.setBackground(new Color(92, 61, 36));
                break;
            }
            case 1: {
                this.label = new Label("Patch Command Center");
                this.label.setBackground(new Color(23, 118, 51));
                break;
            }
        }
        this.label.setFont(NSLDialog.LABEL_FONT);
        this.label.setForeground(Color.white);
        this.addKeyListener(new CommandKeyAdapter(this));
        this.addMouseListener(new ControlMouseAdapter(this));
    }

    public NSLCommand(int n, StarLogo starLogo, int n2, Application application) {
        super("", 1);
        this.pw = new PrintWriter(new NTEStream(this), true);
        this.sl = starLogo;
        this.which = n;
        this.c = application.cc;
        NSLDialog.colorText(this);
        this.setFont(PROC_FONT);
        this.whop = true;
        this.who = new String(Integer.toString(n2));
        this.label = new Label("Turtle #" + this.who + " Command Center");
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setForeground(Color.white);
        this.label.setBackground(new Color(23, 118, 51));
        this.addKeyListener(new CommandKeyAdapter(this));
    }

    public NSLCommand(int n, StarLogo starLogo, Patch patch, Application application) {
        super("", 1);
        this.pw = new PrintWriter(new NTEStream(this), true);
        this.sl = starLogo;
        this.which = n;
        this.c = application.cc;
        this.patch = patch;
        NSLDialog.colorText(this);
        this.setFont(PROC_FONT);
        this.label = new Label("Patch " + patch.toString() + " Command Center");
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setForeground(Color.white);
        this.label.setBackground(new Color(23, 118, 51));
        this.addKeyListener(new CommandKeyAdapter(this));
    }

    static {
        try {
            PROC_FONT = new Font("Monospaced", 0, 12);
            if (YoYo.macintoshp) {
                PROC_FONT = Font.getFont("starlogo.procedures.font", PROC_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class CommandKeyAdapter
    extends KeyAdapter {
        NSLCommand parent;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (this.parent.c.runningnowp) {
                keyEvent.consume();
                return;
            }
            if (!this.parent.donep()) {
                keyEvent.consume();
                return;
            }
            if (c == '\r' || c == '\n') {
                keyEvent.consume();
                return;
            }
            if (c == '\t' && keyEvent.isControlDown()) {
                if (this.parent.ncc != null) {
                    NControlCenter cfr_ignored_0 = this.parent.ncc;
                    this.parent.ncc.actionPerformedOnButton(this.parent.ncc.cur == ControlCenter.tur ? this.parent.ncc.obsBut : this.parent.ncc.turBut);
                }
                keyEvent.consume();
                return;
            }
            if (YoYo.macintoshp && keyEvent.isMetaDown() && keyEvent.getKeyChar() == '.') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
            if (!YoYo.macintoshp && keyEvent.isControlDown() && keyEvent.getKeyChar() == 'c') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (this.parent.c.runningnowp) {
                this.parent.c.stop();
                Object object = NSLCommand.this.sl.runningp;
                synchronized (object) {
                    this.parent.stopAll();
                }
                keyEvent.consume();
                return;
            }
            if (!this.parent.donep()) {
                Object object = NSLCommand.this.sl.runningp;
                synchronized (object) {
                    this.parent.stopAll();
                }
                keyEvent.consume();
                return;
            }
            if (c == '\r' || c == '\n') {
                this.parent.handlecr();
                keyEvent.consume();
                return;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
        }

        public CommandKeyAdapter(NSLCommand nSLCommand2) {
            this.parent = nSLCommand2;
        }
    }

    public class ControlMouseAdapter
    extends ProcMouseAdapter {
        NSLCommand parent;

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this.parent.requestFocus();
            this.parent.ncc.textFocus = this.parent;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
        }

        public ControlMouseAdapter(NSLCommand nSLCommand2) {
            super(nSLCommand2);
            this.parent = nSLCommand2;
        }
    }
}

