/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import starlogo.DoubleInsets;
import starlogo.NSLDialog;
import starlogo.PrintDialog;
import yoyo.YoYo;

public class NPrintDialog
extends NSLDialog
implements PrintDialog {
    private Frame parent;
    private boolean orientations;
    private boolean margins;
    private boolean resizableOptions;
    private boolean resolutionIndependence;
    public boolean canceled = false;
    public double topMargin = 1.0;
    public double bottomMargin = 1.0;
    public double leftMargin = 1.0;
    public double rightMargin = 1.0;
    public int orientation = 0;
    public int resizingOption = 2;
    public boolean resIndependant = false;
    private Button bok;
    private Button bca;
    private Panel okcaPanel;
    private Label orientationLabel;
    private CheckboxGroup orientationGroup;
    private Checkbox portrait;
    private Checkbox landscape;
    private Panel orientationPanel;
    private Label marginLabel;
    private Label[] marginLabels = new Label[4];
    private TextField[] marginTexts = new TextField[4];
    private Panel marginPanel;
    private Label resizeLabel;
    private CheckboxGroup resizingGroup;
    private Checkbox zoomToFit;
    private Checkbox none;
    private Panel resizePanel;
    private Label resolutionIndependantLabel;
    private Checkbox resolutionIndependant;
    private Panel resPanel;

    public void setInitialMargins(double d, double d2, double d3, double d4) {
        this.marginTexts[0].setText(String.valueOf(d));
        this.marginTexts[1].setText(String.valueOf(d2));
        this.marginTexts[2].setText(String.valueOf(d3));
        this.marginTexts[3].setText(String.valueOf(d4));
    }

    public void setInitialResIndependant(boolean bl) {
        this.resolutionIndependant.setState(bl);
    }

    public void setInitialResizeOp(int n) {
        if (n == 5) {
            this.none.setState(true);
        }
        if (n == 1) {
            this.zoomToFit.setState(true);
        }
    }

    public void setInitialOrientation(int n) {
        if (n == 0) {
            this.portrait.setState(true);
        }
        if (n == 1) {
            this.landscape.setState(true);
        }
    }

    public DoubleInsets getMargins() {
        return new DoubleInsets(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getResIndependent() {
        return this.resIndependant;
    }

    public int getResizingOption() {
        return this.resizingOption;
    }

    public boolean canceledp() {
        return this.canceled;
    }

    public void setupComponents() {
        if (this.orientations) {
            this.orientationPanel = new Panel(new GridLayout(3, 1, 4, 4));
            this.orientationLabel = new Label("Select Page Orientation");
            NSLDialog.formatLabel(this.orientationLabel);
            this.orientationGroup = new CheckboxGroup();
            this.portrait = new Checkbox("Portrait", true, this.orientationGroup);
            this.landscape = new Checkbox("Landscape", false, this.orientationGroup);
            NSLDialog.formatLabel(this.portrait);
            NSLDialog.formatLabel(this.landscape);
            this.orientationPanel.add(this.orientationLabel);
            this.orientationPanel.add(this.portrait);
            this.orientationPanel.add(this.landscape);
        }
        if (this.margins) {
            this.marginLabel = new Label("Margins (inches)");
            NSLDialog.formatLabel(this.marginLabel);
            this.marginPanel = new Panel(new GridLayout(4, 2, 4, 4));
            this.marginLabels[0] = new Label("Top");
            this.marginLabels[1] = new Label("Bottom");
            this.marginLabels[2] = new Label("Left");
            this.marginLabels[3] = new Label("Right");
            int n = 0;
            while (n < 4) {
                this.marginTexts[n] = new TextField("1.0", 4);
                NSLDialog.formatLabel(this.marginLabels[n]);
                NSLDialog.formatText(this.marginTexts[n]);
                this.marginPanel.add(this.marginLabels[n]);
                this.marginPanel.add(this.marginTexts[n]);
                ++n;
            }
        }
        if (this.resizableOptions) {
            this.resizePanel = new Panel(new GridLayout(3, 1, 4, 4));
            this.resizeLabel = new Label("Select Zooming Option");
            NSLDialog.formatLabel(this.resizeLabel);
            this.resizingGroup = new CheckboxGroup();
            this.zoomToFit = new Checkbox("Zoom to fit", false, this.resizingGroup);
            this.none = new Checkbox("None", true, this.resizingGroup);
            NSLDialog.formatLabel(this.zoomToFit);
            NSLDialog.formatLabel(this.none);
            this.resizePanel.add(this.resizeLabel);
            this.resizePanel.add(this.zoomToFit);
            this.resizePanel.add(this.none);
        }
        if (this.resolutionIndependence) {
            this.resPanel = new Panel(new GridLayout(2, 1, 4, 4));
            this.resolutionIndependantLabel = new Label("select only if text is printing to small/large");
            this.resolutionIndependant = new Checkbox("print resolution independant", false);
            NSLDialog.formatLabel(this.resolutionIndependantLabel);
            NSLDialog.formatLabel(this.resolutionIndependant);
            this.resPanel.add(this.resolutionIndependantLabel);
            this.resPanel.add(this.resolutionIndependant);
        }
        this.okcaPanel = new Panel(new GridLayout(1, 2, 4, 4));
        this.bok = new Button("OK");
        this.bca = new Button("Cancel");
        NSLDialog.formatLabel(this.bok);
        NSLDialog.formatLabel(this.bca);
        if (YoYo.macintoshp) {
            this.okcaPanel.add(this.bca);
            this.okcaPanel.add(this.bok);
        } else {
            this.okcaPanel.add(this.bok);
            this.okcaPanel.add(this.bca);
        }
    }

    public void setupGBC() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(13, 13, 13, 13);
        if (this.orientations) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 11;
            this.add((Component)this.orientationPanel, gridBagConstraints);
        }
        if (this.margins) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 15;
            this.add((Component)this.marginLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 11;
            this.add((Component)this.marginPanel, gridBagConstraints);
        }
        if (this.resizableOptions) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 11;
            this.add((Component)this.resizePanel, gridBagConstraints);
        }
        if (this.resolutionIndependence) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 15;
            this.add((Component)this.resPanel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.okcaPanel, gridBagConstraints);
    }

    public void setupPosition() {
        ((Component)this).setSize(360, YoYo.solarisp ? 200 : (YoYo.linuxp ? 240 : (YoYo.pcp ? 200 : 170)));
        this.initLocation();
    }

    public void ok() {
        this.getValues();
        this.canceled = false;
        ((Component)this).setVisible(false);
    }

    public void cancel() {
        this.canceled = true;
        ((Component)this).setVisible(false);
    }

    private final void getValues() {
        if (this.resizableOptions) {
            if (this.none.getState()) {
                this.resizingOption = 2;
            }
            if (this.zoomToFit.getState()) {
                this.resizingOption = 1;
            }
        }
        if (this.resolutionIndependence) {
            this.resIndependant = this.resolutionIndependant.getState();
        }
        if (this.orientations) {
            if (this.portrait.getState()) {
                this.orientation = 0;
            }
            if (this.landscape.getState()) {
                this.orientation = 1;
            }
        }
        if (this.margins) {
            try {
                this.topMargin = Double.valueOf(this.marginTexts[0].getText());
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                this.bottomMargin = Double.valueOf(this.marginTexts[1].getText());
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                this.leftMargin = Double.valueOf(this.marginTexts[2].getText());
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                this.rightMargin = Double.valueOf(this.marginTexts[3].getText());
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public NPrintDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(frame, "Print Options", true);
        this.parent = frame;
        this.orientations = bl;
        this.margins = bl2;
        this.resizableOptions = bl3;
        this.resolutionIndependence = bl4;
        this.setupComponents();
        this.setupGBC();
        this.setupPosition();
        this.initOKCancel(this.bok, this.bca);
        this.initShortcuts();
        this.pack();
    }
}

