/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Hashtable;
import starlogo.Application;
import starlogo.Colors;
import starlogo.NEntityMonitor;
import starlogo.NSLCommand;
import starlogo.NSLMenu;
import starlogo.Patch;
import starlogo.PatchMonitor;
import starlogo.StackProcessParent;
import starlogo.WindowPosition;
import yoyo.YoYo;

public class NPatchMonitor
extends NEntityMonitor
implements PatchMonitor {
    static Hashtable pmhash = new Hashtable();
    public static final int XCOR = 1;
    public static final int YCOR = 2;
    public static final int PC = 3;
    static int numVars;
    Patch pat;
    CardLayout cl;
    Label color_lbl = new Label("PC");
    TextField color_txt = new TextField();
    double colorval;
    Label xcor_lbl = new Label("Xcor");
    Label xcor_txt;
    double xcorval;
    Label ycor_lbl = new Label("Ycor");
    Label ycor_txt;
    double ycorval;

    public int getNumVars() {
        return numVars;
    }

    void setStateFields(Dimension dimension) {
        this.xcor_txt = new Label(Integer.toString((int)(this.pat.xcor - 1.0 - (double)this.sl.halfwidth)));
        this.ycor_txt = new Label(Integer.toString((int)((double)this.sl.halfheight - (this.pat.ycor - 1.0))));
        this.color_txt.setName("PC");
        this.color_txt.setSize(dimension);
        this.xcor_txt.setSize(dimension);
        this.ycor_txt.setSize(dimension);
        this.color_lbl.setSize(dimension);
        this.xcor_lbl.setSize(dimension);
        this.ycor_lbl.setSize(dimension);
        this.color_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.xcor_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.ycor_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.formatText(this.color_txt);
    }

    public String getVarName(int n) {
        return Patch.getVarName(n);
    }

    public int getVarPos(int n) {
        return Patch.getVarPos(n);
    }

    public Object getVarValue(int n) {
        return this.pat.turtlesown[n];
    }

    public boolean getVarEnump(int n) {
        return Patch.getVarEnump(n);
    }

    public synchronized void setValues(int n) {
        switch (n) {
            case 3: {
                this.colorval = this.pat.pc;
                this.color_txt.setText(this.colname(this.colorval));
                this.color_txt.setCaretPosition(this.color_txt.getText().length());
                this.wholePanel.setBackground(Colors.colorarray[(int)(this.getEntityColor() * 32.0)]);
                this.wholePanel.repaint();
                break;
            }
        }
    }

    public void initFrame() {
        if (this.pat == null) {
            return;
        }
        if (YoYo.macintoshp) {
            this.slmenu = new NSLMenu(this, this.app);
            this.slmenu.setMenuBar(this);
        }
        numVars = Patch.numVars;
        this.setFields();
        int n = this.own_txt == null ? 0 : this.own_txt[0].getPreferredSize().height;
        n = 22;
        this.addMyComponents(n);
        this.com.callerClearText();
        if (YoYo.applet == null) {
            this.addListeners();
        }
        this.setValues(3);
        int n2 = 0;
        while (n2 < numVars) {
            this.setOwn(n2);
            ++n2;
        }
        this.startThread();
    }

    public Label[] getStateLabels() {
        Label[] labelArray = new Label[]{this.xcor_lbl, this.ycor_lbl, this.color_lbl};
        return labelArray;
    }

    public Component[] getStateTexts() {
        Component[] componentArray = new Component[]{this.xcor_txt, this.ycor_txt, this.color_txt};
        return componentArray;
    }

    public int getNumStateVariables() {
        return 3;
    }

    void addMyComponents(int n) {
        super.addMyComponents(n, "patch");
        this.cl = new CardLayout();
        this.wholePanel.setLayout(this.cl);
        this.wholePanel.add((Component)this.wholeBox, "alive");
        this.cl.show(this.wholePanel, "alive");
        this.add(this.wholePanel);
        this.addNotify();
        this.pack();
        this.xcor_txt.requestFocus();
    }

    public double getEntityColor() {
        return this.pat.pc;
    }

    public static void updateOpen() {
        boolean bl = numVars > 0;
        numVars = Patch.numVars;
        Enumeration enumeration = pmhash.elements();
        while (enumeration.hasMoreElements()) {
            NPatchMonitor nPatchMonitor;
            NPatchMonitor nPatchMonitor2 = nPatchMonitor = (NPatchMonitor)enumeration.nextElement();
            synchronized (nPatchMonitor2) {
                nPatchMonitor.updateOwn(bl);
            }
        }
    }

    void addListeners() {
        super.addListeners();
        this.xcor_txt.addFocusListener(this.tff);
        this.ycor_txt.addFocusListener(this.tff);
        this.color_txt.addKeyListener(this.tka);
        this.color_txt.addFocusListener(this.tff);
    }

    public static void flushCommandCenters() {
        Enumeration enumeration = pmhash.elements();
        while (enumeration.hasMoreElements()) {
            NPatchMonitor nPatchMonitor = (NPatchMonitor)enumeration.nextElement();
            nPatchMonitor.com.flush();
        }
    }

    public static void setPatch(Patch patch) {
        NPatchMonitor nPatchMonitor = (NPatchMonitor)pmhash.get(patch);
        if (nPatchMonitor != null) {
            nPatchMonitor.pat = patch;
            patch.hasPMp = true;
            patch.pm = nPatchMonitor;
            nPatchMonitor.com.callerClearText();
            nPatchMonitor.setValues(3);
            int n = 0;
            while (n < numVars) {
                nPatchMonitor.setOwn(n);
                ++n;
            }
            nPatchMonitor.startThread();
            nPatchMonitor.show();
        }
    }

    public void closeMonitor() {
        if (this.pat != null) {
            this.pat.hasPMp = false;
            this.pat.pm = null;
            pmhash.remove(this.pat);
            this.pat = null;
            WindowPosition.closed(this);
        }
    }

    public void run() {
        while (this.pat != null && !this.closep) {
            NPatchMonitor nPatchMonitor = this;
            synchronized (nPatchMonitor) {
                if (this.pat != null && this.colorval != this.pat.pc && (this.color_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(3);
                }
                try {
                    int n = 0;
                    while (n < numVars) {
                        if (!(this.pat == null || this.pat.turtlesown.length <= n || this.ownval.length <= n || this.pat.turtlesown[n].equals(this.ownval[n]) || this.own_txt[n] == this.focus && this.app.activeFrame == this)) {
                            this.setOwn(n);
                        }
                        ++n;
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep((long)(this.delay * 1000.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    String getCommand(String string, String string2) {
        if (string.equals(this.color_txt.getName())) {
            this.lastField = 3;
            return "setpc " + string2;
        }
        int n = 0;
        while (n < numVars) {
            if (string.equals(this.own_txt[n].getName())) {
                this.lastField = n;
                this.lastOwn = true;
                return "set" + this.own_lbl[n].getText() + " " + string2;
            }
            ++n;
        }
        return "internal npatchmonitor error";
    }

    public String getCompileCommand(String string) {
        return "compile-patch-monitor [" + string + "]";
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.castToIntArray(objectArray);
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n = this.sl.internalSetInstructions("patch-monitor: " + this.xcorval + ", " + this.ycorval, nArray, objectArray2);
                StackProcessParent.runPatch(this.sl, n, this.pat, false, this);
            }
        }
    }

    public void displayOneString(String string) {
        super.displayOneString(string);
        if (!this.color_txt.getText().equals(this.colname(this.colorval))) {
            this.setValues(3);
            this.color_txt.selectAll();
        }
        int n = 0;
        while (n < numVars) {
            this.setOwn(n);
            ++n;
        }
    }

    public void displayAString(String string) {
        this.displayOneString(string);
    }

    public NPatchMonitor(Patch patch, double d, Application application) {
        super("Patch " + patch.toString(), d, application);
        this.pat = patch;
        this.com = new NSLCommand(1, this.sl, patch, application);
        numVars = Patch.numVars;
        pmhash.put(patch, this);
    }
}

