/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import starlogo.Application;
import starlogo.MonitorDialog;
import starlogo.MonitorWidget;
import starlogo.NSLDialog;
import starlogo.NWidgetDialog;
import starlogo.ToolTipWidget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class NMonitorDialog
extends NWidgetDialog
implements MonitorDialog,
FocusListener {
    private static NMonitorDialog dialog;
    private Choice digChoice;
    private Choice delChoice;
    private Label instLab;
    private Label digLab;
    private Label delLab;
    private Panel butPanel;
    private TextField instText;
    private String name;
    private CheckboxGroup nameGroup;
    private Checkbox instCheck;
    private Checkbox nameCheck;
    private TextField nameText;
    private Panel namePanel;
    private Panel namefieldPanel;
    private Panel instructionfieldPanel;
    private Label nameLab;
    private Label descriptLab;
    private TextArea descriptText;
    private String descript;
    public boolean shortcuts = true;

    public static NMonitorDialog create(Frame frame, String string, WidgetDrag widgetDrag) {
        MonitorWidget monitorWidget = (MonitorWidget)widgetDrag;
        if (dialog == null) {
            dialog = new NMonitorDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields(monitorWidget.name, monitorWidget.inst, monitorWidget.digits, monitorWidget.delay, monitorWidget.showName, monitorWidget.getToolText());
        return dialog;
    }

    public static NMonitorDialog create(Frame frame, String string) {
        String string2 = "monitor" + MonitorWidget.idCount;
        if (YoYo.language == 1) {
            string2 = "monitor" + MonitorWidget.idCount;
        }
        if (dialog == null) {
            dialog = new NMonitorDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields(string2, "", 0, 0.5, false, "");
        return dialog;
    }

    private final void setFields(String string, String string2, int n, double d, boolean bl, String string3) {
        this.name = string;
        this.instText.setText(string2);
        this.instText.setCaretPosition(0);
        this.nameText.setText(string);
        this.nameText.setCaretPosition(0);
        this.digChoice.select(n);
        this.delChoice.select((int)(10.0 * d) - 1);
        this.descriptText.setText(string3);
        this.descriptText.setCaretPosition(0);
        if (bl) {
            this.nameCheck.setState(true);
        } else {
            this.instCheck.setState(true);
        }
    }

    public void setupComponents() {
        this.nameLab = new Label("Name:");
        this.nameText = new TextField(15);
        this.instLab = new Label("StarLogo Instruction:");
        this.instText = new TextField(30);
        this.nameGroup = new CheckboxGroup();
        this.namePanel = new Panel(new GridLayout(2, 1, 5, 0));
        this.instCheck = new Checkbox("Show Instruction", true, this.nameGroup);
        this.nameCheck = new Checkbox("Show Name", false, this.nameGroup);
        this.namePanel.add(this.nameCheck);
        this.namePanel.add(this.instCheck);
        this.digLab = new Label("Decimal Places:");
        this.digChoice = new Choice();
        this.digChoice.add("0");
        this.digChoice.add("1");
        this.digChoice.add("2");
        this.digChoice.add("3");
        this.delLab = new Label("Update Delay (sec):");
        this.delChoice = new Choice();
        this.delChoice.add("0.1");
        this.delChoice.add("0.2");
        this.delChoice.add("0.3");
        this.delChoice.add("0.4");
        this.delChoice.add("0.5");
        this.delChoice.add("0.6");
        this.delChoice.add("0.7");
        this.delChoice.add("0.8");
        this.delChoice.add("0.9");
        this.delChoice.add("1.0");
        this.butPanel = new Panel();
        this.butPanel.setLayout(new GridLayout(2, 1, 0, 5));
        this.butPanel.add(this.bca);
        this.butPanel.add(this.bok);
        this.descriptLab = new Label("Tooltip:");
        this.descriptText = new TextArea("", 3, 40);
        NSLDialog.formatText(this.instText);
        NSLDialog.formatText(this.nameText);
        NSLDialog.formatText(this.descriptText);
        NSLDialog.formatLabel(this.nameLab);
        NSLDialog.formatLabel(this.instLab);
        NSLDialog.formatLabel(this.namePanel);
        NSLDialog.formatLabel(this.digLab);
        NSLDialog.formatLabel(this.delLab);
        NSLDialog.formatLabel(this.descriptLab);
        NSLDialog.formatLabel(this.butPanel);
        NSLDialog.formatLabel(this.bok);
        NSLDialog.formatLabel(this.bca);
        if (YoYo.language == 1) {
            this.nameLab = new Label("Nombre:");
            this.nameText = new TextField(15);
            this.instLab = new Label("Instrucci\u00f3n de StarLogo:");
            this.instText = new TextField(30);
            this.nameGroup = new CheckboxGroup();
            this.namePanel = new Panel(new GridLayout(2, 1, 5, 0));
            this.instCheck = new Checkbox("Muestre Instrucci\u00f3n", true, this.nameGroup);
            this.nameCheck = new Checkbox("Muestre Nombre", false, this.nameGroup);
            this.namePanel.add(this.nameCheck);
            this.namePanel.add(this.instCheck);
            this.namePanel.add(this.instCheck);
            this.digLab = new Label("Cifras Decimales:");
            this.digChoice = new Choice();
            this.digChoice.add("0");
            this.digChoice.add("1");
            this.digChoice.add("2");
            this.digChoice.add("3");
            this.delLab = new Label("Demora de Actualizaci\u00f3n (seg):");
            this.descriptLab = new Label("Descripci\u00f3n:");
            this.descriptText = new TextArea("", 3, 40);
        }
    }

    protected void setupGBC() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.add((Component)this.nameLab, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 0);
        this.add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.add((Component)this.instLab, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.add((Component)this.instText, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.add((Component)this.descriptLab, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.add((Component)this.descriptText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(13, 13, 0, 0);
        this.add((Component)this.digLab, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(13, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.digChoice, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 13, 0);
        this.add((Component)this.delLab, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 13, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.delChoice, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(13, 0, 13, 13);
        this.add((Component)this.butPanel, gridBagConstraints);
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 13, 0, 13);
        this.add((Component)this.namePanel, gridBagConstraints);
    }

    protected void setupPosition() {
        ((Component)this).setSize(350, YoYo.macintoshp ? 190 : (YoYo.linuxp ? 220 : 208));
        this.initLocation();
    }

    protected boolean valid_inputs() {
        String string = this.instText.getText().trim();
        if (string.equals("")) {
            Application.createMessageDialog(this.parent, "Warning", "Sorry, you must specify an instruction to run.", false);
            return false;
        }
        return true;
    }

    public void getValues(WidgetDrag widgetDrag) {
        MonitorWidget monitorWidget = (MonitorWidget)widgetDrag;
        monitorWidget.inst = this.instText.getText().trim();
        monitorWidget.name = this.nameText.getText();
        monitorWidget.showName = this.nameCheck.getState();
        monitorWidget.digits = this.digChoice.getSelectedIndex();
        monitorWidget.font = WidgetLite.WIDGET_FONT;
        monitorWidget.delay = (double)(this.delChoice.getSelectedIndex() + 1) / 10.0;
        monitorWidget.update();
        if (!ToolTipWidget.empty(this.descriptText.getText())) {
            monitorWidget.setToolTip(new ToolTipWidget(monitorWidget.parent, this.descriptText.getText()));
        } else {
            monitorWidget.removeToolTip();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.shortcuts = false;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.shortcuts = true;
    }

    public boolean shortcutsOn() {
        return this.shortcuts;
    }

    private NMonitorDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
        this.initFocus(this.instText);
        this.descriptText.addFocusListener(this);
        this.pack();
    }
}

