/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.Box;
import starlogo.Colors;
import starlogo.EntityMonitor;
import starlogo.MenuListener;
import starlogo.NSLCommand;
import starlogo.NSLDialog;
import starlogo.SLMenu;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import starlogo.StarLogoError;
import starlogo.StarLogoFrame;
import starlogo.VM;
import starlogo.WidgetLite;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public abstract class NEntityMonitor
extends Frame
implements EntityMonitor,
MenuListener,
ClipboardOwner {
    private static final int MAX_OWN_VAR_HEIGHT = 200;
    public static Font EM_FONT;
    public static Font LABEL_FONT;
    static final String[] COLOR_STRING;
    NSLCommand com;
    SLMenu slmenu;
    public boolean closep = false;
    double delay = 0.5;
    protected boolean runningp = false;
    public Frame turtlemon;
    StarLogo sl;
    Application app;
    Clipboard clip;
    Thread thisthr;
    int ccHeight = 54;
    int textHeight;
    TextComponent focus;
    boolean lastOwn = false;
    int lastField = -1;
    boolean fieldChanged = false;
    Label[] own_lbl;
    TextField[] own_txt;
    Object[] ownval;
    Panel middleBox;
    Panel bottomPanel;
    Panel wholePanel;
    Box wholeBox;
    ScrollPane middlePane;
    Panel topBox;
    TextKeyAdapter tka;
    tfFocus tff;
    private Vector spps = new Vector();
    private int sppcount = 0;

    void setFields() {
        FontMetrics fontMetrics = this.app.iface.getToolkit().getFontMetrics(EM_FONT);
        this.textHeight = fontMetrics.getHeight() + fontMetrics.getAscent();
        Dimension dimension = new Dimension(67, this.textHeight);
        this.setStateFields(dimension);
        this.setVariableFields(dimension);
    }

    abstract void setStateFields(Dimension var1);

    void setVariableFields(Dimension dimension) {
        if (this.getNumVars() != 0) {
            this.own_txt = new TextField[this.getNumVars()];
            this.own_lbl = new Label[this.getNumVars()];
            this.ownval = new Object[this.getNumVars()];
            int n = 0;
            while (n < this.getNumVars()) {
                this.own_lbl[n] = new Label(this.getVarName(n));
                this.own_lbl[n].setSize(dimension);
                this.own_txt[n] = new TextField(" ");
                this.formatText(this.own_txt[n]);
                NSLDialog.colorControl(this.own_lbl[n]);
                this.own_lbl[n].setFont(LABEL_FONT);
                ++n;
            }
        }
    }

    public void formatText(TextComponent textComponent) {
        NSLDialog.colorText(textComponent);
        textComponent.setFont(EM_FONT);
        if (YoYo.applet != null) {
            textComponent.setEditable(false);
        }
    }

    abstract int getVarPos(int var1);

    abstract boolean getVarEnump(int var1);

    abstract Object getVarValue(int var1);

    synchronized void setOwnCommon(int n) {
        int n2 = this.getVarPos(n);
        this.ownval[n] = this.getVarValue(n2);
        if (this.ownval[n] instanceof String) {
            this.own_txt[n].setText("\"" + YoYo.printToString(this.ownval[n]) + "\"");
        } else if (this.getVarEnump(n)) {
            if (this.ownval[n] instanceof Number) {
                int n3 = ((Number)this.ownval[n]).intValue();
                if (n3 >= 1 && n3 <= VM.enumnames.length) {
                    this.own_txt[n].setText(VM.enumnames[n3 - 1]);
                } else {
                    this.own_txt[n].setText(this.clipDigits(YoYo.printToString(this.ownval[n])));
                }
            } else {
                this.own_txt[n].setText(this.clipDigits(YoYo.printToString(this.ownval[n])));
            }
        } else {
            this.own_txt[n].setText(this.clipDigits(YoYo.printToString(this.ownval[n])));
        }
    }

    synchronized void setOwnInit(int n) {
        this.setOwnCommon(n);
        this.own_txt[n].setCaretPosition(this.own_txt[n].getText().length());
    }

    synchronized void setOwn(int n) {
        this.setOwnCommon(n);
        this.own_txt[n].selectAll();
    }

    void startThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    String clipDigits(String string) {
        int n;
        int n2 = 3;
        int n3 = string.indexOf(46);
        int n4 = string.indexOf(69);
        if (n4 != -1 && string.charAt(n4 + 1) != '-') {
            return string.substring(0, n3 + n2 + 1) + string.substring(n4, string.length());
        }
        if (n4 != -1 && string.charAt(n4 + 1) == '-') {
            String string2 = "";
            int n5 = Integer.parseInt(string.substring(n4 + 2, string.length()));
            n = 0;
            while (n < n5 - 1) {
                string2 = string2 + "0";
                ++n;
            }
            string = "0." + string2 + string.substring(0, n3);
            n3 = string.indexOf(46);
        }
        if (n3 == -1) {
            return string;
        }
        if (string.substring(n3 + 1, string.length()).length() <= n2) {
            string = string + "000";
            return string.substring(0, n3 + n2 + 1);
        }
        string = string + "000";
        double d = Double.valueOf(string);
        n = 1;
        int n6 = 1;
        while (n6 <= n2) {
            n = 10 * n;
            ++n6;
        }
        n6 = (int)Math.round(d *= (double)n);
        String string3 = "";
        String string4 = Integer.toString(n6 % n);
        int n7 = string4.length();
        while (n7 < n2) {
            string3 = string3 + "0";
            ++n7;
        }
        string = n6 / n + "." + string3 + string4;
        return string;
    }

    public abstract void setValues(int var1);

    public String doubString(double d) {
        if (d - (double)((int)d) == 0.0) {
            return Integer.toString((int)d);
        }
        return Double.toString((double)((int)(1000.0 * d)) / 1000.0);
    }

    public String colname(double d) {
        if (d == 0.0) {
            return "black";
        }
        if (d == 9.0) {
            return "white";
        }
        if (d % 10.0 != 5.0) {
            return this.doubString(d);
        }
        double d2 = d - 5.0;
        d2 /= 10.0;
        if ((d2 %= 14.0) < 0.0) {
            d2 += 14.0;
        }
        return COLOR_STRING[(int)d2];
    }

    public abstract void initFrame();

    public abstract int getNumVars();

    public abstract Label[] getStateLabels();

    public abstract Component[] getStateTexts();

    public abstract int getNumStateVariables();

    void addMyComponents(int n, String string) {
        this.addTopBox(this.getNumStateVariables(), this.getStateLabels(), this.getStateTexts());
        this.addMiddleBox();
        this.addBottomBox();
        this.makeWholeBox(this.topBox, string);
    }

    void addTopBox(int n, Label[] labelArray, Component[] componentArray) {
        this.topBox = new Panel(new GridLayout(n, 2));
        int n2 = 0;
        while (n2 < n) {
            this.topBox.add(labelArray[n2]);
            this.topBox.add(componentArray[n2]);
            ++n2;
        }
        NSLDialog.colorControl(this.topBox);
    }

    void addMiddleBox() {
        this.middlePane = null;
        if (this.getNumVars() > 0) {
            this.middleBox = new Panel(new GridLayout(this.getNumVars(), 2));
            int n = 0;
            while (n < this.getNumVars()) {
                this.middleBox.add(this.own_lbl[n]);
                this.middleBox.add(this.own_txt[n]);
                ++n;
            }
            this.middlePane = new MiddleScrollPane();
            this.middlePane.add(this.middleBox);
            NSLDialog.colorControl(this.middleBox);
            NSLDialog.colorControl(this.middlePane);
        }
    }

    void addBottomBox() {
        BottomScrollPane bottomScrollPane = new BottomScrollPane();
        bottomScrollPane.add((Component)this.com, "Center");
        this.bottomPanel = new Panel(new BorderLayout());
        this.bottomPanel.add((Component)this.com.label, "North");
        this.bottomPanel.add(bottomScrollPane);
        NSLDialog.colorControl(this.bottomPanel);
    }

    void makeWholeBox(Panel panel, String string) {
        int n = 1;
        n += this.getNumVars() > 0 ? 1 : 0;
        n += YoYo.applet == null ? 1 : 0;
        this.wholeBox = Box.createVerticalBox();
        this.wholeBox.add(panel);
        if (this.getNumVars() > 0) {
            this.wholeBox.add(this.middlePane);
        }
        if (YoYo.applet == null) {
            this.wholeBox.add(this.bottomPanel);
        }
        if (string == "turtle") {
            this.wholePanel = new Panel(this){
                private final /* synthetic */ NEntityMonitor this$0;

                public final Insets getInsets() {
                    return new Insets(4, 4, 4, 4);
                }

                public final Dimension preferredSize() {
                    return new Dimension(171, 272 + 25 * this.this$0.getNumVars());
                }
                {
                    this.this$0 = nEntityMonitor;
                    this.constructor$0(nEntityMonitor);
                }

                private final void constructor$0(NEntityMonitor nEntityMonitor) {
                }
            };
        } else if (string == "patch") {
            this.wholePanel = new Panel(this){
                private final /* synthetic */ NEntityMonitor this$0;

                public final Insets getInsets() {
                    return new Insets(4, 4, 4, 4);
                }

                public final Dimension preferredSize() {
                    return new Dimension(190, 180 + 25 * this.this$0.getNumVars());
                }
                {
                    this.this$0 = nEntityMonitor;
                    this.constructor$0(nEntityMonitor);
                }

                private final void constructor$0(NEntityMonitor nEntityMonitor) {
                }
            };
        }
        this.wholePanel.setBackground(Colors.colorarray[(int)(this.getEntityColor() * 32.0)]);
        this.pack();
    }

    public abstract double getEntityColor();

    public synchronized void updateOwn(boolean bl) {
        if (this.getNumVars() == 0) {
            if (!bl) {
                return;
            }
            this.wholeBox.remove(this.middlePane);
            this.validate();
            return;
        }
        if (!bl) {
            this.middleBox = new Panel(new GridLayout(this.getNumVars(), 2));
            this.middlePane = new AltMiddleScrollPane();
            this.middlePane.add(this.middleBox);
            NSLDialog.colorControl(this.middleBox);
            NSLDialog.colorControl(this.middlePane);
        } else {
            this.middleBox.removeAll();
            this.middleBox.setLayout(new GridLayout(this.getNumVars(), 2));
        }
        FontMetrics fontMetrics = this.app.iface.getToolkit().getFontMetrics(EM_FONT);
        this.textHeight = fontMetrics.getHeight() + fontMetrics.getAscent();
        Dimension dimension = new Dimension(67, this.textHeight);
        boolean bl2 = false;
        this.own_txt = new TextField[this.getNumVars()];
        this.own_lbl = new Label[this.getNumVars()];
        this.ownval = new Object[this.getNumVars()];
        int n = 0;
        while (n < this.getNumVars()) {
            this.own_lbl[n] = new Label(this.getVarName(n));
            this.own_txt[n] = new TextField(" ");
            this.own_txt[n].setSize(dimension);
            this.own_txt[n].addKeyListener(this.tka);
            this.own_txt[n].addFocusListener(this.tff);
            NSLDialog.colorControl(this.own_lbl[n]);
            this.own_lbl[n].setFont(LABEL_FONT);
            this.formatText(this.own_txt[n]);
            this.middleBox.add(this.own_lbl[n]);
            this.middleBox.add(this.own_txt[n]);
            ++n;
        }
        this.middlePane.setSize(this.turtlemon.getSize().width - 16, this.middlePane.getSize().height);
        if (!bl) {
            if (YoYo.applet == null) {
                this.wholeBox.remove(this.bottomPanel);
            }
            this.wholeBox.add(this.middlePane);
            if (YoYo.applet == null) {
                this.wholeBox.add(this.bottomPanel);
            }
        }
        this.validate();
    }

    abstract String getVarName(int var1);

    void addListeners() {
        this.tka = new TextKeyAdapter();
        this.tff = new tfFocus();
        int n = 0;
        while (n < this.getNumVars()) {
            this.own_txt[n].addKeyListener(this.tka);
            this.own_txt[n].addFocusListener(this.tff);
            ++n;
        }
        this.com.addFocusListener(this.tff);
    }

    public void registerCloser(Frame frame, Application application) {
        frame.addWindowListener(new Closer(application));
    }

    abstract void closeMonitor();

    public abstract void run();

    void handlecr(TextField textField) {
        String string = textField.getName();
        String string2 = textField.getText();
        this.runLine(this.getCommand(string, string2));
    }

    abstract String getCommand(String var1, String var2);

    public void done(Context context) {
        this.fieldChanged = false;
    }

    abstract String getCompileCommand(String var1);

    public void runLine(String string) {
        this.runningp = true;
        if (string != null && string != "") {
            Object[] objectArray = Reader.read(this.getCompileCommand(string));
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this;
            this.sl.app.cc.enqueue(objectArray2, this.sl.app.message, this.sl.app.err, null);
        }
    }

    public int[] castToIntArray(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        return nArray;
    }

    public abstract void runCompiledCommand(Object[] var1, Object[] var2);

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0 && this.runningp) {
            this.runningp = false;
        }
        if (this.lastField != -1) {
            if (this.lastOwn) {
                this.setOwn(this.lastField);
            } else {
                this.setValues(this.lastField);
            }
        }
        this.lastField = -1;
        this.lastOwn = false;
        this.fieldChanged = false;
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void callerPrintln(String string) {
    }

    public void callerClearText() {
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void displayOneString(String string) {
        if (!this.com.runningp) {
            this.com.displayOneString(string);
        } else {
            StarLogoError.error(this.app, string, false);
        }
    }

    public void displayAString(String string) {
        if (!this.com.runningp) {
            this.com.displayOneString(string);
        } else {
            StarLogoError.error(this.app, string, false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        String string = checkboxMenuItem.getLabel();
        try {
            int n = Integer.parseInt(string);
            Font font = this.com.getFont();
            this.com.setFont(new Font(font.getName(), font.getStyle(), n));
            this.slmenu.setCurrentSize(checkboxMenuItem);
            return;
        }
        catch (Exception exception) {
            Font font = this.com.getFont();
            this.com.setFont(new Font(string, font.getStyle(), font.getSize()));
            this.slmenu.setCurrentFont(checkboxMenuItem);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MenuItem) {
            this.actionPerformedOnMenuItem((MenuItem)object);
        }
    }

    public TextComponent getTextFocus() {
        return this.focus;
    }

    public void actionPerformedOnMenuItem(MenuItem menuItem) {
        String string = menuItem.getLabel();
        TextComponent textComponent = this.getTextFocus();
        if (textComponent == null) {
            return;
        }
        if (string.equals("Cut")) {
            String string2 = textComponent.getSelectedText();
            if (string2.equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string2);
            this.app.clip.setContents(stringSelection, this);
            int n = textComponent.getSelectionStart();
            String string3 = textComponent.getText();
            textComponent.setText(string3.substring(0, n) + string3.substring(textComponent.getSelectionEnd()));
            textComponent.select(n, n);
            return;
        }
        if (string.equals("Copy")) {
            String string4 = textComponent.getSelectedText();
            if (string4.equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string4);
            this.app.clip.setContents(stringSelection, this);
            return;
        }
        if (string.equals("Paste")) {
            Transferable transferable = this.app.clip.getContents(this);
            if (transferable != null) {
                try {
                    Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                    if (object instanceof String) {
                        String string5 = (String)object;
                        int n = string5.length();
                        int n2 = textComponent.getCaretPosition();
                        if (n == 0) {
                            String string6 = textComponent.getText();
                            textComponent.setText(string6.substring(0, n2) + string5 + string6.substring(n2));
                            textComponent.select(n2 + n, n2 + n);
                        } else {
                            int n3 = textComponent.getSelectionStart();
                            String string7 = textComponent.getText();
                            textComponent.setText(string7.substring(0, n3) + string5 + string7.substring(textComponent.getSelectionEnd()));
                            textComponent.select(n3 + n, n3 + n);
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return;
        }
        if (string.equals("Select All")) {
            textComponent.selectAll();
            return;
        }
        if (string.equals("Clear")) {
            textComponent.setText("");
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    static /* synthetic */ int access$0() {
        return MAX_OWN_VAR_HEIGHT;
    }

    public NEntityMonitor(String string, double d, Application application) {
        super(string);
        this.turtlemon = this;
        this.delay = d;
        this.app = application;
        this.sl = application.sl;
        this.clip = application.clip;
        this.addWindowListener(application.windowHider);
        this.registerCloser(this, application);
        application.registerFrameTracker(this);
        application.addWindow(this);
    }

    static {
        COLOR_STRING = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "purple", "magenta", "pink"};
        try {
            EM_FONT = WidgetLite.WIDGET_FONT;
            EM_FONT = Font.getFont("starlogo.entity-monitor.font", EM_FONT);
            LABEL_FONT = WidgetLite.WIDGET_FONT;
            LABEL_FONT = Font.getFont("starlogo.entity-label.font", LABEL_FONT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected class MiddleScrollPane
    extends ScrollPane {
        public Dimension getPreferredSize() {
            Dimension dimension = NEntityMonitor.this.middleBox.preferredSize();
            return new Dimension(NEntityMonitor.this.turtlemon.getSize().width, Math.min(4 + dimension.height, 200));
        }

        MiddleScrollPane() throws RuntimeException {
            super(0);
        }
    }

    protected class BottomScrollPane
    extends ScrollPane {
        public Dimension getPreferredSize() {
            return new Dimension(21, 80);
        }

        BottomScrollPane() throws RuntimeException {
            super(0);
        }
    }

    protected class AltMiddleScrollPane
    extends ScrollPane {
        public Dimension getPreferredSize() {
            Dimension dimension = NEntityMonitor.this.middleBox.preferredSize();
            return new Dimension(NEntityMonitor.this.turtlemon.getSize().width + 16, Math.min(4 + dimension.height, 200));
        }

        AltMiddleScrollPane() throws RuntimeException {
        }
    }

    protected class Closer
    extends WindowAdapter {
        Application app;

        public void windowClosing(WindowEvent windowEvent) {
            Closer closer = this;
            synchronized (closer) {
                NEntityMonitor.this.closep = true;
                ((Component)windowEvent.getWindow()).setVisible(false);
                this.app.removeWindow((StarLogoFrame)((Object)windowEvent.getWindow()));
                NEntityMonitor.this.closeMonitor();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public Closer(Application application) {
            this.app = application;
        }
    }

    public class tfFocus
    extends WindowAdapter
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            NEntityMonitor.this.focus = focusEvent.getComponent() instanceof TextComponent ? (TextComponent)focusEvent.getComponent() : null;
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class TextKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            TextField textField = (TextField)keyEvent.getComponent();
            char c = keyEvent.getKeyChar();
            if (c == '\r' || c == '\n') {
                NEntityMonitor.this.handlecr(textField);
                keyEvent.consume();
                return;
            }
            super.keyPressed(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            TextField textField = (TextField)keyEvent.getComponent();
            char c = keyEvent.getKeyChar();
            if (c == '\r' || c == '\n') {
                keyEvent.consume();
                return;
            }
            NEntityMonitor.this.fieldChanged = true;
            super.keyTyped(keyEvent);
        }

        TextKeyAdapter() {
        }
    }
}

