/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import starlogo.Interface;
import starlogo.Widget;
import starlogo.WidgetLite;

public class MouseCoordinateToolbar
extends Widget {
    public static int topwin = 3;
    public static int botwin = 14;
    public static int xcoordbegin = 5;
    public static int ycoordbegin = 50;
    public static int coordwinwidth = 28;
    private Interface iface;
    public Font font;
    String statusMessage;
    Integer xcor;
    Integer ycor;
    Thread t;

    public void paint(Graphics graphics) {
        this.setLocation(0, this.iface.getSize().height - this.iface.statusbarheight());
        graphics.translate(this.position.x, this.position.y);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(SystemColor.control);
        graphics.fillRect(0, 0, this.iface.getSize().width, this.iface.statusbarheight());
        graphics.setColor(Color.white);
        graphics.draw3DRect(xcoordbegin + 12, topwin, coordwinwidth, botwin, false);
        graphics.draw3DRect(ycoordbegin + 12, topwin, coordwinwidth, botwin, false);
        graphics.draw3DRect(95, topwin, 200, botwin, false);
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        graphics.drawString("X:", xcoordbegin, botwin);
        graphics.drawString("Y:", ycoordbegin, botwin);
        if (!this.statusMessage.equals("")) {
            graphics.drawString(this.statusMessage, 100, botwin);
        }
        if (this.xcor != null && this.ycor != null) {
            graphics.drawString(this.xcor.toString(), xcoordbegin + 17, botwin);
            graphics.drawString(this.ycor.toString(), ycoordbegin + 17, botwin);
        }
        graphics.translate(-this.position.x, -this.position.y);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void setStatusMessage(String string) {
        this.setStatusMessage(string, 2000);
    }

    public void setStatusMessage(String string, int n) {
        this.statusMessage = string;
        if (!string.equals("")) {
            this.t = new DisplayThread(this, string, n);
            this.t.start();
        }
    }

    public MouseCoordinateToolbar(Interface interface_) {
        super(interface_);
        this.position = new Rectangle(0, 0, interface_.getSize().width, interface_.statusbarheight());
        this.iface = interface_;
        this.font = WidgetLite.WIDGET_FONT;
        this.xcor = null;
        this.ycor = null;
        this.statusMessage = "";
    }

    private class DisplayThread
    extends Thread {
        String message;
        int lifetime;
        MouseCoordinateToolbar mcoordtool;

        public void run() {
            this.mcoordtool.statusMessage = this.message;
            this.mcoordtool.iface.repaint();
            try {
                Thread.sleep(this.lifetime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mcoordtool.statusMessage = "";
        }

        public DisplayThread(MouseCoordinateToolbar mouseCoordinateToolbar2, String string, int n) {
            super(string);
            this.message = string;
            this.lifetime = n;
            this.mcoordtool = mouseCoordinateToolbar2;
            this.setPriority(1);
        }
    }
}

