/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import starlogo.Application;
import starlogo.Colors;
import starlogo.JEntityMonitor;
import starlogo.JSLCommand;
import starlogo.JSLMenu;
import starlogo.NSLMenu;
import starlogo.StackProcessParent;
import starlogo.Turtle;
import starlogo.TurtleMonitor;
import starlogo.TurtleShapes;
import starlogo.VM;
import starlogo.WindowPosition;
import yoyo.YoYo;

public class JTurtleMonitor
extends JEntityMonitor
implements TurtleMonitor {
    static Hashtable tmhash = new Hashtable();
    public static final int XCOR = 1;
    public static final int YCOR = 2;
    public static final int HEADING = 3;
    public static final int BREED = 4;
    public static final int SHAPE = 5;
    public static final int COLOR = 6;
    public static final int GRABBED = 7;
    public static final int OWN = 8;
    static double delayTime = 0.5;
    static int numVars;
    Turtle tur;
    int who;
    int shape;
    String brname;
    JLabel who_lbl = new JLabel(" Who", 2);
    JLabel who_txt;
    JLabel grabbed_lbl = new JLabel(" Grabbed?", 2);
    JLabel grabbed_txt = new JLabel("false");
    VM grabbedval = null;
    JLabel breed_lbl = new JLabel(" Breed", 2);
    JTextField breed_txt = new JTextField();
    double breedval;
    JLabel shape_lbl = new JLabel(" Shape");
    JTextField shape_txt = new JTextField();
    String shapeval;
    JLabel color_lbl = new JLabel(" Color", 2);
    JTextField color_txt = new JTextField();
    double colorval;
    JLabel xcor_lbl = new JLabel(" Xcor", 2);
    JTextField xcor_txt = new JTextField();
    double xcorval;
    JLabel ycor_lbl = new JLabel(" Ycor", 2);
    JTextField ycor_txt = new JTextField();
    double ycorval;
    JLabel heading_lbl = new JLabel(" Heading", 2);
    JTextField heading_txt = new JTextField();
    double headingval;
    protected boolean tlocked;

    public int getNumVars() {
        return numVars;
    }

    void setStateFields(Dimension dimension) {
        this.who_txt = new JLabel(Integer.toString(this.tur.who), 2);
        this.who_txt.setRequestFocusEnabled(true);
        this.grabbedval = this.tur.grabber;
        this.grabbed_txt = new JLabel(this.grabbedval == null ? (YoYo.language == 0 ? "false" : "falso") : this.grabbedval.niceToString(), 2);
        this.grabbed_lbl.setText(this.grabbedval == null ? (YoYo.language == 0 ? "Grabbed?" : "Agarrado?") : (YoYo.language == 0 ? " Grabbed By" : "Agarrado por"));
        this.breed_txt.setName("Breed");
        this.xcor_txt.setName("Xcor");
        this.ycor_txt.setName("Ycor");
        this.color_txt.setName("Color");
        this.heading_txt.setName("Heading");
        this.shape_txt.setName("Shape");
        this.who_txt.setPreferredSize(dimension);
        this.grabbed_txt.setPreferredSize(dimension);
        this.breed_txt.setPreferredSize(dimension);
        this.shape_txt.setPreferredSize(dimension);
        this.color_txt.setPreferredSize(dimension);
        this.xcor_txt.setPreferredSize(dimension);
        this.ycor_txt.setPreferredSize(dimension);
        this.heading_txt.setPreferredSize(dimension);
        this.who_lbl.setPreferredSize(dimension);
        this.grabbed_lbl.setPreferredSize(dimension);
        this.breed_lbl.setPreferredSize(dimension);
        this.shape_lbl.setPreferredSize(dimension);
        this.color_lbl.setPreferredSize(dimension);
        this.xcor_lbl.setPreferredSize(dimension);
        this.ycor_lbl.setPreferredSize(dimension);
        this.heading_lbl.setPreferredSize(dimension);
        this.formatText(this.xcor_txt);
        this.formatText(this.ycor_txt);
        this.formatText(this.heading_txt);
        this.formatText(this.breed_txt);
        this.formatText(this.color_txt);
        this.formatText(this.shape_txt);
        this.who_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.grabbed_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.xcor_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.ycor_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.color_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.heading_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.breed_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.shape_lbl.setFont(JEntityMonitor.LABEL_FONT);
    }

    public String getVarName(int n) {
        return Turtle.getVarName(n);
    }

    public int getVarPos(int n) {
        return Turtle.getVarPos(n);
    }

    public Object getVarValue(int n) {
        return this.tur.turtlesown[n];
    }

    public boolean getVarEnump(int n) {
        return Turtle.getVarEnump(n);
    }

    public synchronized void setValues(int n) {
        switch (n) {
            case 1: {
                this.xcorval = this.tur.xcor;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        this.this$0.xcor_txt.setText(this.this$0.doubString(this.this$0.xcorval - this.this$0.sl.turhalfwidth));
                        this.this$0.xcor_txt.setCaretPosition(this.this$0.xcor_txt.getText().length());
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
            case 2: {
                this.ycorval = this.tur.ycor;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        this.this$0.ycor_txt.setText(this.this$0.doubString(this.this$0.sl.turhalfheight - this.this$0.ycorval));
                        this.this$0.ycor_txt.setCaretPosition(this.this$0.ycor_txt.getText().length());
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
            case 3: {
                this.headingval = this.tur.heading;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        this.this$0.heading_txt.setText(this.this$0.doubString(this.this$0.headingval));
                        this.this$0.heading_txt.setCaretPosition(this.this$0.heading_txt.getText().length());
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
            case 4: {
                this.breedval = this.tur.breed;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        this.this$0.breed_txt.setText(this.this$0.breedString(this.this$0.breedval));
                        this.this$0.breed_txt.setCaretPosition(this.this$0.breed_txt.getText().length());
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
            case 5: {
                this.shapeval = TurtleShapes.getShape((int)this.tur.shape).name;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        this.this$0.shape_txt.setText(this.this$0.shapeval);
                        this.this$0.shape_txt.setCaretPosition(this.this$0.shape_txt.getText().length());
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
            case 6: {
                this.colorval = this.getEntityColor();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        this.this$0.color_txt.setText(this.this$0.colname(this.this$0.colorval));
                        this.this$0.color_txt.setCaretPosition(this.this$0.color_txt.getText().length());
                        this.this$0.wholePanel.setBorder(new LineBorder(Colors.colorarray[(int)(this.this$0.getEntityColor() * 32.0)], 4));
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
            case 7: {
                this.grabbedval = this.tur.grabber;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JTurtleMonitor this$0;

                    public final void run() {
                        if (YoYo.language == 0) {
                            this.this$0.grabbed_txt.setText(this.this$0.grabbedval == null ? "false" : this.this$0.grabbedval.niceToString());
                            this.this$0.grabbed_lbl.setText(this.this$0.grabbedval == null ? "Grabbed?" : " Grabbed By");
                        } else if (YoYo.language == 1) {
                            this.this$0.grabbed_txt.setText(this.this$0.grabbedval == null ? "falso" : this.this$0.grabbedval.niceToString());
                            this.this$0.grabbed_lbl.setText(this.this$0.grabbedval == null ? "Agarrado?" : " Grabbed By");
                        }
                    }
                    {
                        this.this$0 = jTurtleMonitor;
                        this.constructor$0(jTurtleMonitor);
                    }

                    private final void constructor$0(JTurtleMonitor jTurtleMonitor) {
                    }
                });
                break;
            }
        }
    }

    String breedString(double d) {
        if (d - (double)((int)d) != 0.0) {
            return this.doubString(d);
        }
        int n = 0;
        while (n < Turtle.breednames.length) {
            if ((int)d == Turtle.breednums[n]) {
                return Turtle.breednames[n];
            }
            ++n;
        }
        return this.doubString(d);
    }

    public void initFrame() {
        if (this.tur == null || !this.tur.alive) {
            return;
        }
        if (YoYo.macintoshp) {
            this.slmenu = !YoYo.macosxp ? new NSLMenu(this, this.app) : new JSLMenu(this, this.app);
            this.slmenu.setMenuBar(this);
        }
        numVars = Turtle.numVars;
        this.setFields();
        int n = this.own_txt == null ? 0 : this.own_txt[0].getPreferredSize().height;
        n = 22;
        this.addMyComponents(n);
        this.com.callerClearText();
        if (YoYo.applet == null) {
            this.addListeners();
        }
        int n2 = 1;
        while (n2 <= 7) {
            this.setValues(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < numVars) {
            this.setOwnInit(n2);
            ++n2;
        }
    }

    public JLabel[] getStateLabels() {
        JLabel[] jLabelArray = new JLabel[]{this.who_lbl, this.color_lbl, this.shape_lbl, this.xcor_lbl, this.ycor_lbl, this.heading_lbl, this.breed_lbl, this.grabbed_lbl};
        return jLabelArray;
    }

    public JComponent[] getStateTexts() {
        JComponent[] jComponentArray = new JComponent[]{this.who_txt, this.color_txt, this.shape_txt, this.xcor_txt, this.ycor_txt, this.heading_txt, this.breed_txt, this.grabbed_txt};
        return jComponentArray;
    }

    public int getNumStateVariables() {
        return 8;
    }

    void addMyComponents(int n) {
        super.addMyComponents(n);
        JLabel jLabel = new JLabel("This turtle is dead");
        jLabel.setBackground(Color.black);
        jLabel.setForeground(Color.white);
        jLabel.setFont(JEntityMonitor.LABEL_FONT);
        jLabel.setOpaque(true);
        this.cl = new CardLayout();
        this.wholePanel.setLayout(this.cl);
        this.wholePanel.add((Component)jLabel, "dead");
        this.wholePanel.add((Component)this.wholeBox, "alive");
        this.cl.show(this.wholePanel, "alive");
        this.getContentPane().add(this.wholePanel);
        this.addNotify();
        this.pack();
        this.who_txt.requestFocus();
    }

    public double getEntityColor() {
        return this.tur.color;
    }

    public static void updateOpen() {
        boolean bl = numVars > 0;
        numVars = Turtle.numVars;
        Enumeration enumeration = tmhash.elements();
        while (enumeration.hasMoreElements()) {
            JTurtleMonitor jTurtleMonitor;
            JTurtleMonitor jTurtleMonitor2 = jTurtleMonitor = (JTurtleMonitor)enumeration.nextElement();
            synchronized (jTurtleMonitor2) {
                jTurtleMonitor.updateOwn(bl);
            }
        }
    }

    void addListeners() {
        super.addListeners();
        this.who_txt.addFocusListener(this.tff);
        this.grabbed_txt.addFocusListener(this.tff);
        this.xcor_txt.addKeyListener(this.tka);
        this.xcor_txt.addFocusListener(this.tff);
        this.ycor_txt.addKeyListener(this.tka);
        this.ycor_txt.addFocusListener(this.tff);
        this.heading_txt.addKeyListener(this.tka);
        this.heading_txt.addFocusListener(this.tff);
        this.breed_txt.addKeyListener(this.tka);
        this.breed_txt.addFocusListener(this.tff);
        this.shape_txt.addKeyListener(this.tka);
        this.shape_txt.addFocusListener(this.tff);
        this.color_txt.addKeyListener(this.tka);
        this.color_txt.addFocusListener(this.tff);
    }

    public void die() {
        this.wholePanel.setBorder(new LineBorder(Color.black, 4));
        this.cl.show(this.wholePanel, "dead");
    }

    public static void flushCommandCenters() {
        Enumeration enumeration = tmhash.elements();
        while (enumeration.hasMoreElements()) {
            JTurtleMonitor jTurtleMonitor = (JTurtleMonitor)enumeration.nextElement();
            jTurtleMonitor.com.flush();
        }
    }

    public static void setTurtle(Turtle turtle) {
        JTurtleMonitor jTurtleMonitor = (JTurtleMonitor)tmhash.get(turtle);
        if (jTurtleMonitor != null) {
            jTurtleMonitor.tur = turtle;
            turtle.hasTMp = true;
            turtle.tm = jTurtleMonitor;
            jTurtleMonitor.cl.show(jTurtleMonitor.wholePanel, "alive");
            jTurtleMonitor.com.callerClearText();
            int n = 1;
            while (n <= 7) {
                jTurtleMonitor.setValues(n);
                ++n;
            }
            n = 0;
            while (n < numVars) {
                jTurtleMonitor.setOwnInit(n);
                ++n;
            }
            jTurtleMonitor.show();
        }
    }

    public void closeMonitor() {
        if (this.tur != null) {
            this.tur.hasTMp = false;
            this.tur.tm = null;
            tmhash.remove(this.tur);
            this.tur = null;
            WindowPosition.closed(this);
        }
    }

    String getCommand(String string, String string2) {
        if (string.equals(this.xcor_txt.getName())) {
            this.lastField = 1;
            return "setx " + string2;
        }
        if (string.equals(this.ycor_txt.getName())) {
            this.lastField = 2;
            return "sety " + string2;
        }
        if (string.equals(this.heading_txt.getName())) {
            this.lastField = 3;
            return "setheading " + string2;
        }
        if (string.equals(this.shape_txt.getName())) {
            this.lastField = 5;
            return "setshape " + string2;
        }
        if (string.equals(this.color_txt.getName())) {
            this.lastField = 6;
            return "setcolor " + string2;
        }
        if (string.equals(this.breed_txt.getName())) {
            this.lastField = 4;
            return "setbreed " + string2;
        }
        int n = 0;
        while (n < this.getNumVars()) {
            if (string.equals(this.own_txt[n].getName())) {
                this.lastField = n;
                this.lastOwn = true;
                return "set" + this.own_lbl[n].getText() + " " + string2;
            }
            ++n;
        }
        return "internal jturtlemonitor error";
    }

    public String getCompileCommand(String string) {
        return "compile-turtle-monitor [" + string + "]";
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.castToIntArray(objectArray);
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n = this.sl.internalSetInstructions("turtle-monitor: " + this.who_txt.getText(), nArray, objectArray2);
                StackProcessParent.runTurtle(this.sl, n, this.tur, false, this);
            }
        }
    }

    public void displayOneString(String string) {
        super.displayOneString(string);
        if (!this.breed_txt.getText().equals(this.breedString(this.breedval))) {
            this.setValues(4);
            this.breed_txt.selectAll();
        }
        if (!this.color_txt.getText().equals(this.colname(this.colorval))) {
            this.setValues(6);
            this.color_txt.selectAll();
        }
        if (!this.shape_txt.getText().equals(this.shapeval)) {
            this.setValues(5);
            this.shape_txt.selectAll();
        }
        if (!this.xcor_txt.getText().equals(this.doubString(this.xcorval - this.sl.turhalfwidth))) {
            this.setValues(1);
            this.xcor_txt.selectAll();
        }
        if (!this.ycor_txt.getText().equals(this.doubString(this.sl.turhalfheight - this.ycorval))) {
            this.setValues(2);
            this.ycor_txt.selectAll();
        }
        if (!this.heading_txt.getText().equals(this.doubString(this.headingval))) {
            this.setValues(3);
            this.heading_txt.selectAll();
        }
        int n = 0;
        while (n < numVars) {
            this.setOwn(n);
            ++n;
        }
    }

    public void displayAString(String string) {
        super.displayAString(string);
        if (!this.breed_txt.getText().equals(this.breedString(this.breedval))) {
            this.setValues(4);
        }
        if (!this.color_txt.getText().equals(this.colname(this.colorval))) {
            this.setValues(6);
        }
        if (!this.shape_txt.getText().equals(this.shapeval)) {
            this.setValues(5);
        }
        if (!this.xcor_txt.getText().equals(this.doubString(this.xcorval - this.sl.turhalfwidth))) {
            this.setValues(1);
        }
        if (!this.ycor_txt.getText().equals(this.doubString(this.sl.turhalfheight - this.ycorval))) {
            this.setValues(2);
        }
        if (!this.heading_txt.getText().equals(this.doubString(this.headingval))) {
            this.setValues(3);
        }
        int n = 0;
        while (n < numVars) {
            this.setOwn(n);
            ++n;
        }
    }

    public void run() {
    }

    public JTurtleMonitor(Turtle turtle, double d, Application application) {
        super("Turtle # " + turtle.who, d, application);
        if (YoYo.language == 1) {
            this.breed_lbl.setText("Especie");
            this.heading_lbl.setText("Rumbo");
            this.shape_lbl.setText(" Forma");
            this.xcor_lbl.setText("CoorX");
            this.ycor_lbl.setText("CoorY");
        }
        this.tur = turtle;
        this.com = new JSLCommand(0, this.sl, turtle.who, application);
        this.who = turtle.who;
        this.shape = turtle.shape;
        numVars = Turtle.numVars;
        tmhash.put(turtle, this);
        this.grabbed_lbl.setText(" Agarrado?");
        if (YoYo.language == 1) {
            this.setTitle("Tortuga # " + turtle.who);
            this.who_lbl.setText("Quien");
        }
    }

    static {
        new Thread(new Runnable(){

            public final void run() {
                while (true) {
                    if (tmhash != null) {
                        Hashtable hashtable = tmhash;
                        synchronized (hashtable) {
                            Enumeration<V> enumeration = tmhash.elements();
                            while (enumeration.hasMoreElements()) {
                                JTurtleMonitor jTurtleMonitor;
                                JTurtleMonitor jTurtleMonitor2 = jTurtleMonitor = (JTurtleMonitor)enumeration.nextElement();
                                synchronized (jTurtleMonitor2) {
                                    Turtle turtle = jTurtleMonitor.tur;
                                    if (turtle != null && turtle.alive && !jTurtleMonitor.closep) {
                                        if (jTurtleMonitor.breedval != turtle.breed && (jTurtleMonitor.breed_txt != jTurtleMonitor.focus || jTurtleMonitor.app.activeFrame != jTurtleMonitor)) {
                                            jTurtleMonitor.setValues(4);
                                        }
                                        if (jTurtleMonitor.colorval != turtle.color && (jTurtleMonitor.color_txt != jTurtleMonitor.focus || jTurtleMonitor.app.activeFrame != jTurtleMonitor)) {
                                            jTurtleMonitor.setValues(6);
                                        }
                                        if (jTurtleMonitor.shapeval != TurtleShapes.getShape((int)turtle.shape).name && (jTurtleMonitor.shape_txt != jTurtleMonitor.focus || jTurtleMonitor.app.activeFrame != jTurtleMonitor)) {
                                            jTurtleMonitor.setValues(5);
                                        }
                                        if (jTurtleMonitor.xcorval != turtle.xcor && (jTurtleMonitor.xcor_txt != jTurtleMonitor.focus || jTurtleMonitor.app.activeFrame != jTurtleMonitor)) {
                                            jTurtleMonitor.setValues(1);
                                        }
                                        if (jTurtleMonitor.ycorval != turtle.ycor && (jTurtleMonitor.ycor_txt != jTurtleMonitor.focus || jTurtleMonitor.app.activeFrame != jTurtleMonitor)) {
                                            jTurtleMonitor.setValues(2);
                                        }
                                        if (jTurtleMonitor.headingval != turtle.heading && (jTurtleMonitor.heading_txt != jTurtleMonitor.focus || jTurtleMonitor.app.activeFrame != jTurtleMonitor)) {
                                            jTurtleMonitor.setValues(3);
                                        }
                                        if (jTurtleMonitor.grabbedval != turtle.grabber) {
                                            jTurtleMonitor.setValues(7);
                                        }
                                        try {
                                            int n = 0;
                                            while (n < numVars) {
                                                if (!(turtle.turtlesown[n].equals(jTurtleMonitor.ownval[n]) || jTurtleMonitor.own_txt[n] == jTurtleMonitor.focus && jTurtleMonitor.app.activeFrame == jTurtleMonitor)) {
                                                    jTurtleMonitor.setOwn(n);
                                                }
                                                ++n;
                                            }
                                        }
                                        catch (NullPointerException nullPointerException) {
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        }
                    }
                    try {
                        Thread.sleep((long)(delayTime * 1000.0));
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        }).start();
    }
}

