/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.JPanel;
import starlogo.Colors;
import starlogo.JShapeEditor;
import starlogo.JShapePaintSelect;
import starlogo.JShapePaintTool;
import starlogo.Widget;

public class JShapeEditorPanel
extends JPanel
implements ImageProducer,
MouseListener,
MouseMotionListener {
    static int GRAY = 0;
    static int WHITE = 0;
    static final int[] patchTrans8x8 = new int[64];
    static final int[] patchTrans16x16 = new int[289];
    static final int[] patchTrans32x32 = new int[1225];
    static Image patchTrans16x16AsImage = null;
    static Image e8x8Image;
    static Image e17x17Image;
    static Image e35x35Image;
    static int[] turtleTrans8x8;
    static int[] turtleTrans16x16;
    static int[] turtleTrans32x32;
    public JShapePaintTool painttool;
    public JShapePaintSelect paintselect;
    double[] shapecolors;
    int[] shapemasks;
    double[] shapecolors_backup;
    int[] shapemasks_backup;
    JShapeEditor parent;
    int[] panelpixels;
    int[] panelpixels_backup;
    int gridlength;
    int width;
    int height;
    int size = 0;
    Image image;
    ImageConsumer ic;
    boolean startOfPoly = true;
    boolean drawingPoly = false;
    int polyHeadx;
    int polyHeady;
    private int mousedownx;
    private int mousedowny;
    private int mousedragx;
    private int mousedragy;
    private static /* synthetic */ Class class$Lstarlogo$JShapeEditorPanel;

    public void init(boolean bl) {
        this.shapecolors = this.parent.editedShape.getColorsForSize(this.size)[0];
        this.shapemasks = this.parent.editedShape.getMasksForSize(this.size)[0];
        if (bl) {
            this.shapecolors_backup = new double[this.shapecolors.length];
            System.arraycopy(this.shapecolors, 0, this.shapecolors_backup, 0, this.shapecolors.length);
            this.shapemasks_backup = new int[this.shapemasks.length];
            System.arraycopy(this.shapemasks, 0, this.shapemasks_backup, 0, this.shapemasks.length);
        }
        this.size = this.size;
        switch (this.size) {
            case 8: {
                this.gridlength = 36;
                break;
            }
            case 16: {
                this.gridlength = 18;
                break;
            }
            case 32: {
                this.gridlength = 9;
                break;
            }
        }
        this.width = 289;
        this.height = 289;
        this.panelpixels = new int[this.width * this.height];
        if (bl) {
            this.panelpixels_backup = new int[this.width * this.height];
        }
        this.setSize(this.width, this.height);
    }

    public void updateDisplay() {
        this.parent.sizechooser.updateAll();
        this.parent.shapeRotationPreview.updateDisplay();
        this.startProduction(this.ic);
        this.parent.repaint();
    }

    public void lightweightUpdateDisplay() {
        this.refresh();
        this.startProduction(this.ic);
    }

    public void changeSize(int n) {
        this.parent.sizechooser.updateAll();
        boolean bl = false;
        if (this.size != n) {
            bl = true;
        }
        this.size = n;
        this.init(bl);
        if (bl) {
            boolean bl2 = true;
            boolean bl3 = false;
        }
        this.removeConsumer(null);
        this.image = this.parent.createImage(this);
        this.drawGrid();
        this.refresh();
        this.parent.repaint();
    }

    public void refresh() {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                this.refreshSquare(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public void drawGrid() {
        int n;
        int n2 = 0;
        while (n2 < this.width) {
            n = 0;
            while (n < this.height) {
                this.panelpixels[n * this.width + n2] = GRAY;
                ++n;
            }
            n2 += this.gridlength;
        }
        n2 = 0;
        while (n2 < this.height) {
            n = 0;
            while (n < this.width) {
                this.panelpixels[n2 * this.width + n] = GRAY;
                ++n;
            }
            n2 += this.gridlength;
        }
    }

    private final boolean isColoredSame(Point point, Point point2) {
        int n = point.y * this.size + point.x;
        int n2 = point2.y * this.size + point2.x;
        return this.shapecolors[n] == this.shapecolors[n2] && this.shapemasks[2 * n] == this.shapemasks[2 * n2] && this.shapemasks[2 * n + 1] == this.shapemasks[2 * n2 + 1];
    }

    public void colorSquare(int n, int n2, int n3) {
        int n4 = n * this.gridlength + 1;
        int n5 = n2 * this.gridlength + 1;
        int n6 = n5 * this.width + n4;
        int n7 = 0;
        while (n7 < this.gridlength - 1) {
            int n8 = 0;
            while (n8 < this.gridlength - 1) {
                this.panelpixels[n6 + n8 * this.width + n7] = n3;
                ++n8;
            }
            ++n7;
        }
    }

    public void colorSquareTurtleTransparent(int n, int n2) {
        int n3 = n * this.gridlength + 1;
        int n4 = n2 * this.gridlength + 1;
        int n5 = n4 * this.width + n3;
        int[] nArray = null;
        switch (this.size) {
            case 8: {
                nArray = turtleTrans32x32;
                break;
            }
            case 16: {
                nArray = turtleTrans16x16;
                break;
            }
            case 32: {
                nArray = turtleTrans8x8;
                break;
            }
        }
        int n6 = 0;
        int n7 = 0;
        while (n6 < this.gridlength - 1) {
            int n8 = 0;
            while (n8 < this.gridlength - 1) {
                this.panelpixels[n5 + n6 * this.width + n8] = nArray[n7++];
                ++n8;
            }
            ++n6;
        }
    }

    public void colorSquarePatchTransparent(int n, int n2) {
        int n3 = n * this.gridlength + 1;
        int n4 = n2 * this.gridlength + 1;
        int n5 = n4 * this.width + n3;
        int n6 = 0;
        int[] nArray = null;
        switch (this.size) {
            case 8: {
                nArray = patchTrans32x32;
                break;
            }
            case 16: {
                nArray = patchTrans16x16;
                break;
            }
            case 32: {
                nArray = patchTrans8x8;
                break;
            }
        }
        int n7 = 0;
        while (n7 < this.gridlength - 1) {
            int n8 = 0;
            while (n8 < this.gridlength - 1) {
                this.panelpixels[n5 + n8 * this.width + n7] = nArray[n6++];
                ++n8;
            }
            ++n7;
        }
    }

    private final void refreshSquare(int n, int n2) {
        int n3 = n2 * this.size + n;
        if (this.shapemasks[2 * n3] == -1) {
            this.colorSquareTurtleTransparent(n, n2);
            return;
        }
        if (this.shapemasks[2 * n3 + 1] == -1) {
            this.colorSquarePatchTransparent(n, n2);
            return;
        }
        this.colorSquare(n, n2, Colors.colorarrayints[(int)(32.0 * this.shapecolors[n3])]);
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.panelpixels, 0, this.width);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    private final Point eventToPixel(MouseEvent mouseEvent) {
        return new Point(Math.min(this.size - 1, mouseEvent.getX() / this.gridlength), Math.min(this.size - 1, mouseEvent.getY() / this.gridlength));
    }

    private final void paintPixel(Point point) {
        int n = point.y * this.size + point.x;
        if (n < this.size * this.size) {
            if (this.paintselect.patch) {
                this.shapecolors[n] = 0.0;
                this.shapemasks[2 * n] = 0;
                this.shapemasks[2 * n + 1] = -1;
                this.colorSquarePatchTransparent(point.x, point.y);
            } else if (this.paintselect.turtle) {
                this.shapecolors[n] = 0.0;
                this.shapemasks[2 * n] = -1;
                this.shapemasks[2 * n + 1] = 0;
                this.colorSquareTurtleTransparent(point.x, point.y);
            } else {
                this.shapecolors[n] = this.parent.colortool.getColorDouble();
                this.shapemasks[2 * n] = 0;
                this.shapemasks[2 * n + 1] = 0;
                this.colorSquare(point.x, point.y, this.parent.colortool.getColorInt());
            }
        }
    }

    private final void clearPixel(Point point) {
        int n = point.y * this.size + point.x;
        this.shapecolors[n] = 0.0;
        this.shapemasks[2 * n] = 0;
        this.shapemasks[2 * n + 1] = -1;
        this.colorSquarePatchTransparent(point.x, point.y);
    }

    private final void yoinkPixel(Point point) {
        int n = point.y * this.size + point.x;
        if (this.shapemasks[2 * n] == -1) {
            this.paintselect.mouseClicked(new MouseEvent(this.paintselect, -1, 0L, 0, 28, 15, 0, false));
        } else if (this.shapemasks[2 * n + 1] == -1) {
            this.paintselect.mouseClicked(new MouseEvent(this.paintselect, -1, 0L, 0, 5, 15, 0, false));
        } else {
            this.paintselect.deselect();
            this.parent.colortool.setColor((int)this.shapecolors[n]);
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.cm);
            imageConsumer.setDimensions(this.width, this.height);
        }
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.panelpixels, 0, this.width);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (JShapePaintTool.buttonDown) {
            case 0: {
                return;
            }
            case 1: {
                this.paintPixel(this.eventToPixel(mouseEvent));
                break;
            }
            case 2: {
                this.clearPixel(this.eventToPixel(mouseEvent));
                break;
            }
            case 4: {
                this.yoinkPixel(this.eventToPixel(mouseEvent));
                return;
            }
            case 3: {
                this.lineMouseDragged(this.eventToPixel(mouseEvent));
                break;
            }
            case 5: {
                this.rectangleMouseDragged(this.eventToPixel(mouseEvent));
                break;
            }
            case 6: {
                this.fillRectangleMouseDragged(this.eventToPixel(mouseEvent));
                break;
            }
            case 7: {
                this.ovalMouseDragged(this.eventToPixel(mouseEvent));
                break;
            }
            case 8: {
                this.fillOvalMouseDragged(this.eventToPixel(mouseEvent));
                break;
            }
        }
        this.updateDisplay();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (JShapePaintTool.buttonDown == 9) {
            this.polygonMouseMoved(this.eventToPixel(mouseEvent));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (JShapePaintTool.buttonDown) {
            case 0: {
                return;
            }
            case 1: {
                this.paintPixel(this.eventToPixel(mouseEvent));
                break;
            }
            case 2: {
                this.clearPixel(this.eventToPixel(mouseEvent));
                break;
            }
            case 4: {
                this.yoinkPixel(this.eventToPixel(mouseEvent));
                return;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.shapeMousePressed(this.eventToPixel(mouseEvent));
                break;
            }
            case 9: {
                this.polygonMousePressed(this.eventToPixel(mouseEvent));
                break;
            }
            case 10: {
                this.fillArea(this.eventToPixel(mouseEvent));
                break;
            }
        }
        this.updateDisplay();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (JShapePaintTool.buttonDown) {
            case 3: {
                this.lineMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 5: {
                this.rectangleMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 6: {
                this.fillRectangleMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 7: {
                this.ovalMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 8: {
                this.fillOvalMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 9: {
                this.polygonMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
        }
        this.updateDisplay();
    }

    void shapeMousePressed(Point point) {
        this.mousedownx = point.x;
        this.mousedowny = point.y;
        System.arraycopy(this.shapecolors, 0, this.shapecolors_backup, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks, 0, this.shapemasks_backup, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels, 0, this.panelpixels_backup, 0, this.panelpixels.length);
    }

    void lineMouseDragged(Point point) {
        System.arraycopy(this.shapecolors_backup, 0, this.shapecolors, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks_backup, 0, this.shapemasks, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels_backup, 0, this.panelpixels, 0, this.panelpixels.length);
        this.lineMouseReleased(point);
    }

    void lineMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, point.x, point.y);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] == null) {
                return;
            }
            this.paintPixel(pointArray[n]);
            ++n;
        }
    }

    private final Point[] patchesInLine(int n, int n2, int n3, int n4) {
        int n5 = n < n3 ? n3 - n : n - n3;
        int n6 = n2 < n4 ? n4 - n2 : n2 - n4;
        Point[] pointArray = new Point[2 * (n5 + n6) + 1];
        int n7 = 0;
        if (n5 > n6) {
            if (n < n3) {
                int n8 = n;
                while (n8 <= n3) {
                    int n9 = (n4 - n2) * (n8 - n) / n5 + n2;
                    pointArray[n7++] = new Point(n8, n9);
                    ++n8;
                }
            } else if (n > n3) {
                int n10 = n3;
                while (n10 <= n) {
                    int n11 = (n4 - n2) * (n10 - n) / (n3 - n) + n2;
                    pointArray[n7++] = new Point(n10, n11);
                    ++n10;
                }
            }
        } else if (n2 < n4) {
            int n12 = n2;
            while (n12 <= n4) {
                int n13 = (n3 - n) * (n12 - n2) / n6 + n;
                pointArray[n7++] = new Point(n13, n12);
                ++n12;
            }
        } else if (n2 > n4) {
            int n14 = n4;
            while (n14 <= n2) {
                int n15 = (n3 - n) * (n14 - n2) / (n4 - n2) + n;
                pointArray[n7++] = new Point(n15, n14);
                ++n14;
            }
        } else {
            pointArray[n7++] = new Point(this.mousedownx, this.mousedowny);
        }
        return pointArray;
    }

    void rectangleMouseDragged(Point point) {
        System.arraycopy(this.shapecolors_backup, 0, this.shapecolors, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks_backup, 0, this.shapemasks, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels_backup, 0, this.panelpixels, 0, this.panelpixels.length);
        this.rectangleMouseReleased(point);
    }

    void rectangleMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        int n = Math.min(this.mousedownx, point.x);
        int n2 = Math.min(this.mousedowny, point.y);
        int n3 = Math.max(this.mousedownx, point.x);
        int n4 = Math.max(this.mousedowny, point.y);
        int n5 = n;
        while (n5 <= n3) {
            this.paintPixel(new Point(n5, n2));
            ++n5;
        }
        n5 = n;
        while (n5 <= n3) {
            this.paintPixel(new Point(n5, n4));
            ++n5;
        }
        n5 = n2;
        while (n5 <= n4) {
            this.paintPixel(new Point(n, n5));
            ++n5;
        }
        n5 = n2;
        while (n5 <= n4) {
            this.paintPixel(new Point(n3, n5));
            ++n5;
        }
    }

    void fillRectangleMouseDragged(Point point) {
        System.arraycopy(this.shapecolors_backup, 0, this.shapecolors, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks_backup, 0, this.shapemasks, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels_backup, 0, this.panelpixels, 0, this.panelpixels.length);
        this.fillRectangleMouseReleased(point);
    }

    void fillRectangleMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        int n = Math.min(this.mousedownx, point.x);
        int n2 = Math.min(this.mousedowny, point.y);
        int n3 = Math.max(this.mousedownx, point.x);
        int n4 = Math.max(this.mousedowny, point.y);
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                this.paintPixel(new Point(n5, n6));
                ++n6;
            }
            ++n5;
        }
    }

    void ovalMouseDragged(Point point) {
        System.arraycopy(this.shapecolors_backup, 0, this.shapecolors, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks_backup, 0, this.shapemasks, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels_backup, 0, this.panelpixels, 0, this.panelpixels.length);
        this.ovalMouseReleased(point);
    }

    void ovalMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        this.paintPatchesOval(this.mousedownx, this.mousedowny, point.x, point.y, 0);
    }

    void fillOvalMouseDragged(Point point) {
        System.arraycopy(this.shapecolors_backup, 0, this.shapecolors, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks_backup, 0, this.shapemasks, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels_backup, 0, this.panelpixels, 0, this.panelpixels.length);
        this.fillOvalMouseReleased(point);
    }

    void fillOvalMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        this.paintPatchesOval(this.mousedownx, this.mousedowny, point.x, point.y, 1);
    }

    private final void paintPatchesOval(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        n7 = n3 - n;
        n6 = n4 - n2;
        if (n7 < 2) {
            this.paintBlock(n, n2, n3, n4);
            return;
        }
        if (n6 < 2) {
            this.paintBlock(n, n2, n3, n4);
            return;
        }
        int n8 = n + n3 + 1;
        int n9 = n2 + n4 + 1;
        int n10 = n6 * n6;
        int n11 = n7 * n7;
        int n12 = n8 % 2 == 0 ? 1 : 0;
        int n13 = (int)Math.sqrt((double)n10 * (1.0 - (double)(n12 * n12) / (double)n11));
        while ((double)(n6 * n12) / ((double)n11 * Math.sqrt(1.0 - (double)(n12 * n12) / (double)n11)) < 1.0 && n13 >= 0) {
            this.paintPointInOval(n8, n9, n12, n13, n5);
            n13 = (int)Math.sqrt((double)n10 * (1.0 - (double)((n12 += 2) * n12) / (double)n11));
        }
        this.paintPointInOval(n8, n9, n12, n13, n5);
        n13 = n9 % 2 == 0 ? 1 : 0;
        n12 = (int)Math.sqrt((double)n11 * (1.0 - (double)(n13 * n13) / (double)n10));
        while ((double)(n7 * n13) / ((double)n10 * Math.sqrt(1.0 - (double)(n13 * n13) / (double)n10)) < 1.0 && n12 >= 0) {
            this.paintPointInOval(n8, n9, n12, n13, n5);
            n12 = (int)Math.sqrt((double)n11 * (1.0 - (double)((n13 += 2) * n13) / (double)n10));
        }
    }

    private final void paintBlock(int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                this.paintPixel(new Point(n5, n6));
                ++n6;
            }
            ++n5;
        }
    }

    void paintPointInOval(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n + n3) / 2;
        int n7 = (n2 + n4) / 2;
        int n8 = (n - n3 - 1) / 2;
        int n9 = (n2 - n4 - 1) / 2;
        if (n5 == 1) {
            int n10 = n8;
            while (n10 <= n6) {
                this.paintPixel(new Point(n10, n9));
                this.paintPixel(new Point(n10, n7));
                ++n10;
            }
        } else {
            this.paintPixel(new Point(n8, n9));
            this.paintPixel(new Point(n6, n9));
            this.paintPixel(new Point(n8, n7));
            this.paintPixel(new Point(n6, n7));
        }
    }

    void polygonMouseMoved(Point point) {
        if (!this.drawingPoly) {
            return;
        }
        System.arraycopy(this.shapecolors_backup, 0, this.shapecolors, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks_backup, 0, this.shapemasks, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels_backup, 0, this.panelpixels, 0, this.panelpixels.length);
        Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, point.x, point.y);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] == null) break;
            this.paintPixel(pointArray[n]);
            ++n;
        }
        this.updateDisplay();
    }

    void polygonMousePressed(Point point) {
        if (this.startOfPoly) {
            System.arraycopy(this.shapecolors, 0, this.shapecolors_backup, 0, this.shapecolors.length);
            System.arraycopy(this.shapemasks, 0, this.shapemasks_backup, 0, this.shapemasks.length);
            System.arraycopy(this.panelpixels, 0, this.panelpixels_backup, 0, this.panelpixels.length);
            this.drawingPoly = true;
            this.mousedownx = point.x;
            this.mousedowny = point.y;
            this.mousedragx = this.mousedownx;
            this.mousedragy = this.mousedowny;
            this.paintPixel(point);
            this.startOfPoly = false;
            this.polyHeadx = point.x;
            this.polyHeady = point.y;
        } else {
            this.mousedragx = point.x;
            this.mousedragy = point.y;
            Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            int n = 0;
            while (n < pointArray.length) {
                if (pointArray[n] == null) break;
                this.paintPixel(pointArray[n]);
                ++n;
            }
            this.mousedownx = this.mousedragx;
            this.mousedowny = this.mousedragy;
            if (point.x == this.polyHeadx && point.y == this.polyHeady) {
                this.startOfPoly = true;
                this.drawingPoly = false;
            }
        }
    }

    void polygonMouseReleased(Point point) {
        Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] == null) break;
            this.paintPixel(pointArray[n]);
            ++n;
        }
        System.arraycopy(this.shapecolors, 0, this.shapecolors_backup, 0, this.shapecolors.length);
        System.arraycopy(this.shapemasks, 0, this.shapemasks_backup, 0, this.shapemasks.length);
        System.arraycopy(this.panelpixels, 0, this.panelpixels_backup, 0, this.panelpixels.length);
    }

    void fillArea(Point point) {
        Point point2;
        Stack<Point> stack = new Stack<Point>();
        Hashtable<Point, Object> hashtable = new Hashtable<Point, Object>();
        Hashtable<Point, Object> hashtable2 = new Hashtable<Point, Object>();
        Object object = new Object();
        stack.push(point);
        int[] nArray = new int[]{0, 0, -1, 1};
        int[] nArray2 = new int[]{1, -1, 0, 0};
        hashtable.put(point, object);
        while (!stack.empty()) {
            point2 = (Point)stack.pop();
            hashtable2.put(point2, object);
            int n = 0;
            while (n < nArray.length) {
                Point point3 = new Point(point2.x + nArray[n], point2.y + nArray2[n]);
                if (!hashtable.containsKey(point3) && point3.x > -1 && point3.x < this.size && point3.y > -1 && point3.y < this.size && this.isColoredSame(point2, point3)) {
                    hashtable.put(point3, object);
                    stack.push(new Point(point3));
                }
                ++n;
            }
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            point2 = (Point)enumeration.nextElement();
            this.paintPixel(point2);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        e8x8Image = toolkit.getImage((class$Lstarlogo$JShapeEditorPanel != null ? class$Lstarlogo$JShapeEditorPanel : (class$Lstarlogo$JShapeEditorPanel = JShapeEditorPanel.class$("starlogo.JShapeEditorPanel"))).getResource(string + "turtle-transparent-8.gif"));
        e17x17Image = toolkit.getImage((class$Lstarlogo$JShapeEditorPanel != null ? class$Lstarlogo$JShapeEditorPanel : (class$Lstarlogo$JShapeEditorPanel = JShapeEditorPanel.class$("starlogo.JShapeEditorPanel"))).getResource(string + "turtle-transparent-17.gif"));
        e35x35Image = toolkit.getImage((class$Lstarlogo$JShapeEditorPanel != null ? class$Lstarlogo$JShapeEditorPanel : (class$Lstarlogo$JShapeEditorPanel = JShapeEditorPanel.class$("starlogo.JShapeEditorPanel"))).getResource(string + "turtle-transparent-35.gif"));
        mediaTracker.addImage(e8x8Image, Widget.trackerID++);
        mediaTracker.addImage(e17x17Image, Widget.trackerID++);
        mediaTracker.addImage(e35x35Image, Widget.trackerID++);
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(e8x8Image, 0, 0, 8, 8, turtleTrans8x8, 0, 8);
            pixelGrabber.grabPixels();
            pixelGrabber = new PixelGrabber(e17x17Image, 0, 0, 17, 17, turtleTrans16x16, 0, 17);
            pixelGrabber.grabPixels();
            pixelGrabber = new PixelGrabber(e35x35Image, 0, 0, 35, 35, turtleTrans32x32, 0, 35);
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JShapeEditorPanel(JShapeEditor jShapeEditor) {
        this.parent = jShapeEditor;
        this.size = jShapeEditor.size;
        this.init(true);
        this.image = jShapeEditor.createImage(this);
        this.drawGrid();
        this.refresh();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(289, 289));
    }

    static {
        try {
            int n;
            GRAY = Colors.colorarrayints[160];
            int n2 = WHITE = Colors.colorarrayints[288];
            int n3 = 0;
            while (n3 < 8) {
                n = 0;
                while (n < 8) {
                    JShapeEditorPanel.patchTrans8x8[n3 * 8 + n] = n2;
                    n2 = n2 == WHITE ? GRAY : WHITE;
                    ++n;
                }
                n2 = n2 == WHITE ? GRAY : WHITE;
                ++n3;
            }
            n2 = WHITE;
            n3 = 0;
            while (n3 < 17) {
                n = 0;
                while (n < 17) {
                    JShapeEditorPanel.patchTrans16x16[n3 * 17 + n] = n2;
                    n2 = n2 == WHITE ? GRAY : WHITE;
                    ++n;
                }
                ++n3;
            }
            n2 = WHITE;
            n3 = 0;
            while (n3 < 35) {
                n = 0;
                while (n < 35) {
                    JShapeEditorPanel.patchTrans32x32[n3 * 35 + n] = n2;
                    n2 = n2 == WHITE ? GRAY : WHITE;
                    ++n;
                }
                ++n3;
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(17, 17, patchTrans16x16, 0, 17);
            patchTrans16x16AsImage = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        turtleTrans8x8 = new int[64];
        turtleTrans16x16 = new int[289];
        turtleTrans32x32 = new int[1225];
    }
}

