/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import starlogo.Colors;
import starlogo.JShapeEditor;
import starlogo.JShapePaintSelect;

public class JShapeColorTool
extends JPanel {
    static int cellHeight1 = 15;
    static int cellHeight2 = 21;
    static int cellWidth = 24;
    JShapePaintSelect paintselect;
    public int colorDown = 0;
    public int shadeDown = 5;
    public int curcolor = 5;
    JShapeEditor parent;

    public void paintComponent(Graphics graphics) {
        int n;
        graphics.setColor(SystemColor.control);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        Color color = graphics.getColor();
        int n2 = 0;
        while (n2 < 14) {
            n = n2 * 10 + this.shadeDown;
            graphics.setColor(Colors.colorarray[n * 32]);
            graphics.fillRect(0, n2 * cellHeight1, cellWidth, cellHeight1);
            ++n2;
        }
        Color color2 = Colors.colorarray[this.curcolor * 32];
        n = 255 - color2.getBlue();
        int n3 = 255 - color2.getGreen();
        int n4 = 255 - color2.getRed();
        Color color3 = new Color(n4, n3, n);
        graphics.setColor(color3);
        graphics.drawRect(0, this.colorDown * cellHeight1, cellWidth - 1, cellHeight1 - 1);
        int n5 = 0;
        while (n5 < 10) {
            int n6 = this.colorDown * 10 + n5;
            graphics.setColor(Colors.colorarray[n6 * 32]);
            graphics.fillRect(cellWidth, n5 * cellHeight2, cellWidth, cellHeight2);
            ++n5;
        }
        graphics.setColor(color3);
        graphics.drawRect(cellWidth, this.shadeDown * cellHeight2, cellWidth - 1, cellHeight2 - 1);
        graphics.setColor(color);
    }

    public void pointToButton(int n, int n2) {
        int n3 = (int)Math.floor(n / cellWidth);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 1) {
            n3 = 1;
        }
        if (n3 == 0) {
            int n4 = (int)Math.floor(n2 / cellHeight1);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 13) {
                n4 = 13;
            }
            this.setColor(n4, this.shadeDown);
        } else {
            int n5 = (int)Math.floor(n2 / cellHeight2);
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 9) {
                n5 = 9;
            }
            this.setColor(this.colorDown, n5);
        }
    }

    public void setColor(int n) {
        if (n < 0 || n > 139) {
            return;
        }
        this.setColor(n / 10, n % 10);
    }

    public void setColor(int n, int n2) {
        this.paintselect.deselect();
        if (n == this.colorDown && n2 == this.shadeDown) {
            return;
        }
        this.colorDown = n;
        this.shadeDown = n2;
        this.curcolor = this.colorDown * 10 + this.shadeDown;
        this.repaint();
    }

    public Color getColor() {
        return Colors.colorarray[this.curcolor * 32];
    }

    public double getColorDouble() {
        return this.curcolor;
    }

    public int getColorInt() {
        return Colors.colorarrayints[this.curcolor * 32];
    }

    public JShapeColorTool(JShapeEditor jShapeEditor) {
        this.parent = jShapeEditor;
        this.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ JShapeColorTool this$0;

            public final void mouseClicked(MouseEvent mouseEvent) {
                this.this$0.pointToButton(mouseEvent.getX(), mouseEvent.getY());
            }

            public final void mousePressed(MouseEvent mouseEvent) {
                this.this$0.pointToButton(mouseEvent.getX(), mouseEvent.getY());
            }
            {
                this.this$0 = jShapeColorTool;
                this.constructor$0(jShapeColorTool);
            }

            private final void constructor$0(JShapeColorTool jShapeColorTool) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            private final /* synthetic */ JShapeColorTool this$0;

            public final void mouseDragged(MouseEvent mouseEvent) {
                this.this$0.pointToButton(mouseEvent.getX(), mouseEvent.getY());
            }
            {
                this.this$0 = jShapeColorTool;
                this.constructor$0(jShapeColorTool);
            }

            private final void constructor$0(JShapeColorTool jShapeColorTool) {
            }
        });
    }
}

