/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoManager;
import starlogo.Application;
import starlogo.DoubleInsets;
import starlogo.InfoWindow;
import starlogo.JSLDialog;
import starlogo.JSLMenu;
import starlogo.MenuListener;
import starlogo.NSLMenu;
import starlogo.OutputWindow;
import starlogo.Print;
import starlogo.PrintDialog;
import starlogo.Printable;
import starlogo.PrintingCanceledException;
import starlogo.ProcMouseAdapter;
import starlogo.SLMenu;
import starlogo.StarLogo;
import starlogo.StarLogoFrame;
import yoyo.JTEStream;
import yoyo.YoYo;

public class InfoWindow
extends JFrame
implements MenuListener,
ClipboardOwner,
StarLogoFrame,
Printable {
    private static Font INFO_FONT;
    public JTextArea ta;
    PrintWriter pw;
    Clipboard clip;
    SLMenu slmenu;
    Application app;
    StarLogo sl;
    UndoManager undoManager = new 1(this);
    private static /* synthetic */ Class class$Lstarlogo$Pool;

    public void init() {
        ((Component)this).setLocation(0, 0);
        ((Component)this).setSize(500, 400);
        this.setupText();
        this.setupLayout();
        this.slmenu = YoYo.macintoshp && !YoYo.macosxp ? new NSLMenu(this, this.app) : new JSLMenu(this, this.app);
        this.slmenu.setMenuBar(this);
        this.addNotify();
        this.setupKeyTrackers();
    }

    public void setupText() {
        this.ta = new JTextArea("", 10, 10);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        this.ta.setCaretPosition(0);
        this.ta.getDocument().addUndoableEditListener(this.undoManager);
        JScrollPane jScrollPane = new JScrollPane(this.ta, YoYo.macintoshp ? 22 : 20, 31);
        this.ta.setFont(INFO_FONT);
        JSLDialog.colorText(this.ta);
        this.pw = new PrintWriter(new JTEStream(this.ta), true);
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    void setupKeyTrackers() {
        ControlKeyAdapter controlKeyAdapter = new ControlKeyAdapter(this);
        this.ta.addKeyListener(controlKeyAdapter);
        ProcMouseAdapter procMouseAdapter = new ProcMouseAdapter();
        this.ta.addMouseListener(procMouseAdapter);
        this.addKeyListener(controlKeyAdapter);
    }

    public void setupLayout() {
    }

    public String getSaveString() {
        return "\r\n`information`\r\n" + this.toExternalLinefeeds(this.ta.getText());
    }

    public String getContents() {
        return this.toExternalLinefeeds(this.ta.getText());
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable;
        Object object = itemEvent.getSource();
        String string = "";
        boolean bl = false;
        if (object instanceof JRadioButtonMenuItem) {
            itemSelectable = (JRadioButtonMenuItem)object;
            string = ((AbstractButton)itemSelectable).getLabel();
            bl = ((AbstractButton)itemSelectable).isSelected();
        } else if (object instanceof CheckboxMenuItem) {
            itemSelectable = (CheckboxMenuItem)object;
            string = ((MenuItem)((Object)itemSelectable)).getLabel();
            bl = ((CheckboxMenuItem)itemSelectable).getState();
        }
        try {
            int n = Integer.parseInt(string);
            Font font = this.ta.getFont();
            this.ta.setFont(new Font(font.getName(), font.getStyle(), n));
            this.slmenu.setCurrentSize(object);
            return;
        }
        catch (Exception exception) {
            Font font = this.ta.getFont();
            this.ta.setFont(new Font(string, font.getStyle(), font.getSize()));
            this.slmenu.setCurrentFont(object);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        String string = "";
        if (object2 instanceof JMenuItem) {
            object = (JMenuItem)object2;
            string = ((AbstractButton)object).getLabel();
        } else if (object2 instanceof MenuItem) {
            object = (MenuItem)object2;
            string = ((MenuItem)object).getLabel();
        }
        if (string.equals("Cut") || string.equals("Corte")) {
            object = this.ta.getSelectedText();
            if (((String)object).equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection((String)object);
            this.clip.setContents(stringSelection, this);
            int n = this.ta.getSelectionStart();
            this.ta.replaceRange("", n, this.ta.getSelectionEnd());
            this.ta.select(n, n);
            this.app.project.markChanged();
            return;
        }
        if (string.equals("Copy") || string.equals("Copie")) {
            object = this.ta.getSelectedText();
            if (((String)object).equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection((String)object);
            this.clip.setContents(stringSelection, this);
            return;
        }
        if (string.equals("Paste") || string.equals("Pegue")) {
            object = this.clip.getContents(this);
            if (object != null) {
                try {
                    Object object3 = object.getTransferData(DataFlavor.stringFlavor);
                    if (object3 instanceof String) {
                        String string2 = (String)object3;
                        int n = string2.length();
                        int n2 = this.ta.getCaretPosition();
                        if (n == 0) {
                            this.ta.insert(string2, n2);
                            this.ta.select(n2 + n, n2 + n);
                        } else {
                            int n3 = this.ta.getSelectionStart();
                            this.ta.replaceRange(string2, n3, this.ta.getSelectionEnd());
                            this.ta.select(n3 + n, n3 + n);
                        }
                        this.app.project.markChanged();
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return;
        }
        if (string.equals("Select All")) {
            this.ta.selectAll();
            return;
        }
        if (string.equals("Clear")) {
            this.ta.setText("");
            this.app.project.markChanged();
        }
        if (string.equals("Undo") || string.equals("Deshacer")) {
            this.undo();
            return;
        }
        if (string.equals("Redo") || string.equals("Repita")) {
            this.redo();
            return;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void registerCloser(Frame frame, Application application) {
    }

    public String toInternalLinefeeds(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\r') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toExternalLinefeeds(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n') {
                stringBuffer.append('\r');
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void reset() {
        SwingUtilities.invokeLater(new Runnable(this){
            private final /* synthetic */ InfoWindow this$0;

            public final void run() {
                this.this$0.ta.setText("");
                this.this$0.ta.setCaretPosition(0);
            }
            {
                this.this$0 = infoWindow;
                this.constructor$0(infoWindow);
            }

            private final void constructor$0(InfoWindow infoWindow) {
            }
        });
    }

    public void resetText(String string) {
        String string2 = "`information`";
        int n = string.indexOf(string2);
        if (n == -1) {
            this.ta.setText("");
            return;
        }
        int n2 = string.indexOf("`", n + string2.length());
        if (n2 == -1) {
            n2 = string.length();
        }
        this.ta.setText(this.toInternalLinefeeds(string.substring(string.indexOf(string2) + string2.length(), n2).trim()));
    }

    public void print() {
        try {
            PrintDialog printDialog = Application.createPrintDialog(this, true, true, false, true);
            printDialog.show();
            if (printDialog.canceledp()) {
                return;
            }
            DoubleInsets doubleInsets = printDialog.getMargins();
            Print print = new Print(this, this instanceof OutputWindow ? "Output Window" : "Information Window", printDialog.getOrientation(), doubleInsets.top, doubleInsets.bottom, doubleInsets.left, doubleInsets.right, printDialog.getResIndependent());
            printDialog.dispose();
            print.displayPrintingMessage(true);
            print.printText(this.ta.getText(), INFO_FONT, true);
            print.print();
        }
        catch (PrintingCanceledException printingCanceledException) {
            // empty catch block
        }
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public InfoWindow(Application application) {
        this(application, "Information Window");
        if (YoYo.language == 1) {
            this.setTitle("Ventana de Informacion");
        }
        if (!YoYo.macintoshp) {
            ImageIcon imageIcon = new ImageIcon((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = InfoWindow.class$("starlogo.Pool"))).getResource("gifs/icon.gif"));
            ((Frame)this).setIconImage(imageIcon.getImage());
        }
    }

    public InfoWindow(Application application, String string) {
        super(string);
        this.app = application;
        this.sl = application.sl;
        this.clip = application.clip;
        this.addWindowListener(application.windowHider);
        this.registerCloser(this, application);
        application.registerFrameTracker(this);
    }

    static {
        try {
            INFO_FONT = new Font("Monospaced", 0, 12);
            if (YoYo.macintoshp) {
                INFO_FONT = Font.getFont("starlogo.info.font", INFO_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ControlKeyAdapter
    extends KeyAdapter {
        Frame parent;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (YoYo.macintoshp && keyEvent.isMetaDown() && c == '.') {
                Object object = InfoWindow.this.sl.runningp;
                synchronized (object) {
                    InfoWindow.this.sl.stopAll();
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            InfoWindow.this.app.project.markChanged();
            char c = keyEvent.getKeyChar();
        }

        public void keyReleased(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
        }

        ControlKeyAdapter(Frame frame) {
            this.parent = frame;
        }
    }
}

