package Plugins::TransitionUpdater::Settings;
# TransitionUpdater/Settings.pm by James Sutula(jsutula@sutula.us) March 2008
#
# SqueezeCenter Copyright 2001-2007 Logitech.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use base qw(Slim::Web::Settings);

use Slim::Utils::Prefs;
use Slim::Utils::DateTime;

my $prefs = preferences('plugin.transitionupdater');

sub name {
	return Slim::Web::HTTP::protectName('PLUGIN_TRANSITION_UPDATER');
}

sub page {
	return Slim::Web::HTTP::protectURI('plugins/TransitionUpdater/settings/basic.html');
}

sub prefs {
	return ($prefs, qw(album_transition_duration album_transition_type random_transition_duration random_transition_type) );
}

sub handler {
	my ($class, $client, $params) = @_;

	return $class->SUPER::handler($client, $params);
}

1;

__END__
