/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.objectweb.asm.Opcodes;

public class ClassNode
extends AnnotatedNode
implements Opcodes {
    public static ClassNode[] EMPTY_ARRAY = new ClassNode[0];
    public static ClassNode THIS = new ClassNode(Object.class);
    public static ClassNode SUPER = new ClassNode(Object.class);
    private String name;
    private final int modifiers;
    private ClassNode[] interfaces;
    private MixinNode[] mixins;
    private List constructors = new ArrayList();
    private List objectInitializers = new ArrayList();
    private MapOfLists methods;
    private List methodsList;
    private List fields = new ArrayList();
    private List properties = new ArrayList();
    private Map fieldIndex = new HashMap();
    private ModuleNode module;
    private CompileUnit compileUnit;
    private boolean staticClass = false;
    private boolean scriptBody = false;
    private boolean script;
    private ClassNode superClass;
    protected boolean isPrimaryNode;
    protected Object lazyInitLock = new Object();
    protected Class clazz;
    private boolean lazyInitDone = true;
    private ClassNode componentType = null;
    private ClassNode redirect = null;
    private boolean annotated;
    private GenericsType[] genericsTypes = null;
    private boolean usesGenerics = false;
    private boolean placeholder;
    private MethodNode enclosingMethod = null;

    public ClassNode redirect() {
        if (this.redirect == null) {
            return this;
        }
        return this.redirect.redirect();
    }

    public void setRedirect(ClassNode cn) {
        if (this.isPrimaryNode) {
            throw new GroovyBugError("tried to set a redirect for a primary ClassNode (" + this.getName() + "->" + cn.getName() + ").");
        }
        if (cn != null) {
            cn = cn.redirect();
        }
        if (cn == this) {
            return;
        }
        this.redirect = cn;
    }

    public ClassNode makeArray() {
        ClassNode cn;
        if (this.redirect != null) {
            return this.redirect().makeArray();
        }
        if (this.clazz != null) {
            Class<?> ret = Array.newInstance(this.clazz, 0).getClass();
            cn = new ClassNode(ret, this);
        } else {
            cn = new ClassNode(this);
        }
        return cn;
    }

    public boolean isPrimaryClassNode() {
        return this.redirect().isPrimaryNode || this.componentType != null && this.componentType.isPrimaryClassNode();
    }

    private ClassNode(ClassNode componentType) {
        this(componentType.getName() + "[]", 1, ClassHelper.OBJECT_TYPE);
        this.componentType = componentType.redirect();
        this.isPrimaryNode = false;
    }

    private ClassNode(Class c, ClassNode componentType) {
        this(c);
        this.componentType = componentType;
        this.isPrimaryNode = false;
    }

    public ClassNode(Class c) {
        this(c.getName(), c.getModifiers(), null, null, MixinNode.EMPTY_ARRAY);
        this.clazz = c;
        this.lazyInitDone = false;
        CompileUnit cu = this.getCompileUnit();
        if (cu != null) {
            cu.addClass(this);
        }
        this.isPrimaryNode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyClassInit() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.lazyInitDone) {
                return;
            }
            Field[] fields = this.clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.addField(fields[i].getName(), fields[i].getModifiers(), this, null);
            }
            Method[] methods = this.clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                MethodNode mn = new MethodNode(m.getName(), m.getModifiers(), ClassHelper.make(m.getReturnType()), this.createParameters(m.getParameterTypes()), ClassHelper.make(m.getExceptionTypes()), null);
                this.addMethod(mn);
            }
            Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> ctor = constructors[i];
                this.addConstructor(ctor.getModifiers(), this.createParameters(ctor.getParameterTypes()), ClassHelper.make(ctor.getExceptionTypes()), null);
            }
            Class sc = this.clazz.getSuperclass();
            if (sc != null) {
                this.superClass = this.getPrimaryClassNode(sc);
            }
            this.buildInterfaceTypes(this.clazz);
            this.lazyInitDone = true;
        }
    }

    private ClassNode getPrimaryClassNode(Class clazz) {
        ClassNode result = null;
        if (this.compileUnit != null) {
            result = this.compileUnit.getClass(clazz.getName());
        }
        if (result == null) {
            result = ClassHelper.make(clazz);
        }
        return result;
    }

    private void buildInterfaceTypes(Class c) {
        Class<?>[] interfaces = c.getInterfaces();
        ClassNode[] ret = new ClassNode[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            ret[i] = this.getPrimaryClassNode(interfaces[i]);
        }
        this.interfaces = ret;
    }

    public MethodNode getEnclosingMethod() {
        return this.redirect().enclosingMethod;
    }

    public void setEnclosingMethod(MethodNode enclosingMethod) {
        this.redirect().enclosingMethod = enclosingMethod;
    }

    public ClassNode(String name, int modifiers, ClassNode superClass) {
        this(name, modifiers, superClass, EMPTY_ARRAY, MixinNode.EMPTY_ARRAY);
    }

    public ClassNode(String name, int modifiers, ClassNode superClass, ClassNode[] interfaces, MixinNode[] mixins) {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.mixins = mixins;
        this.isPrimaryNode = true;
        if (superClass != null) {
            this.usesGenerics = superClass.isUsingGenerics();
        }
        if (!this.usesGenerics && interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.usesGenerics = this.usesGenerics || interfaces[i].isUsingGenerics();
            }
        }
        this.methods = new MapOfLists();
        this.methodsList = new ArrayList();
    }

    public void setSuperClass(ClassNode superClass) {
        this.redirect().superClass = superClass;
    }

    public List getFields() {
        if (!this.lazyInitDone) {
            this.lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getFields();
        }
        return this.fields;
    }

    public ClassNode[] getInterfaces() {
        if (!this.lazyInitDone) {
            this.lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getInterfaces();
        }
        return this.interfaces;
    }

    public MixinNode[] getMixins() {
        return this.redirect().mixins;
    }

    public List getMethods() {
        if (!this.lazyInitDone) {
            this.lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getMethods();
        }
        return this.methodsList;
    }

    public List getAbstractMethods() {
        HashSet<ClassNode> abstractNodes = new HashSet<ClassNode>();
        ClassNode parent = this.redirect();
        do {
            abstractNodes.add(parent);
            ClassNode[] interfaces = parent.getInterfaces();
            ArrayList<ClassNode> interfaceList = new ArrayList<ClassNode>(Arrays.asList(interfaces));
            while (!interfaceList.isEmpty()) {
                ClassNode interfaceNode = (ClassNode)interfaceList.get(0);
                interfaceList.remove(0);
                abstractNodes.add(interfaceNode.redirect());
                interfaceList.addAll(Arrays.asList(interfaceNode.getInterfaces()));
            }
        } while ((parent = parent.getSuperClass().redirect()) != null && (parent.getModifiers() & 0x400) != 0);
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        Iterator methIt = this.getAllDeclaredMethods().iterator();
        while (methIt.hasNext()) {
            MethodNode method = (MethodNode)methIt.next();
            if (!abstractNodes.contains(method.getDeclaringClass().redirect()) || (method.getModifiers() & 0x400) == 0) continue;
            result.add(method);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List getAllDeclaredMethods() {
        return new ArrayList(this.getDeclaredMethodsMap().values());
    }

    protected Map getDeclaredMethodsMap() {
        ClassNode parent = this.getSuperClass();
        HashMap<String, MethodNode> result = null;
        result = parent != null ? parent.getDeclaredMethodsMap() : new HashMap<String, MethodNode>();
        ClassNode[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassNode iface = interfaces[i];
            Map ifaceMethodsMap = iface.getDeclaredMethodsMap();
            Iterator iter = ifaceMethodsMap.keySet().iterator();
            while (iter.hasNext()) {
                String methSig = (String)iter.next();
                if (result.containsKey(methSig)) continue;
                MethodNode methNode = (MethodNode)ifaceMethodsMap.get(methSig);
                result.put(methSig, methNode);
            }
        }
        Iterator iter = this.getMethods().iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            String sig = method.getTypeDescriptor();
            result.put(sig, method);
        }
        return result;
    }

    public String getName() {
        return this.redirect().name;
    }

    public String setName(String name) {
        this.redirect().name = name;
        return this.redirect().name;
    }

    public int getModifiers() {
        return this.redirect().modifiers;
    }

    public List getProperties() {
        return this.redirect().properties;
    }

    public List getDeclaredConstructors() {
        if (!this.lazyInitDone) {
            this.lazyClassInit();
        }
        return this.redirect().constructors;
    }

    public ModuleNode getModule() {
        return this.redirect().module;
    }

    public void setModule(ModuleNode module) {
        this.redirect().module = module;
        if (module != null) {
            this.redirect().compileUnit = module.getUnit();
        }
    }

    public void addField(FieldNode node) {
        node.setDeclaringClass(this.redirect());
        node.setOwner(this.redirect());
        this.redirect().fields.add(node);
        this.redirect().fieldIndex.put(node.getName(), node);
    }

    public void addProperty(PropertyNode node) {
        node.setDeclaringClass(this.redirect());
        FieldNode field = node.getField();
        this.addField(field);
        this.redirect().properties.add(node);
    }

    public PropertyNode addProperty(String name, int modifiers, ClassNode type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            PropertyNode pn = (PropertyNode)iter.next();
            if (!pn.getName().equals(name)) continue;
            return pn;
        }
        PropertyNode node = new PropertyNode(name, modifiers, type, this.redirect(), initialValueExpression, getterBlock, setterBlock);
        this.addProperty(node);
        return node;
    }

    public void addConstructor(ConstructorNode node) {
        node.setDeclaringClass(this);
        this.redirect().constructors.add(node);
    }

    public ConstructorNode addConstructor(int modifiers, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        ConstructorNode node = new ConstructorNode(modifiers, parameters, exceptions, code);
        this.addConstructor(node);
        return node;
    }

    public void addMethod(MethodNode node) {
        node.setDeclaringClass(this);
        this.redirect().methodsList.add(node);
        this.redirect().methods.put(node.getName(), node);
    }

    public MethodNode addMethod(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode other = this.getDeclaredMethod(name, parameters);
        if (other != null) {
            return other;
        }
        MethodNode node = new MethodNode(name, modifiers, returnType, parameters, exceptions, code);
        this.addMethod(node);
        return node;
    }

    public MethodNode addSyntheticMethod(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode answer = this.addMethod(name, modifiers, returnType, parameters, exceptions, code);
        answer.setSynthetic(true);
        return answer;
    }

    public FieldNode addField(String name, int modifiers, ClassNode type, Expression initialValue) {
        FieldNode node = new FieldNode(name, modifiers, type, this.redirect(), initialValue);
        this.addField(node);
        return node;
    }

    public void addInterface(ClassNode type) {
        boolean skip = false;
        ClassNode[] interfaces = this.redirect().interfaces;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!type.equals(interfaces[i])) continue;
            skip = true;
        }
        if (!skip) {
            ClassNode[] newInterfaces = new ClassNode[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            newInterfaces[interfaces.length] = type;
            this.redirect().interfaces = newInterfaces;
        }
    }

    public boolean equals(Object o) {
        if (this.redirect != null) {
            return this.redirect().equals(o);
        }
        ClassNode cn = (ClassNode)o;
        return cn.getName().equals(this.getName());
    }

    public void addMixin(MixinNode mixin) {
        MixinNode[] mixins = this.redirect().mixins;
        boolean skip = false;
        for (int i = 0; i < mixins.length; ++i) {
            if (!mixin.equals(mixins[i])) continue;
            skip = true;
        }
        if (!skip) {
            MixinNode[] newMixins = new MixinNode[mixins.length + 1];
            System.arraycopy(mixins, 0, newMixins, 0, mixins.length);
            newMixins[mixins.length] = mixin;
            this.redirect().mixins = newMixins;
        }
    }

    public FieldNode getField(String name) {
        return (FieldNode)this.redirect().fieldIndex.get(name);
    }

    public FieldNode getOuterField(String name) {
        return null;
    }

    public ClassNode getOuterClass() {
        return null;
    }

    public void addObjectInitializerStatements(Statement statements) {
        this.objectInitializers.add(statements);
    }

    public List getObjectInitializerStatements() {
        return this.objectInitializers;
    }

    public void addStaticInitializerStatements(List staticStatements, boolean fieldInit) {
        MethodNode method = null;
        List declaredMethods = this.getDeclaredMethods("<clinit>");
        if (declaredMethods.isEmpty()) {
            method = this.addMethod("<clinit>", 8, ClassHelper.VOID_TYPE, Parameter.EMPTY_ARRAY, EMPTY_ARRAY, new BlockStatement());
            method.setSynthetic(true);
        } else {
            method = (MethodNode)declaredMethods.get(0);
        }
        BlockStatement block = null;
        Statement statement = method.getCode();
        if (statement == null) {
            block = new BlockStatement();
        } else if (statement instanceof BlockStatement) {
            block = (BlockStatement)statement;
        } else {
            block = new BlockStatement();
            block.addStatement(statement);
        }
        if (!fieldInit) {
            block.addStatements(staticStatements);
        } else {
            List blockStatements = block.getStatements();
            staticStatements.addAll(blockStatements);
            blockStatements.clear();
            blockStatements.addAll(staticStatements);
        }
    }

    public List getDeclaredMethods(String name) {
        if (!this.lazyInitDone) {
            this.lazyClassInit();
        }
        if (this.redirect != null) {
            return this.redirect().getDeclaredMethods(name);
        }
        return this.methods.getNotNull(name);
    }

    public List getMethods(String name) {
        ArrayList answer = new ArrayList(this.getDeclaredMethods(name));
        ClassNode parent = this.getSuperClass();
        if (parent != null) {
            answer.addAll(parent.getMethods(name));
        }
        return answer;
    }

    public MethodNode getDeclaredMethod(String name, Parameter[] parameters) {
        List list = this.getDeclaredMethods(name);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public boolean isDerivedFrom(ClassNode type) {
        if (type.equals(ClassHelper.OBJECT_TYPE)) {
            return true;
        }
        for (ClassNode node = this; node != null; node = node.getSuperClass()) {
            if (!type.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFromGroovyObject() {
        return this.implementsInterface(GroovyObject.class.getName());
    }

    public boolean implementsInterface(String name) {
        ClassNode node = this.redirect();
        do {
            if (!node.declaresInterface(name)) continue;
            return true;
        } while ((node = node.getSuperClass()) != null);
        return false;
    }

    public boolean declaresInterface(String name) {
        ClassNode[] interfaces = this.redirect().getInterfaces();
        int size = interfaces.length;
        for (int i = 0; i < size; ++i) {
            if (!interfaces[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ClassNode getSuperClass() {
        if (!this.lazyInitDone && !this.isResolved()) {
            throw new GroovyBugError("Classnode#getSuperClass for " + this.getName() + " called before class resolving");
        }
        ClassNode sn = this.redirect().getUnresolvedSuperClass();
        if (sn != null) {
            sn = sn.redirect();
        }
        return sn;
    }

    public ClassNode getUnresolvedSuperClass() {
        return this.getUnresolvedSuperClass(true);
    }

    public ClassNode getUnresolvedSuperClass(boolean useRedirect) {
        if (!useRedirect) {
            return this.superClass;
        }
        if (!this.lazyInitDone) {
            this.lazyClassInit();
        }
        return this.redirect().superClass;
    }

    protected MethodNode createMethodNode(Method method) {
        Parameter[] parameters = this.createParameters(method.getParameterTypes());
        return new MethodNode(method.getName(), method.getModifiers(), ClassHelper.make(method.getReturnType()), parameters, ClassHelper.make(method.getExceptionTypes()), EmptyStatement.INSTANCE);
    }

    protected Parameter[] createParameters(Class[] types) {
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        int size = types.length;
        if (size > 0) {
            parameters = new Parameter[size];
            for (int i = 0; i < size; ++i) {
                parameters[i] = this.createParameter(types[i], i);
            }
        }
        return parameters;
    }

    protected Parameter createParameter(Class parameterType, int idx) {
        return new Parameter(ClassHelper.make(parameterType), "param" + idx);
    }

    public CompileUnit getCompileUnit() {
        if (this.redirect != null) {
            return this.redirect().getCompileUnit();
        }
        if (this.compileUnit == null && this.module != null) {
            this.compileUnit = this.module.getUnit();
        }
        return this.compileUnit;
    }

    protected void setCompileUnit(CompileUnit cu) {
        if (this.redirect != null) {
            this.redirect().setCompileUnit(cu);
        }
        if (this.compileUnit != null) {
            this.compileUnit = cu;
        }
    }

    protected boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length == b.length) {
            boolean answer = true;
            for (int i = 0; i < a.length; ++i) {
                if (a[i].getType().equals(b[i].getType())) continue;
                answer = false;
                break;
            }
            return answer;
        }
        return false;
    }

    public String getPackageName() {
        int idx = this.getName().lastIndexOf(46);
        if (idx > 0) {
            return this.getName().substring(0, idx);
        }
        return null;
    }

    public String getNameWithoutPackage() {
        int idx = this.getName().lastIndexOf(46);
        if (idx > 0) {
            return this.getName().substring(idx + 1);
        }
        return this.getName();
    }

    public void visitContents(GroovyClassVisitor visitor) {
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            PropertyNode pn = (PropertyNode)iter.next();
            visitor.visitProperty(pn);
        }
        iter = this.getFields().iterator();
        while (iter.hasNext()) {
            FieldNode fn = (FieldNode)iter.next();
            visitor.visitField(fn);
        }
        iter = this.getDeclaredConstructors().iterator();
        while (iter.hasNext()) {
            ConstructorNode cn = (ConstructorNode)iter.next();
            visitor.visitConstructor(cn);
        }
        iter = this.getMethods().iterator();
        while (iter.hasNext()) {
            MethodNode mn = (MethodNode)iter.next();
            visitor.visitMethod(mn);
        }
    }

    public MethodNode getGetterMethod(String getterName) {
        Iterator iter = this.getDeclaredMethods(getterName).iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!getterName.equals(method.getName()) || ClassHelper.VOID_TYPE == method.getReturnType() || method.getParameters().length != 0) continue;
            return method;
        }
        ClassNode parent = this.getSuperClass();
        if (parent != null) {
            return parent.getGetterMethod(getterName);
        }
        return null;
    }

    public MethodNode getSetterMethod(String setterName) {
        Iterator iter = this.getDeclaredMethods(setterName).iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!setterName.equals(method.getName()) || ClassHelper.VOID_TYPE != method.getReturnType() || method.getParameters().length != 1) continue;
            return method;
        }
        ClassNode parent = this.getSuperClass();
        if (parent != null) {
            return parent.getSetterMethod(setterName);
        }
        return null;
    }

    public boolean isStaticClass() {
        return this.redirect().staticClass;
    }

    public void setStaticClass(boolean staticClass) {
        this.redirect().staticClass = staticClass;
    }

    public boolean isScriptBody() {
        return this.redirect().scriptBody;
    }

    public void setScriptBody(boolean scriptBody) {
        this.redirect().scriptBody = scriptBody;
    }

    public boolean isScript() {
        return this.redirect().script || this.isDerivedFrom(ClassHelper.SCRIPT_TYPE);
    }

    public void setScript(boolean script) {
        this.redirect().script = script;
    }

    public String toString() {
        String ret = this.getName();
        if (this.genericsTypes != null) {
            ret = ret + " <";
            for (int i = 0; i < this.genericsTypes.length; ++i) {
                if (i != 0) {
                    ret = ret + ", ";
                }
                ret = ret + this.genericsTypes[i];
            }
            ret = ret + ">";
        }
        if (this.redirect != null) {
            ret = ret + " -> " + this.redirect().toString();
        }
        return ret;
    }

    public boolean hasPossibleMethod(String name, Expression arguments) {
        int count = 0;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            count = tuple.getExpressions().size();
        }
        ClassNode node = this;
        do {
            Iterator iter = this.getDeclaredMethods(name).iterator();
            while (iter.hasNext()) {
                MethodNode method = (MethodNode)iter.next();
                if (method.getParameters().length != count) continue;
                return true;
            }
        } while ((node = node.getSuperClass()) != null);
        return false;
    }

    public boolean hasPossibleStaticMethod(String name, Expression arguments) {
        int count = 0;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            count = tuple.getExpressions().size();
        }
        Iterator iter = this.getDeclaredMethods(name).iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (method.getParameters().length == count && method.isStatic()) {
                return true;
            }
            if (!method.isStatic() || method.getParameters().length <= 0 || !method.getParameters()[method.getParameters().length - 1].getType().isArray() || count < method.getParameters().length - 1) continue;
            return true;
        }
        return false;
    }

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) > 0;
    }

    public boolean isResolved() {
        return this.redirect().clazz != null || this.componentType != null && this.componentType.isResolved();
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public ClassNode getComponentType() {
        return this.componentType;
    }

    public Class getTypeClass() {
        Class c = this.redirect().clazz;
        if (c != null) {
            return c;
        }
        ClassNode component = this.redirect().componentType;
        if (component != null && component.isResolved()) {
            ClassNode cn = component.makeArray();
            this.setRedirect(cn);
            return this.redirect().clazz;
        }
        throw new GroovyBugError("ClassNode#getTypeClass for " + this.getName() + " is called before the type class is set ");
    }

    public boolean hasPackageName() {
        return this.redirect().name.indexOf(46) > 0;
    }

    public void setAnnotated(boolean flag) {
        this.annotated = flag;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public GenericsType[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.usesGenerics = this.usesGenerics || genericsTypes != null;
        this.genericsTypes = genericsTypes;
    }

    public void setGenericsPlaceHolder(boolean b) {
        this.usesGenerics = this.usesGenerics || b;
        this.placeholder = b;
    }

    public boolean isGenericsPlaceHolder() {
        return this.placeholder;
    }

    public boolean isUsingGenerics() {
        return this.usesGenerics;
    }

    public void setUsingGenerics(boolean b) {
        this.usesGenerics = b;
    }

    public ClassNode getPlainNodeReference() {
        if (ClassHelper.isPrimitiveType(this)) {
            return this;
        }
        ClassNode n = new ClassNode(this.getName(), this.getModifiers(), this.getSuperClass(), null, null);
        n.isPrimaryNode = false;
        n.setRedirect(this.redirect);
        return n;
    }

    private static class MapOfLists {
        private Map map = new HashMap();

        private MapOfLists() {
        }

        public List get(Object key) {
            return (List)this.map.get(key);
        }

        public List getNotNull(Object key) {
            List ret = this.get(key);
            if (ret == null) {
                ret = Collections.EMPTY_LIST;
            }
            return ret;
        }

        public void put(Object key, Object value) {
            if (this.map.containsKey(key)) {
                this.get(key).add(value);
            } else {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(value);
                this.map.put(key, list);
            }
        }
    }
}

