/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegateFactory;
import org.aspectj.weaver.reflect.ReflectionBasedResolvedMemberImpl;

public class ReflectionBasedReferenceTypeDelegate
implements ReferenceTypeDelegate {
    private static final ClassLoader BootClassLoader = new URLClassLoader(new URL[0]);
    protected Class myClass = null;
    protected ClassLoader classLoader = null;
    private World world;
    private ReferenceType resolvedType;
    private ResolvedMember[] fields = null;
    private ResolvedMember[] methods = null;
    private ResolvedType[] interfaces = null;
    static /* synthetic */ Class class$java$lang$Object;

    public ReflectionBasedReferenceTypeDelegate(Class forClass, ClassLoader aClassLoader, World inWorld, ReferenceType resolvedType) {
        this.initialize(resolvedType, forClass, aClassLoader, inWorld);
    }

    public ReflectionBasedReferenceTypeDelegate() {
    }

    public void initialize(ReferenceType aType, Class aClass, ClassLoader aClassLoader, World aWorld) {
        this.myClass = aClass;
        this.resolvedType = aType;
        this.world = aWorld;
        this.classLoader = aClassLoader != null ? aClassLoader : BootClassLoader;
    }

    protected Class getBaseClass() {
        return this.myClass;
    }

    protected World getWorld() {
        return this.world;
    }

    public ReferenceType buildGenericType() {
        throw new UnsupportedOperationException("Shouldn't be asking for generic type at 1.4 source level or lower");
    }

    public void addAnnotation(AnnotationX annotationX) {
        throw new UnsupportedOperationException("Cannot add an annotation to a reflection based delegate");
    }

    public boolean isAspect() {
        return false;
    }

    public boolean isAnnotationStyleAspect() {
        return false;
    }

    public boolean isInterface() {
        return this.myClass.isInterface();
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return false;
    }

    public String getRetentionPolicy() {
        return null;
    }

    public boolean canAnnotationTargetType() {
        return false;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        return null;
    }

    public boolean isClass() {
        return !this.myClass.isInterface() && !this.myClass.isPrimitive() && !this.myClass.isArray();
    }

    public boolean isGeneric() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isNested() {
        return true;
    }

    public ResolvedType getOuterClass() {
        return null;
    }

    public boolean isExposedToWeaver() {
        return false;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        return false;
    }

    public AnnotationX[] getAnnotations() {
        return new AnnotationX[0];
    }

    public ResolvedType[] getAnnotationTypes() {
        return new ResolvedType[0];
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.fields == null) {
            Field[] reflectFields = this.myClass.getDeclaredFields();
            ResolvedMember[] rFields = new ResolvedMember[reflectFields.length];
            for (int i = 0; i < reflectFields.length; ++i) {
                rFields[i] = ReflectionBasedReferenceTypeDelegateFactory.createResolvedMember(reflectFields[i], this.world);
            }
            this.fields = rFields;
        }
        return this.fields;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        if (this.interfaces == null) {
            Class<?>[] reflectInterfaces = this.myClass.getInterfaces();
            ResolvedType[] rInterfaces = new ResolvedType[reflectInterfaces.length];
            for (int i = 0; i < reflectInterfaces.length; ++i) {
                rInterfaces[i] = ReflectionBasedReferenceTypeDelegateFactory.resolveTypeInWorld(reflectInterfaces[i], this.world);
            }
            this.interfaces = rInterfaces;
        }
        return this.interfaces;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.methods == null) {
            int i;
            Method[] reflectMethods = this.myClass.getDeclaredMethods();
            Constructor<?>[] reflectCons = this.myClass.getDeclaredConstructors();
            ResolvedMember[] rMethods = new ResolvedMember[reflectMethods.length + reflectCons.length];
            for (i = 0; i < reflectMethods.length; ++i) {
                rMethods[i] = ReflectionBasedReferenceTypeDelegateFactory.createResolvedMember(reflectMethods[i], this.world);
            }
            for (i = 0; i < reflectCons.length; ++i) {
                rMethods[i + reflectMethods.length] = ReflectionBasedReferenceTypeDelegateFactory.createResolvedMember(reflectCons[i], this.world);
            }
            this.methods = rMethods;
        }
        return this.methods;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        return new ResolvedMember[0];
    }

    public TypeVariable[] getTypeVariables() {
        return new TypeVariable[0];
    }

    public PerClause getPerClause() {
        return null;
    }

    public Collection getDeclares() {
        return Collections.EMPTY_SET;
    }

    public Collection getTypeMungers() {
        return Collections.EMPTY_SET;
    }

    public Collection getPrivilegedAccesses() {
        return Collections.EMPTY_SET;
    }

    public int getModifiers() {
        return this.myClass.getModifiers();
    }

    public ResolvedType getSuperclass() {
        if (this.myClass.getSuperclass() == null) {
            if (this.myClass == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectionBasedReferenceTypeDelegate.class$("java.lang.Object")) : class$java$lang$Object)) {
                return null;
            }
            return this.world.resolve(UnresolvedType.OBJECT);
        }
        return ReflectionBasedReferenceTypeDelegateFactory.resolveTypeInWorld(this.myClass.getSuperclass(), this.world);
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    public ReferenceType getResolvedTypeX() {
        return this.resolvedType;
    }

    public boolean doesNotExposeShadowMungers() {
        return false;
    }

    public String getDeclaredGenericSignature() {
        return null;
    }

    public void ensureDelegateConsistent() {
    }

    public ReflectionBasedResolvedMemberImpl createResolvedMemberFor(Member aMember) {
        return null;
    }

    public String getSourcefilename() {
        return this.resolvedType.getName() + ".class";
    }

    public ISourceContext getSourceContext() {
        return SourceContextImpl.UNKNOWN_SOURCE_CONTEXT;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

