/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ArrayElementValue;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValue;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.AtAjAttributes;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelField;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.PerClause;

public class BcelObjectType
extends AbstractReferenceTypeDelegate {
    public JavaClass javaClass;
    private LazyClassGen lazyClassGen = null;
    private int modifiers;
    private String className;
    private String superclassSignature;
    private String superclassName;
    private String[] interfaceSignatures;
    private ResolvedMember[] fields = null;
    private ResolvedMember[] methods = null;
    private ResolvedType[] annotationTypes = null;
    private AnnotationX[] annotations = null;
    private TypeVariable[] typeVars = null;
    private String retentionPolicy;
    private AnnotationTargetKind[] annotationTargetKinds;
    private AjAttribute.WeaverVersionInfo wvInfo = AjAttribute.WeaverVersionInfo.UNKNOWN;
    private ResolvedPointcutDefinition[] pointcuts = null;
    private ResolvedMember[] privilegedAccess = null;
    private WeaverStateInfo weaverState = null;
    private PerClause perClause = null;
    private List typeMungers = Collections.EMPTY_LIST;
    private List declares = Collections.EMPTY_LIST;
    private Signature.FormalTypeParameter[] formalsForResolution = null;
    private String declaredSignature = null;
    private boolean hasBeenWoven = false;
    private boolean isGenericType = false;
    private boolean isInterface;
    private boolean isEnum;
    private boolean isAnnotation;
    private boolean isAnonymous;
    private boolean isNested;
    private boolean isObject = false;
    private boolean isAnnotationStyleAspect = false;
    private boolean isCodeStyleAspect = false;
    private int bitflag = 0;
    private static final int DISCOVERED_ANNOTATION_RETENTION_POLICY = 1;
    private static final int UNPACKED_GENERIC_SIGNATURE = 2;
    private static final int UNPACKED_AJATTRIBUTES = 4;
    private static final int DISCOVERED_ANNOTATION_TARGET_KINDS = 8;
    private static final int DISCOVERED_DECLARED_SIGNATURE = 16;
    private static final int DISCOVERED_WHETHER_ANNOTATION_STYLE = 32;
    private static final int DAMAGED = 64;

    BcelObjectType(ReferenceType resolvedTypeX, JavaClass javaClass, boolean exposedToWeaver) {
        super(resolvedTypeX, exposedToWeaver);
        this.javaClass = javaClass;
        this.initializeFromJavaclass();
        resolvedTypeX.setDelegate(this);
        if (resolvedTypeX.getSourceContext() == SourceContextImpl.UNKNOWN_SOURCE_CONTEXT) {
            this.setSourceContext(new SourceContextImpl(this));
        }
        this.isObject = javaClass.getSuperclassNameIndex() == 0;
        this.ensureAspectJAttributesUnpacked();
        this.setSourcefilename(javaClass.getSourceFileName());
    }

    public void setJavaClass(JavaClass newclass) {
        this.javaClass = newclass;
        this.resetState();
        this.initializeFromJavaclass();
    }

    private void initializeFromJavaclass() {
        this.isInterface = this.javaClass.isInterface();
        this.isEnum = this.javaClass.isEnum();
        this.isAnnotation = this.javaClass.isAnnotation();
        this.isAnonymous = this.javaClass.isAnonymous();
        this.isNested = this.javaClass.isNested();
        this.modifiers = this.javaClass.getAccessFlags();
        this.superclassName = this.javaClass.getSuperclassName();
        this.className = this.javaClass.getClassName();
        this.cachedGenericClassTypeSignature = null;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ResolvedType getSuperclass() {
        if (this.isObject) {
            return null;
        }
        this.ensureGenericSignatureUnpacked();
        if (this.superclassSignature == null) {
            if (this.superclassName == null) {
                this.superclassName = this.javaClass.getSuperclassName();
            }
            this.superclassSignature = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(this.superclassName)).getSignature();
        }
        ResolvedType res = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forSignature(this.superclassSignature));
        return res;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        this.ensureGenericSignatureUnpacked();
        ResolvedType[] interfaceTypes = null;
        if (this.interfaceSignatures == null) {
            String[] names = this.javaClass.getInterfaceNames();
            this.interfaceSignatures = new String[names.length];
            interfaceTypes = new ResolvedType[names.length];
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                interfaceTypes[i] = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(names[i]));
                this.interfaceSignatures[i] = interfaceTypes[i].getSignature();
            }
        } else {
            interfaceTypes = new ResolvedType[this.interfaceSignatures.length];
            int len = this.interfaceSignatures.length;
            for (int i = 0; i < len; ++i) {
                interfaceTypes[i] = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forSignature(this.interfaceSignatures[i]));
            }
        }
        return interfaceTypes;
    }

    public ResolvedMember[] getDeclaredMethods() {
        this.ensureGenericSignatureUnpacked();
        if (this.methods == null) {
            Method[] ms = this.javaClass.getMethods();
            this.methods = new ResolvedMember[ms.length];
            for (int i = ms.length - 1; i >= 0; --i) {
                this.methods[i] = new BcelMethod(this, ms[i]);
            }
        }
        return this.methods;
    }

    public ResolvedMember[] getDeclaredFields() {
        this.ensureGenericSignatureUnpacked();
        if (this.fields == null) {
            Field[] fs = this.javaClass.getFields();
            this.fields = new ResolvedMember[fs.length];
            int len = fs.length;
            for (int i = 0; i < len; ++i) {
                this.fields[i] = new BcelField(this, fs[i]);
            }
        }
        return this.fields;
    }

    public TypeVariable[] getTypeVariables() {
        if (!this.isGeneric()) {
            return TypeVariable.NONE;
        }
        if (this.typeVars == null) {
            Signature.ClassSignature classSig = this.getGenericClassTypeSignature();
            this.typeVars = new TypeVariable[classSig.formalTypeParameters.length];
            for (int i = 0; i < this.typeVars.length; ++i) {
                Signature.FormalTypeParameter ftp = classSig.formalTypeParameters[i];
                try {
                    this.typeVars[i] = BcelGenericSignatureToTypeXConverter.formalTypeParameter2TypeVariable(ftp, classSig.formalTypeParameters, this.getResolvedTypeX().getWorld());
                    continue;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While getting the type variables for type " + this.toString() + " with generic signature " + classSig + " the following error condition was detected: " + e.getMessage());
                }
            }
        }
        return this.typeVars;
    }

    public Collection getTypeMungers() {
        return this.typeMungers;
    }

    public Collection getDeclares() {
        return this.declares;
    }

    public Collection getPrivilegedAccesses() {
        if (this.privilegedAccess == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.privilegedAccess);
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        return this.pointcuts;
    }

    public boolean isAspect() {
        return this.perClause != null;
    }

    public boolean isAnnotationStyleAspect() {
        if ((this.bitflag & 0x20) == 0) {
            this.bitflag |= 0x20;
            this.isAnnotationStyleAspect = !this.isCodeStyleAspect && this.hasAnnotation(AjcMemberMaker.ASPECT_ANNOTATION);
        }
        return this.isAnnotationStyleAspect;
    }

    private void ensureAspectJAttributesUnpacked() {
        if ((this.bitflag & 4) != 0) {
            return;
        }
        this.bitflag |= 4;
        IMessageHandler msgHandler = this.getResolvedTypeX().getWorld().getMessageHandler();
        List l = BcelAttributes.readAjAttributes(this.className, this.javaClass.getAttributes(), this.getResolvedTypeX().getSourceContext(), this.getResolvedTypeX().getWorld(), AjAttribute.WeaverVersionInfo.UNKNOWN);
        ArrayList pointcuts = new ArrayList();
        this.typeMungers = new ArrayList();
        this.declares = new ArrayList();
        this.processAttributes(l, pointcuts, false);
        l = AtAjAttributes.readAj5ClassAttributes(this.javaClass, this.getResolvedTypeX(), this.getResolvedTypeX().getSourceContext(), msgHandler, this.isCodeStyleAspect);
        AjAttribute.Aspect deferredAspectAttribute = this.processAttributes(l, pointcuts, true);
        this.pointcuts = pointcuts.toArray(new ResolvedPointcutDefinition[pointcuts.size()]);
        this.resolveAnnotationDeclares(l);
        if (deferredAspectAttribute != null) {
            this.perClause = deferredAspectAttribute.reifyFromAtAspectJ(this.getResolvedTypeX());
        }
    }

    private AjAttribute.Aspect processAttributes(List attributeList, List pointcuts, boolean fromAnnotations) {
        AjAttribute.Aspect deferredAspectAttribute = null;
        Iterator iter = attributeList.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.Aspect) {
                if (fromAnnotations) {
                    deferredAspectAttribute = (AjAttribute.Aspect)a;
                    continue;
                }
                this.perClause = ((AjAttribute.Aspect)a).reify(this.getResolvedTypeX());
                this.isCodeStyleAspect = true;
                continue;
            }
            if (a instanceof AjAttribute.PointcutDeclarationAttribute) {
                pointcuts.add(((AjAttribute.PointcutDeclarationAttribute)a).reify());
                continue;
            }
            if (a instanceof AjAttribute.WeaverState) {
                this.weaverState = ((AjAttribute.WeaverState)a).reify();
                continue;
            }
            if (a instanceof AjAttribute.TypeMunger) {
                this.typeMungers.add(((AjAttribute.TypeMunger)a).reify(this.getResolvedTypeX().getWorld(), this.getResolvedTypeX()));
                continue;
            }
            if (a instanceof AjAttribute.DeclareAttribute) {
                this.declares.add(((AjAttribute.DeclareAttribute)a).getDeclare());
                continue;
            }
            if (a instanceof AjAttribute.PrivilegedAttribute) {
                this.privilegedAccess = ((AjAttribute.PrivilegedAttribute)a).getAccessedMembers();
                continue;
            }
            if (a instanceof AjAttribute.SourceContextAttribute) {
                if (!(this.getResolvedTypeX().getSourceContext() instanceof SourceContextImpl)) continue;
                AjAttribute.SourceContextAttribute sca = (AjAttribute.SourceContextAttribute)a;
                ((SourceContextImpl)this.getResolvedTypeX().getSourceContext()).configureFromAttribute(sca.getSourceFileName(), sca.getLineBreaks());
                continue;
            }
            if (a instanceof AjAttribute.WeaverVersionInfo) {
                this.wvInfo = (AjAttribute.WeaverVersionInfo)a;
                continue;
            }
            throw new BCException("bad attribute " + a);
        }
        return deferredAspectAttribute;
    }

    private void resolveAnnotationDeclares(List attributeList) {
        FormalBinding[] bindings = new FormalBinding[]{};
        AtAjAttributes.BindingScope bindingScope = new AtAjAttributes.BindingScope(this.getResolvedTypeX(), this.getResolvedTypeX().getSourceContext(), bindings);
        Iterator iter = attributeList.iterator();
        while (iter.hasNext()) {
            Declare decl;
            AjAttribute a = (AjAttribute)iter.next();
            if (!(a instanceof AjAttribute.DeclareAttribute) || !((decl = ((AjAttribute.DeclareAttribute)a).getDeclare()) instanceof DeclareErrorOrWarning) && !(decl instanceof DeclarePrecedence)) continue;
            decl.resolve(bindingScope);
        }
    }

    public PerClause getPerClause() {
        this.ensureAspectJAttributesUnpacked();
        return this.perClause;
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    public void ensureDelegateConsistent() {
        if ((this.bitflag & 0x40) != 0) {
            this.resetState();
        }
    }

    public void resetState() {
        if (this.javaClass == null) {
            throw new BCException("can't weave evicted type");
        }
        this.bitflag = 0;
        this.annotationTypes = null;
        this.annotations = null;
        this.interfaceSignatures = null;
        this.superclassSignature = null;
        this.superclassName = null;
        this.fields = null;
        this.methods = null;
        this.pointcuts = null;
        this.perClause = null;
        this.weaverState = null;
        this.lazyClassGen = null;
        this.hasBeenWoven = false;
        this.isObject = this.javaClass.getSuperclassNameIndex() == 0;
        this.isAnnotationStyleAspect = false;
        this.ensureAspectJAttributesUnpacked();
    }

    public void finishedWith() {
    }

    public WeaverStateInfo getWeaverState() {
        return this.weaverState;
    }

    void setWeaverState(WeaverStateInfo weaverState) {
        this.weaverState = weaverState;
    }

    public void printWackyStuff(PrintStream out) {
        if (this.typeMungers.size() > 0) {
            out.println("  TypeMungers: " + this.typeMungers);
        }
        if (this.declares.size() > 0) {
            out.println("     declares: " + this.declares);
        }
    }

    public LazyClassGen getLazyClassGen() {
        LazyClassGen ret = this.lazyClassGen;
        if (ret == null) {
            ret = new LazyClassGen(this);
            if (this.isAspect()) {
                this.lazyClassGen = ret;
            }
        }
        return ret;
    }

    public boolean isSynthetic() {
        return this.getResolvedTypeX().isSynthetic();
    }

    public AjAttribute.WeaverVersionInfo getWeaverVersionAttribute() {
        return this.wvInfo;
    }

    public void addParent(ResolvedType newParent) {
        this.bitflag |= 0x40;
        if (newParent.isClass()) {
            this.superclassSignature = newParent.getSignature();
            this.superclassName = newParent.getName();
        } else {
            ResolvedType[] oldInterfaceNames = this.getDeclaredInterfaces();
            int exists = -1;
            for (int i = 0; i < oldInterfaceNames.length; ++i) {
                ResolvedType type = oldInterfaceNames[i];
                if (!type.equals(newParent)) continue;
                exists = i;
                break;
            }
            if (exists == -1) {
                int len = this.interfaceSignatures.length;
                String[] newInterfaceSignatures = new String[len + 1];
                System.arraycopy(this.interfaceSignatures, 0, newInterfaceSignatures, 0, len);
                newInterfaceSignatures[len] = newParent.getSignature();
                this.interfaceSignatures = newInterfaceSignatures;
            }
        }
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationsUnpacked();
        return this.annotationTypes;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationsUnpacked();
        return this.annotations;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationsUnpacked();
        for (int i = 0; i < this.annotationTypes.length; ++i) {
            ResolvedType ax = this.annotationTypes[i];
            if (!ax.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    public void addAnnotation(AnnotationX annotation) {
        this.bitflag |= 0x40;
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        len = this.annotationTypes.length;
        ResolvedType[] ret2 = new ResolvedType[len + 1];
        System.arraycopy(this.annotationTypes, 0, ret2, 0, len);
        ret2[len] = this.getResolvedTypeX().getWorld().resolve(UnresolvedType.forName(annotation.getTypeName()));
        this.annotationTypes = ret2;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return this.getRetentionPolicy() == null ? false : this.getRetentionPolicy().equals("RUNTIME");
    }

    public String getRetentionPolicy() {
        if ((this.bitflag & 1) == 0) {
            this.bitflag |= 1;
            this.retentionPolicy = null;
            if (this.isAnnotation()) {
                this.ensureAnnotationsUnpacked();
                for (int i = this.annotations.length - 1; i >= 0; --i) {
                    List values;
                    Iterator it;
                    AnnotationX ax = this.annotations[i];
                    if (!ax.getTypeName().equals(UnresolvedType.AT_RETENTION.getName()) || !(it = (values = ax.getBcelAnnotation().getValues()).iterator()).hasNext()) continue;
                    ElementNameValuePair element = (ElementNameValuePair)it.next();
                    EnumElementValue v = (EnumElementValue)element.getValue();
                    this.retentionPolicy = v.getEnumValueString();
                    return this.retentionPolicy;
                }
            }
        }
        return this.retentionPolicy;
    }

    public boolean canAnnotationTargetType() {
        AnnotationTargetKind[] targetKinds = this.getAnnotationTargetKinds();
        if (targetKinds == null) {
            return true;
        }
        for (int i = 0; i < targetKinds.length; ++i) {
            if (!targetKinds[i].equals(AnnotationTargetKind.TYPE)) continue;
            return true;
        }
        return false;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        if ((this.bitflag & 8) != 0) {
            return this.annotationTargetKinds;
        }
        this.bitflag |= 8;
        this.annotationTargetKinds = null;
        ArrayList<AnnotationTargetKind> targetKinds = new ArrayList<AnnotationTargetKind>();
        if (this.isAnnotation()) {
            AnnotationX[] annotationsOnThisType = this.getAnnotations();
            for (int i = 0; i < annotationsOnThisType.length; ++i) {
                ArrayElementValue arrayValue;
                ElementValue[] evs;
                Annotation a = annotationsOnThisType[i].getBcelAnnotation();
                if (!a.getTypeName().equals(UnresolvedType.AT_TARGET.getName()) || (evs = (arrayValue = (ArrayElementValue)((ElementNameValuePair)a.getValues().get(0)).getValue()).getElementValuesArray()) == null) continue;
                for (int j = 0; j < evs.length; ++j) {
                    String targetKind = ((EnumElementValue)evs[j]).getEnumValueString();
                    if (targetKind.equals("ANNOTATION_TYPE")) {
                        targetKinds.add(AnnotationTargetKind.ANNOTATION_TYPE);
                        continue;
                    }
                    if (targetKind.equals("CONSTRUCTOR")) {
                        targetKinds.add(AnnotationTargetKind.CONSTRUCTOR);
                        continue;
                    }
                    if (targetKind.equals("FIELD")) {
                        targetKinds.add(AnnotationTargetKind.FIELD);
                        continue;
                    }
                    if (targetKind.equals("LOCAL_VARIABLE")) {
                        targetKinds.add(AnnotationTargetKind.LOCAL_VARIABLE);
                        continue;
                    }
                    if (targetKind.equals("METHOD")) {
                        targetKinds.add(AnnotationTargetKind.METHOD);
                        continue;
                    }
                    if (targetKind.equals("PACKAGE")) {
                        targetKinds.add(AnnotationTargetKind.PACKAGE);
                        continue;
                    }
                    if (targetKind.equals("PARAMETER")) {
                        targetKinds.add(AnnotationTargetKind.PARAMETER);
                        continue;
                    }
                    if (!targetKind.equals("TYPE")) continue;
                    targetKinds.add(AnnotationTargetKind.TYPE);
                }
            }
            if (!targetKinds.isEmpty()) {
                this.annotationTargetKinds = new AnnotationTargetKind[targetKinds.size()];
                return targetKinds.toArray(this.annotationTargetKinds);
            }
        }
        return this.annotationTargetKinds;
    }

    private void ensureAnnotationsUnpacked() {
        if (this.annotationTypes == null) {
            Annotation[] annos = this.javaClass.getAnnotations();
            if (annos == null || annos.length == 0) {
                this.annotationTypes = ResolvedType.NONE;
                this.annotations = AnnotationX.NONE;
            } else {
                World w = this.getResolvedTypeX().getWorld();
                this.annotationTypes = new ResolvedType[annos.length];
                this.annotations = new AnnotationX[annos.length];
                for (int i = 0; i < annos.length; ++i) {
                    Annotation annotation = annos[i];
                    this.annotationTypes[i] = w.resolve(UnresolvedType.forSignature(annotation.getTypeSignature()));
                    this.annotations[i] = new AnnotationX(annotation, w);
                }
            }
        }
    }

    public String getDeclaredGenericSignature() {
        this.ensureGenericInfoProcessed();
        return this.declaredSignature;
    }

    private void ensureGenericSignatureUnpacked() {
        if ((this.bitflag & 2) != 0) {
            return;
        }
        this.bitflag |= 2;
        if (!this.getResolvedTypeX().getWorld().isInJava5Mode()) {
            return;
        }
        Signature.ClassSignature cSig = this.getGenericClassTypeSignature();
        if (cSig != null) {
            Signature.FormalTypeParameter[] extraFormals;
            this.formalsForResolution = cSig.formalTypeParameters;
            if (this.isNested() && (extraFormals = this.getFormalTypeParametersFromOuterClass()).length > 0) {
                int i;
                ArrayList<Signature.FormalTypeParameter> allFormals = new ArrayList<Signature.FormalTypeParameter>();
                for (i = 0; i < this.formalsForResolution.length; ++i) {
                    allFormals.add(this.formalsForResolution[i]);
                }
                for (i = 0; i < extraFormals.length; ++i) {
                    allFormals.add(extraFormals[i]);
                }
                this.formalsForResolution = new Signature.FormalTypeParameter[allFormals.size()];
                allFormals.toArray(this.formalsForResolution);
            }
            Signature.ClassTypeSignature superSig = cSig.superclassSignature;
            try {
                ResolvedType rt = BcelGenericSignatureToTypeXConverter.classTypeSignature2TypeX(superSig, this.formalsForResolution, this.getResolvedTypeX().getWorld());
                this.superclassSignature = rt.getSignature();
                this.superclassName = rt.getName();
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                throw new IllegalStateException("While determining the generic superclass of " + this.className + " with generic signature " + this.getDeclaredGenericSignature() + " the following error was detected: " + e.getMessage());
            }
            this.interfaceSignatures = new String[cSig.superInterfaceSignatures.length];
            for (int i = 0; i < cSig.superInterfaceSignatures.length; ++i) {
                try {
                    this.interfaceSignatures[i] = BcelGenericSignatureToTypeXConverter.classTypeSignature2TypeX(cSig.superInterfaceSignatures[i], this.formalsForResolution, this.getResolvedTypeX().getWorld()).getSignature();
                    continue;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While determing the generic superinterfaces of " + this.className + " with generic signature " + this.getDeclaredGenericSignature() + " the following error was detected: " + e.getMessage());
                }
            }
        }
        if (this.isGeneric()) {
            ReferenceType genericType = (ReferenceType)this.resolvedTypeX.getGenericType();
            genericType.setStartPos(this.resolvedTypeX.getStartPos());
            this.resolvedTypeX = genericType;
        }
    }

    public Signature.FormalTypeParameter[] getAllFormals() {
        this.ensureGenericSignatureUnpacked();
        if (this.formalsForResolution == null) {
            return new Signature.FormalTypeParameter[0];
        }
        return this.formalsForResolution;
    }

    public ResolvedType getOuterClass() {
        if (!this.isNested()) {
            throw new IllegalStateException("Can't get the outer class of a non-nested type");
        }
        int lastDollar = this.className.lastIndexOf(36);
        String superClassName = this.className.substring(0, lastDollar);
        UnresolvedType outer = UnresolvedType.forName(superClassName);
        return (ReferenceType)outer.resolve(this.getResolvedTypeX().getWorld());
    }

    private void ensureGenericInfoProcessed() {
        if ((this.bitflag & 0x10) != 0) {
            return;
        }
        this.bitflag |= 0x10;
        Attribute[] as = this.javaClass.getAttributes();
        for (int i = 0; i < as.length && this.declaredSignature == null; ++i) {
            Attribute attribute = as[i];
            if (!(attribute instanceof Signature)) continue;
            this.declaredSignature = ((Signature)attribute).getSignature();
        }
        if (this.declaredSignature != null) {
            this.isGenericType = this.declaredSignature.charAt(0) == '<';
        }
    }

    public boolean isGeneric() {
        this.ensureGenericInfoProcessed();
        return this.isGenericType;
    }

    public String toString() {
        return this.javaClass == null ? "BcelObjectType" : "BcelObjectTypeFor:" + this.className;
    }

    public void evictWeavingState() {
        if (this.getResolvedTypeX().getWorld().couldIncrementalCompileFollow()) {
            return;
        }
        if (this.javaClass != null) {
            int i;
            this.ensureAnnotationsUnpacked();
            this.ensureGenericInfoProcessed();
            this.getDeclaredInterfaces();
            this.getDeclaredFields();
            this.getDeclaredMethods();
            if (this.getResolvedTypeX().getWorld().isXnoInline()) {
                this.lazyClassGen = null;
            }
            if (this.weaverState != null) {
                this.weaverState.setReweavable(false);
                this.weaverState.setUnwovenClassFileData(null);
            }
            for (i = this.methods.length - 1; i >= 0; --i) {
                this.methods[i].evictWeavingState();
            }
            for (i = this.fields.length - 1; i >= 0; --i) {
                this.fields[i].evictWeavingState();
            }
            this.javaClass = null;
        }
    }

    public void weavingCompleted() {
        this.hasBeenWoven = true;
        if (this.getResolvedTypeX().getWorld().isRunMinimalMemory()) {
            this.evictWeavingState();
        }
        if (this.getSourceContext() != null && !this.getResolvedTypeX().isAspect()) {
            this.getSourceContext().tidy();
        }
    }

    public AjAttribute[] getAttributes(String name) {
        ArrayList<AjAttribute> results = new ArrayList<AjAttribute>();
        List l = BcelAttributes.readAjAttributes(this.javaClass.getClassName(), this.javaClass.getAttributes(), this.getResolvedTypeX().getSourceContext(), this.getResolvedTypeX().getWorld(), AjAttribute.WeaverVersionInfo.UNKNOWN);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            AjAttribute element = (AjAttribute)iter.next();
            if (!element.getNameString().equals(name)) continue;
            results.add(element);
        }
        if (results.size() > 0) {
            return results.toArray(new AjAttribute[0]);
        }
        return null;
    }

    public String[] getAttributeNames() {
        Attribute[] as = this.javaClass.getAttributes();
        String[] strs = new String[as.length];
        for (int j = 0; j < as.length; ++j) {
            strs[j] = as[j].getName();
        }
        return strs;
    }

    public void addPointcutDefinition(ResolvedPointcutDefinition d) {
        this.bitflag |= 0x40;
        int len = this.pointcuts.length;
        ResolvedPointcutDefinition[] ret = new ResolvedPointcutDefinition[len + 1];
        System.arraycopy(this.pointcuts, 0, ret, 0, len);
        ret[len] = d;
        this.pointcuts = ret;
    }

    public boolean hasBeenWoven() {
        return this.hasBeenWoven;
    }
}

