/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.server.ClientSession;

public class SessionEventManager
implements Cloneable,
Serializable {
    protected Vector listeners = NonSynchronizedVector.newInstance();
    protected Session session;

    public SessionEventManager() {
    }

    public SessionEventManager(Session session) {
        this.session = session;
    }

    public void addListener(SessionEventListener listener) {
        this.getListeners().addElement(listener);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return new InternalError(exception.toString());
        }
    }

    public SessionEventManager clone(Session newSession) {
        SessionEventManager newManager = (SessionEventManager)this.clone();
        newManager.setSession(newSession);
        if (this.listeners != null) {
            newManager.setListeners(new NonSynchronizedVector((Collection)this.listeners));
        }
        return newManager;
    }

    public Vector getListeners() {
        if (this.listeners == null) {
            this.listeners = NonSynchronizedVector.newInstance();
        }
        return this.listeners;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void missingDescriptor(Class missingClass) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(32, this.getSession());
        event.setResult(missingClass);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).missingDescriptor(event);
        }
        this.endOperationProfile();
    }

    public void moreRowsDetected(DatabaseCall call) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(20, this.getSession());
        event.setResult(call);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).moreRowsDetected(event);
        }
        this.endOperationProfile();
    }

    public void noRowsModified(ModifyQuery query, Object object) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(35, this.getSession());
        event.setQuery(query);
        event.setResult(object);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).noRowsModified(event);
        }
        this.endOperationProfile();
    }

    public void outputParametersDetected(Record outputRow, DatasourceCall call) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(19, this.getSession());
        event.setResult(outputRow);
        event.setProperty("call", call);
        event.setQuery(call.getQuery());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).outputParametersDetected(event);
        }
        this.endOperationProfile();
    }

    public void postAcquireClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(16, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postAcquireClientSession(event);
        }
        this.endOperationProfile();
    }

    public void postAcquireConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(22, this.getSession());
        event.setResult(accessor);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postAcquireConnection(event);
        }
        this.endOperationProfile();
    }

    public void postAcquireExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent event = new SessionEvent(33, clientSession);
        event.setResult(accessor);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postAcquireExclusiveConnection(event);
        }
    }

    public void postAcquireUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(9, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postAcquireUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(4, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postBeginTransaction(event);
        }
        this.endOperationProfile();
    }

    public void postCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(6, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postCommitTransaction(event);
        }
        this.endOperationProfile();
    }

    public void postCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(11, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postCommitUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postConnect(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(21, this.getSession());
        event.setResult(accessor);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postConnect(event);
        }
        this.endOperationProfile();
    }

    public void postExecuteQuery(DatabaseQuery query, Object result) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(2, this.getSession());
        event.setQuery(query);
        event.setResult(result);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postExecuteQuery(event);
        }
        this.endOperationProfile();
    }

    public void postReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(18, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postReleaseClientSession(event);
        }
        this.endOperationProfile();
    }

    public void postReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(13, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postReleaseUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postResumeUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(15, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postResumeUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(8, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postRollbackTransaction(event);
        }
        this.endOperationProfile();
    }

    public void postDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(29, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postDistributedMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void postMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(28, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void preBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(3, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preBeginTransaction(event);
        }
        this.endOperationProfile();
    }

    public void preCalculateUnitOfWorkChangeSet() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(30, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preCalculateUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void postCalculateUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(31, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postCalculateUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void preCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(5, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preCommitTransaction(event);
        }
        this.endOperationProfile();
    }

    public void preCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(10, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preCommitUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void preExecuteQuery(DatabaseQuery query) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(1, this.getSession());
        event.setQuery(query);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preExecuteQuery(event);
        }
        this.endOperationProfile();
    }

    public void preLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(24, session);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preLogin(event);
        }
        this.endOperationProfile();
    }

    public void postLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(25, session);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).postLogin(event);
        }
        this.endOperationProfile();
    }

    public void prepareUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(14, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).prepareUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void preReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(17, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preReleaseClientSession(event);
        }
        this.endOperationProfile();
    }

    public void preReleaseConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(23, this.getSession());
        event.setResult(accessor);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preReleaseConnection(event);
        }
        this.endOperationProfile();
    }

    public void preReleaseExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent event = new SessionEvent(34, clientSession);
        event.setResult(accessor);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preReleaseExclusiveConnection(event);
        }
    }

    public void preReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(12, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preReleaseUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void preRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(7, this.getSession());
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preRollbackTransaction(event);
        }
        this.endOperationProfile();
    }

    public void preDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(27, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preDistributedMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void preMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(26, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        Enumeration listenerEnum = this.getListeners().elements();
        while (listenerEnum.hasMoreElements()) {
            ((SessionEventListener)listenerEnum.nextElement()).preMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void removeListener(SessionEventListener listener) {
        this.getListeners().removeElement(listener);
    }

    protected void setListeners(Vector listeners) {
        this.listeners = listeners;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void startOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().startOperationProfile("SessionEvents");
        }
    }

    protected void endOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().endOperationProfile("SessionEvents");
        }
    }
}

