/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;

public class SDOTypeHelperDelegator
implements SDOTypeHelper {
    private Map sdoTypeHelperDelegates;
    private HelperContext aHelperContext;

    public SDOTypeHelperDelegator() {
        this.sdoTypeHelperDelegates = new WeakHashMap();
    }

    public SDOTypeHelperDelegator(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.sdoTypeHelperDelegates = new WeakHashMap();
    }

    public Class getJavaWrapperTypeForSDOType(Type sdoType) {
        return this.getSDOTypeHelperDelegate().getJavaWrapperTypeForSDOType(sdoType);
    }

    public Type getType(String uri, String typeName) {
        return this.getSDOTypeHelperDelegate().getType(uri, typeName);
    }

    public Type getTypeForSimpleJavaType(Class implClass) {
        return this.getSDOTypeHelperDelegate().getTypeForSimpleJavaType(implClass);
    }

    public void addType(SDOType newType) {
        this.getSDOTypeHelperDelegate().addType(newType);
    }

    public Type getType(Class interfaceClass) {
        return this.getSDOTypeHelperDelegate().getType(interfaceClass);
    }

    public Type define(DataObject dataObject) {
        return this.getSDOTypeHelperDelegate().define(dataObject);
    }

    public List define(List types) {
        return this.getSDOTypeHelperDelegate().define(types);
    }

    public QName getXSDTypeFromSDOType(Type aType) {
        return this.getSDOTypeHelperDelegate().getXSDTypeFromSDOType(aType);
    }

    public SDOType getSDOTypeFromXSDType(QName aName) {
        return this.getSDOTypeHelperDelegate().getSDOTypeFromXSDType(aName);
    }

    public void setTypesHashMap(Map typesHashMap) {
        this.getSDOTypeHelperDelegate().setTypesHashMap(typesHashMap);
    }

    public Map getTypesHashMap() {
        return this.getSDOTypeHelperDelegate().getTypesHashMap();
    }

    public void reset() {
        this.getSDOTypeHelperDelegate().reset();
    }

    public Property defineOpenContentProperty(String uri, DataObject property) {
        return this.getSDOTypeHelperDelegate().defineOpenContentProperty(uri, property);
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        return this.getSDOTypeHelperDelegate().getOpenContentProperty(uri, propertyName);
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader.getParent() != null && classLoader.toString().indexOf(".wrappers") != -1) {
            AbstractSessionLog.getLog().log(1, "{0} matched classLoader: {1} to parent cl: {2}", new Object[]{this.getClass().getName(), classLoader.toString(), classLoader.getParent().toString()}, false);
            classLoader = classLoader.getParent();
        } else if (classLoader.getParent() != null && classLoader.toString().indexOf(".web.") != -1) {
            AbstractSessionLog.getLog().log(1, "{0} matched classLoader: {1} to parent cl: {2}", new Object[]{this.getClass().getName(), classLoader.toString(), classLoader.getParent().toString()}, false);
            classLoader = classLoader.getParent();
        }
        return classLoader;
    }

    private SDOTypeHelperDelegate getSDOTypeHelperDelegate() {
        ClassLoader contextClassLoader = this.getContextClassLoader();
        SDOTypeHelperDelegate sdoTypeHelperDelegate = (SDOTypeHelperDelegate)this.sdoTypeHelperDelegates.get(contextClassLoader);
        if (null == sdoTypeHelperDelegate) {
            sdoTypeHelperDelegate = new SDOTypeHelperDelegate(this.getHelperContext());
            this.sdoTypeHelperDelegates.put(contextClassLoader, sdoTypeHelperDelegate);
            AbstractSessionLog.getLog().log(1, "{0} creating new {1} keyed on classLoader: {2}", new Object[]{this.getClass().getName(), sdoTypeHelperDelegate, contextClassLoader.toString()}, false);
        }
        return sdoTypeHelperDelegate;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public String addNamespace(String prefix, String uri) {
        return this.getSDOTypeHelperDelegate().addNamespace(prefix, uri);
    }

    public String getPrefix(String uri) {
        return this.getSDOTypeHelperDelegate().getPrefix(uri);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getSDOTypeHelperDelegate().getNamespaceResolver();
    }

    public Map getOpenContentProperties() {
        return this.getSDOTypeHelperDelegate().getOpenContentProperties();
    }
}

