/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.osgi;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.JavaSECMPInitializer;
import org.eclipse.persistence.internal.jpa.OSGiInitializer;
import org.eclipse.persistence.internal.jpa.PersistenceInitializationActivator;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.osgi.framework.Bundle;

public class PersistenceProvider
implements javax.persistence.spi.PersistenceProvider,
PersistenceInitializationActivator {
    private static Map<String, Bundle> puToBundle = Collections.synchronizedMap(new HashMap());
    private static Map<Bundle, String[]> bundleToPUs = Collections.synchronizedMap(new HashMap());

    public static void addBundle(Bundle bundle, String[] persistenceUnitNames) {
        for (int i = 0; i < persistenceUnitNames.length; ++i) {
            String name = persistenceUnitNames[i];
            puToBundle.put(name, bundle);
        }
        bundleToPUs.put(bundle, persistenceUnitNames);
    }

    public static void removeBundle(Bundle bundle) {
        String[] persistenceUnitNames = bundleToPUs.remove(bundle);
        if (persistenceUnitNames != null) {
            for (int i = 0; i < persistenceUnitNames.length; ++i) {
                String name = persistenceUnitNames[i];
                puToBundle.remove(name);
            }
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        ClassLoader classloader = this.getClassLoader(emName, properties);
        return this.createEntityManagerFactory(emName, properties, classloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties, ClassLoader classLoader) {
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        String name = emName;
        if (name == null) {
            name = "";
        }
        if (classLoader == null) {
            throw new RuntimeException("EntityManager creation requires a classloader");
        }
        OSGiInitializer initializer = new OSGiInitializer(classLoader);
        EntityManagerSetupImpl emSetupImpl = null;
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/persistence.xml");
            boolean initialized = false;
            while (resources.hasMoreElements()) {
                String puName = PersistenceUnitProcessor.buildPersistenceUnitName(PersistenceUnitProcessor.computePURootURL(resources.nextElement()), name);
                HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
                synchronized (hashMap) {
                    emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(puName);
                    if (emSetupImpl == null || emSetupImpl.isUndeployed()) {
                        if (!initialized) {
                            initializer.initialize(nonNullProperties, this);
                            initialized = true;
                        }
                        emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(puName);
                    }
                }
                if (emSetupImpl == null) continue;
                break;
            }
        }
        catch (Exception e) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(classLoader, e);
        }
        if (emSetupImpl == null) {
            return null;
        }
        if (!this.isPersistenceProviderSupported(emSetupImpl.getPersistenceUnitInfo().getPersistenceProviderClassName())) {
            return null;
        }
        EntityManagerSetupImpl e = emSetupImpl;
        synchronized (e) {
            if (emSetupImpl.shouldRedeploy()) {
                SEPersistenceUnitInfo persistenceInfo = (SEPersistenceUnitInfo)emSetupImpl.getPersistenceUnitInfo();
                persistenceInfo.setClassLoader(classLoader);
                if (emSetupImpl.isUndeployed()) {
                    persistenceInfo.setNewTempClassLoader(JavaSECMPInitializer.getMainLoader());
                }
            }
            emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
                factory.getServerSession();
            }
            return factory;
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
    }

    private ClassLoader getClassLoader(String emName, Map properties) {
        ClassLoader bundleClassLoader = null;
        if (properties != null) {
            bundleClassLoader = (ClassLoader)properties.get("eclipselink.classloader");
        }
        if (bundleClassLoader == null) {
            Bundle bundle = puToBundle.get(emName);
            if (bundle == null) {
                throw new RuntimeException("Bundle providing Persistence Unit '" + emName + "' not found.");
            }
            bundleClassLoader = PersistenceProvider.getBundleClassLoader(bundle);
        }
        return bundleClassLoader;
    }

    public static ClassLoader getBundleClassLoader(Bundle bundle) {
        Class loadClass = null;
        try {
            String activatorClassName = (String)bundle.getHeaders().get("Bundle-Activator");
            if (activatorClassName == null) {
                throw new RuntimeException("Bundle Activator Class not specified!");
            }
            loadClass = bundle.loadClass(activatorClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain class loader from bundle");
        }
        ClassLoader classLoader = loadClass.getClassLoader();
        return classLoader;
    }

    public boolean isPersistenceProviderSupported(String providerClassName) {
        return providerClassName == null || providerClassName.equals("") || providerClassName.equals(PersistenceProvider.class.getName());
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        throw new RuntimeException("createContainerEntityManagerFactory not supported in OSGi");
    }
}

