/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.osgi;

import java.util.Hashtable;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static BundleContext context;
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    public static final String ECLIPSELINK_OSGI_PROVIDER = "org.eclipse.persistence.jpa.osgi.PersistenceProviderOSGi";

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                this.registerBundle(event.getBundle());
                break;
            }
            case 256: {
                System.out.println("Bundle stopping: " + event.getBundle());
                this.deregisterBundle(event.getBundle());
            }
        }
    }

    private void printEventName(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                System.out.print("INSTALLED");
                break;
            }
            case 512: {
                System.out.print("LAZY_ACTIVATION");
                break;
            }
            case 32: {
                System.out.print("RESOLVED");
                break;
            }
            case 2: {
                System.out.print("STARTED");
                break;
            }
            case 128: {
                System.out.print("STARTING");
                break;
            }
            case 4: {
                System.out.print("STOPPED");
                break;
            }
            case 256: {
                System.out.print("STOPPING");
                break;
            }
            case 16: {
                System.out.print("UNINSTALLED");
                break;
            }
            case 64: {
                System.out.print("UNRESOLVED");
                break;
            }
            case 8: {
                System.out.print("UPDATED");
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        System.out.println("Starting EclipseLink bundle...");
        Activator.context = context;
        this.registerBundleListener();
        this.registerProviderService();
    }

    private void registerBundleListener() {
        Activator.getContext().addBundleListener((BundleListener)this);
        Bundle[] bundles = Activator.getContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            this.registerBundle(bundle);
        }
    }

    private void registerBundle(Bundle bundle) {
        if ((bundle.getState() & 0x28) != 0) {
            try {
                String[] persistenceUnitNames = this.getPersistenceUnitNames(bundle);
                if (persistenceUnitNames != null) {
                    PersistenceProvider.addBundle(bundle, persistenceUnitNames);
                }
            }
            catch (Exception e) {
                System.out.println("Exception caught processing bundle: " + e);
                e.printStackTrace();
            }
        }
    }

    private String[] getPersistenceUnitNames(Bundle bundle) {
        String names = (String)bundle.getHeaders().get("JPA-PersistenceUnits");
        if (names != null) {
            return names.split(",");
        }
        return null;
    }

    private void deregisterBundle(Bundle bundle) {
        PersistenceProvider.removeBundle(bundle);
    }

    public void stop(BundleContext context) throws Exception {
        Activator.getContext().removeBundleListener((BundleListener)this);
    }

    public static BundleContext getContext() {
        return context;
    }

    public void registerProviderService() throws Exception {
        PersistenceProvider providerService = new PersistenceProvider();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(PERSISTENCE_PROVIDER, ECLIPSELINK_OSGI_PROVIDER);
        Activator.getContext().registerService(PERSISTENCE_PROVIDER, (Object)providerService, props);
    }
}

