/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.linkedlist.LinkedNode;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class MergeManager {
    protected AbstractSession session;
    protected Map objectDescriptors;
    protected Map objectsAlreadyMerged;
    protected IdentityHashMap mergedNewObjects;
    protected ArrayList acquiredLocks;
    protected CacheKey writeLockQueued;
    protected LinkedNode queueNode;
    protected int mergePolicy;
    protected static final int WORKING_COPY_INTO_ORIGINAL = 1;
    protected static final int ORIGINAL_INTO_WORKING_COPY = 2;
    protected static final int CLONE_INTO_WORKING_COPY = 3;
    protected static final int WORKING_COPY_INTO_REMOTE = 4;
    protected static final int REFRESH_REMOTE_OBJECT = 5;
    protected static final int CHANGES_INTO_DISTRIBUTED_CACHE = 6;
    protected static final int CLONE_WITH_REFS_INTO_WORKING_COPY = 7;
    protected int cascadePolicy;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;
    public static final int CASCADE_BY_MAPPING = 4;
    public static boolean LOCK_ON_MERGE = true;
    protected long systemTime = 0L;
    protected boolean forceCascade;

    public MergeManager(AbstractSession session) {
        this.session = session;
        this.mergedNewObjects = new IdentityHashMap();
        this.objectsAlreadyMerged = new IdentityHashMap();
        this.cascadePolicy = 3;
        this.mergePolicy = 1;
        this.acquiredLocks = new ArrayList();
    }

    protected Map buildIdentitySet(Object container, ContainerPolicy containerPolicy, boolean keyByTarget) {
        IdentityHashMap<Object, Object> result = new IdentityHashMap<Object, Object>(containerPolicy.sizeFor(container) + 1);
        Object iter = containerPolicy.iteratorFor(container);
        while (containerPolicy.hasNext(iter)) {
            Object element = containerPolicy.next(iter, this.getSession());
            if (keyByTarget) {
                result.put(this.getTargetVersionOfSourceObject(element), element);
                continue;
            }
            result.put(element, element);
        }
        return result;
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public ArrayList getAcquiredLocks() {
        return this.acquiredLocks;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    protected int getMergePolicy() {
        return this.mergePolicy;
    }

    public Map getObjectDescriptors() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = new IdentityHashMap();
        }
        return this.objectDescriptors;
    }

    public Map getObjectsAlreadyMerged() {
        return this.objectsAlreadyMerged;
    }

    public Object getObjectToMerge(Object sourceValue) {
        if (this.shouldMergeOriginalIntoWorkingCopy()) {
            return this.getTargetVersionOfSourceObject(sourceValue);
        }
        return sourceValue;
    }

    public LinkedNode getQueueNode() {
        return this.queueNode;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public long getSystemTime() {
        if (this.systemTime == 0L) {
            this.systemTime = System.currentTimeMillis();
        }
        return this.systemTime;
    }

    public Object getTargetVersionOfSourceObject(Object source) {
        if (this.shouldMergeWorkingCopyIntoOriginal() || this.shouldMergeWorkingCopyIntoRemote()) {
            return ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(source);
        }
        if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeOriginalIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            return this.registerObjectForMergeCloneIntoWorkingCopy(source);
        }
        if (this.shouldRefreshRemoteObject()) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(source);
            Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(source, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, source.getClass(), descriptor);
        }
        throw ValidationException.invalidMergePolicy();
    }

    public CacheKey getWriteLockQueued() {
        return this.writeLockQueued;
    }

    public Object mergeChanges(Object object, ObjectChangeSet objectChangeSet) throws ValidationException {
        Object mergedObject;
        if (object == null) {
            return object;
        }
        if (this.getSession().isClassReadOnly(object.getClass())) {
            return object;
        }
        if (this.getObjectsAlreadyMerged().containsKey(object)) {
            return object;
        }
        this.getObjectsAlreadyMerged().put(object, object);
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            mergedObject = this.mergeChangesOfWorkingCopyIntoOriginal(object, objectChangeSet);
        } else if (this.shouldMergeChangesIntoDistributedCache()) {
            mergedObject = this.mergeChangesIntoDistributedCache(object, objectChangeSet);
        } else if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            mergedObject = this.mergeChangesOfCloneIntoWorkingCopy(object);
        } else if (this.shouldMergeOriginalIntoWorkingCopy()) {
            mergedObject = this.mergeChangesOfOriginalIntoWorkingCopy(object);
        } else if (this.shouldMergeWorkingCopyIntoRemote()) {
            mergedObject = this.mergeChangesOfWorkingCopyIntoRemote(object);
        } else if (this.shouldRefreshRemoteObject()) {
            mergedObject = this.mergeChangesForRefreshingRemoteObject(object);
        } else {
            throw ValidationException.invalidMergePolicy();
        }
        return mergedObject;
    }

    protected Object mergeChangesForRefreshingRemoteObject(Object serverSideDomainObject) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(serverSideDomainObject);
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(serverSideDomainObject, this.getSession());
        Object clientSideDomainObject = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, serverSideDomainObject.getClass(), descriptor);
        if (clientSideDomainObject == null) {
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.getObjectDescriptors().get(serverSideDomainObject);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(primaryKey);
                objectDescriptor.setObject(serverSideDomainObject);
                OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                if (policy == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(policy.getBaseValue());
                }
            }
            ReadObjectQuery query = new ReadObjectQuery();
            query.setCascadePolicy(this.getCascadePolicy());
            this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(serverSideDomainObject, primaryKey, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), descriptor);
            descriptor.getObjectBuilder().fixObjectReferences(serverSideDomainObject, this.getObjectDescriptors(), this.getObjectsAlreadyMerged(), query, (RemoteSession)this.getSession());
            clientSideDomainObject = serverSideDomainObject;
        } else {
            CacheKey key;
            descriptor.getObjectBuilder().mergeIntoObject(clientSideDomainObject, false, serverSideDomainObject, this);
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.getObjectDescriptors().get(serverSideDomainObject);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(primaryKey);
                objectDescriptor.setObject(serverSideDomainObject);
                OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                if (policy == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(policy.getBaseValue());
                }
            }
            if ((key = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, clientSideDomainObject.getClass(), descriptor)) != null) {
                key.setReadTime(objectDescriptor.getReadTime());
            }
            if (descriptor.usesOptimisticLocking()) {
                this.getSession().getIdentityMapAccessor().updateWriteLockValue(primaryKey, clientSideDomainObject.getClass(), objectDescriptor.getWriteLockValue());
            }
        }
        return clientSideDomainObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesFromChangeSet(UnitOfWorkChangeSet uowChangeSet) {
        this.getSession().startOperationProfile("distributed merge");
        this.getSession().getIdentityMapAccessorInstance().acquireWriteLock();
        this.getSession().log(2, "propagation", "received_updates_from_remote_server");
        this.getSession().getEventManager().preDistributedMergeUnitOfWorkChangeSet(uowChangeSet);
        try {
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this, uowChangeSet);
            for (ObjectChangeSet objectChangeSet : uowChangeSet.getAllChangeSets().keySet()) {
                Object object = objectChangeSet.getTargetVersionOfSourceObject(this.getSession(), false);
                Object mergedObject = this.mergeChanges(object, objectChangeSet);
                if (mergedObject == null && objectChangeSet.isNew()) {
                    mergedObject = this.mergeNewObjectIntoCache(objectChangeSet);
                }
                if (mergedObject == null) {
                    this.getSession().incrementProfile("ChangesNotProcessed");
                    continue;
                }
                this.getSession().incrementProfile("ChangesProcessed");
            }
            for (ObjectChangeSet changeSet : uowChangeSet.getDeletedObjects().values()) {
                changeSet.removeFromIdentityMap(this.getSession());
                this.getSession().incrementProfile("deleted object");
            }
        }
        catch (RuntimeException exception) {
            this.getSession().handleException(exception);
        }
        finally {
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
            this.getSession().getIdentityMapAccessorInstance().releaseWriteLock();
            this.getSession().getEventManager().postDistributedMergeUnitOfWorkChangeSet(uowChangeSet);
            this.getSession().endOperationProfile("distributed merge");
        }
    }

    public boolean mergeChangesInCollection(Object source, Object target, Object backup, DatabaseMapping mapping) {
        ContainerPolicy containerPolicy = mapping.getContainerPolicy();
        Map backupSet = this.buildIdentitySet(backup, containerPolicy, false);
        Map sourceSet = null;
        Map targetToSources = null;
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            sourceSet = this.buildIdentitySet(source, containerPolicy, false);
        } else {
            targetToSources = this.buildIdentitySet(source, containerPolicy, true);
        }
        boolean changeOccured = false;
        if (backup == target) {
            backup = containerPolicy.cloneFor(backup);
        }
        Object backupIter = containerPolicy.iteratorFor(backup);
        while (containerPolicy.hasNext(backupIter)) {
            Object backupElement = containerPolicy.next(backupIter, this.getSession());
            if (this.shouldMergeWorkingCopyIntoOriginal()) {
                if (sourceSet.containsKey(backupElement)) continue;
                changeOccured = true;
                containerPolicy.removeFrom(null, this.getTargetVersionOfSourceObject(backupElement), target, this.getSession());
                if (!mapping.isPrivateOwned()) continue;
                this.registerRemovedNewObjectIfRequired(backupElement);
                continue;
            }
            if (targetToSources.containsKey(backupElement)) continue;
            changeOccured = true;
            containerPolicy.removeFrom(null, backupElement, target, this.getSession());
        }
        Object sourceIter = containerPolicy.iteratorFor(source);
        while (containerPolicy.hasNext(sourceIter)) {
            Object sourceElement = containerPolicy.next(sourceIter, this.getSession());
            mapping.cascadeMerge(sourceElement, this);
            if (this.shouldMergeWorkingCopyIntoOriginal()) {
                if (!backupSet.containsKey(sourceElement)) {
                    changeOccured = true;
                    containerPolicy.addInto(this.getTargetVersionOfSourceObject(sourceElement), target, this.getSession());
                    continue;
                }
                containerPolicy.validateElementAndRehashIfRequired(sourceElement, target, this.getSession(), this.getTargetVersionOfSourceObject(sourceElement));
                continue;
            }
            Object targetVersionOfSourceElement = this.getTargetVersionOfSourceObject(sourceElement);
            if (backupSet.containsKey(targetVersionOfSourceElement)) continue;
            changeOccured = true;
            containerPolicy.addInto(targetVersionOfSourceElement, target, this.getSession());
        }
        return changeOccured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesIntoDistributedCache(Object original, ObjectChangeSet changeSet) {
        AbstractSession session = this.getSession();
        Class localClassType = changeSet.getClassType(session);
        ClassDescriptor descriptor = session.getDescriptor(localClassType);
        if (changeSet.getSynchronizationType() == 2) {
            this.getSession().getIdentityMapAccessorInstance().invalidateObject(changeSet.getPrimaryKeys(), localClassType);
            return original;
        }
        if (original != null && descriptor.usesOptimisticLocking()) {
            int difference;
            if (session.getCommandManager() != null && session.getCommandManager().getCommandConverter() != null) {
                changeSet.rebuildWriteLockValueFromUserFormat(descriptor, session);
            }
            if ((difference = descriptor.getOptimisticLockingPolicy().getVersionDifference(changeSet.getWriteLockValue(), original, changeSet.getPrimaryKeys(), session)) < 0) {
                this.getSession().log(1, "propagation", "change_from_remote_server_older_than_current_version", changeSet.getClassName(), changeSet.getPrimaryKeys());
                return original;
            }
            if (difference > 1) {
                this.getSession().log(1, "propagation", "current_version_much_older_than_change_from_remote_server", changeSet.getClassName(), changeSet.getPrimaryKeys());
                session.refreshObject(original);
                return original;
            }
        }
        this.getSession().log(1, "propagation", "Merging_from_remote_server", changeSet.getClassName(), changeSet.getPrimaryKeys());
        if (changeSet.getSynchronizationType() != 4) {
            descriptor.getObjectBuilder().mergeChangesIntoObject(original, changeSet, null, this);
            Vector primaryKey = changeSet.getPrimaryKeys();
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().acquireLock(primaryKey, original.getClass(), descriptor);
            try {
                if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy().isChildWriteLockValueGreater(session, primaryKey, original.getClass(), changeSet)) {
                    cacheKey.setWriteLockValue(changeSet.getWriteLockValue());
                }
                cacheKey.setObject(original);
                if (descriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate()) {
                    cacheKey.setReadTime(this.getSystemTime());
                }
            }
            finally {
                cacheKey.updateAccess();
                cacheKey.release();
            }
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfCloneIntoWorkingCopy(Object rmiClone) {
        Object registeredObject = this.registerObjectForMergeCloneIntoWorkingCopy(rmiClone);
        if (registeredObject == rmiClone && !this.shouldForceCascade()) {
            return rmiClone;
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(rmiClone);
        try {
            Object currentValue;
            VersionLockingPolicy policy;
            ObjectBuilder builder = descriptor.getObjectBuilder();
            if (registeredObject != rmiClone && descriptor.usesVersionLocking() && !this.mergedNewObjects.containsKey(registeredObject) && (policy = (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy()).isStoredInObject() && policy.isNewerVersion(currentValue = builder.extractValueFromObjectForField(registeredObject, policy.getWriteLockField(), this.session), rmiClone, this.session.keyFromObject(rmiClone), this.session)) {
                throw OptimisticLockException.objectChangedSinceLastMerge(rmiClone);
            }
            descriptor.getObjectChangePolicy().dissableEventProcessing(registeredObject);
            boolean cascadeOnly = false;
            if (registeredObject == rmiClone) {
                cascadeOnly = true;
            }
            builder.mergeIntoObject(registeredObject, false, rmiClone, this, cascadeOnly);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(registeredObject);
        }
        return registeredObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfOriginalIntoWorkingCopy(Object clone) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(clone);
        Object original = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObjectOrNull(clone, descriptor);
        if (original == null) {
            return clone;
        }
        descriptor.getObjectChangePolicy().dissableEventProcessing(clone);
        try {
            descriptor.getObjectBuilder().mergeIntoObject(clone, false, original, this);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(clone);
        }
        descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, (UnitOfWorkImpl)this.getSession(), ((UnitOfWorkImpl)this.getSession()).getCloneMapping());
        Vector primaryKey = this.getSession().keyFromObject(clone);
        if (descriptor.usesOptimisticLocking()) {
            descriptor.getOptimisticLockingPolicy().mergeIntoParentCache((UnitOfWorkImpl)this.getSession(), primaryKey, clone);
        }
        CacheKey parentCacheKey = ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, clone.getClass(), descriptor);
        CacheKey uowCacheKey = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, clone.getClass(), descriptor);
        if (parentCacheKey != null && uowCacheKey != null) {
            uowCacheKey.setReadTime(parentCacheKey.getReadTime());
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfWorkingCopyIntoOriginal(Object clone, ObjectChangeSet objectChangeSet) {
        Object originalNewObject;
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
        AbstractSession parent = unitOfWork.getParent();
        boolean requiresToRegisterInParent = false;
        if (unitOfWork.isNestedUnitOfWork() && (originalNewObject = unitOfWork.getOriginalVersionOfNewObject(clone)) != null && !((UnitOfWorkImpl)parent).isCloneNewObject(originalNewObject) && !unitOfWork.isUnregisteredNewObjectInParent(originalNewObject)) {
            requiresToRegisterInParent = true;
        }
        ClassDescriptor descriptor = unitOfWork.getDescriptor(clone.getClass());
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object original = unitOfWork.getOriginalVersionOfObjectOrNull(clone, objectChangeSet, descriptor);
        try {
            if (original == null) {
                original = unitOfWork.buildOriginal(clone);
                if (objectChangeSet == null) {
                    objectBuilder.mergeIntoObject(original, true, clone, this);
                } else if (!objectChangeSet.isNew()) {
                    original = parent.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(objectChangeSet.getPrimaryKeys(), original, descriptor, this, parent);
                    objectBuilder.mergeIntoObject(original, true, clone, this);
                } else {
                    objectBuilder.mergeChangesIntoObject(original, objectChangeSet, clone, this);
                    objectBuilder.clearPrimaryKey(original);
                }
            } else if (objectChangeSet == null) {
                objectBuilder.mergeIntoObject(original, false, clone, this);
            } else {
                if (!objectChangeSet.isNew()) {
                    if (objectChangeSet.shouldInvalidateObject(original, parent)) {
                        parent.getIdentityMapAccessor().invalidateObject(original);
                        return clone;
                    }
                } else {
                    objectBuilder.clearPrimaryKey(original);
                }
                objectBuilder.mergeChangesIntoObject(original, objectChangeSet, clone, this);
            }
        }
        catch (QueryException exception) {
            if (unitOfWork.shouldPerformNoValidation() || descriptor.hasWrapperPolicy()) {
                if (exception.getErrorCode() != 6066 && exception.getErrorCode() != 6004 && exception.getErrorCode() != 6005) {
                    throw exception;
                }
                return clone;
            }
            throw exception;
        }
        if (requiresToRegisterInParent) {
            Object backupClone = objectBuilder.buildNewInstance();
            Object newInstance = objectBuilder.buildNewInstance();
            ((UnitOfWorkImpl)parent).registerOriginalNewObjectFromNestedUnitOfWork(original, backupClone, newInstance, descriptor);
        }
        if (!unitOfWork.isNestedUnitOfWork()) {
            CacheKey cacheKey = null;
            if (objectChangeSet != null) {
                cacheKey = objectChangeSet.getActiveCacheKey();
            }
            boolean locked = false;
            if (cacheKey == null || !cacheKey.isAcquired()) {
                Vector primaryKey = objectBuilder.extractPrimaryKeyFromObject(original, unitOfWork);
                cacheKey = parent.getIdentityMapAccessorInstance().acquireLock(primaryKey, original.getClass(), descriptor);
                locked = true;
            }
            try {
                if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy().isStoredInCache()) {
                    cacheKey.setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(clone));
                }
                cacheKey.setObject(original);
                if (descriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate() || objectChangeSet != null && objectChangeSet.isNew()) {
                    cacheKey.setReadTime(this.getSystemTime());
                }
                cacheKey.updateAccess();
            }
            finally {
                if (locked) {
                    cacheKey.release();
                }
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mergeChangesOfWorkingCopyIntoRemote(Object clone) throws ValidationException {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
        Object original = unitOfWork.getOriginalVersionOfObject(clone);
        ClassDescriptor descriptor = unitOfWork.getDescriptor(clone);
        descriptor.getObjectBuilder().mergeIntoObject(original, false, clone, this);
        if (((RemoteUnitOfWork)unitOfWork.getParent()).getUnregisteredNewObjectsCache().contains(original)) {
            Object backupClone = descriptor.getObjectBuilder().buildNewInstance();
            Object newInstance = descriptor.getObjectBuilder().buildNewInstance();
            ((UnitOfWorkImpl)unitOfWork.getParent()).registerOriginalNewObjectFromNestedUnitOfWork(original, backupClone, newInstance, descriptor);
        }
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, unitOfWork);
        CacheKey cacheKey = unitOfWork.getParent().getIdentityMapAccessorInstance().acquireLock(primaryKey, original.getClass(), descriptor);
        try {
            if (descriptor.usesOptimisticLocking()) {
                cacheKey.setObject(original);
                cacheKey.setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(original));
            } else {
                cacheKey.setObject(original);
            }
        }
        finally {
            cacheKey.updateAccess();
            cacheKey.release();
        }
        return clone;
    }

    public void mergeCloneIntoWorkingCopy() {
        this.setMergePolicy(3);
    }

    public void mergeCloneWithReferencesIntoWorkingCopy() {
        this.setMergePolicy(7);
    }

    public void mergeIntoDistributedCache() {
        this.setMergePolicy(6);
    }

    public Object mergeNewObjectIntoCache(ObjectChangeSet changeSet) {
        if (changeSet.isNew()) {
            Class objectClass = changeSet.getClassType(this.session);
            ClassDescriptor descriptor = this.getSession().getDescriptor(objectClass);
            Object object = changeSet.getTargetVersionOfSourceObject(this.getSession(), false);
            if (object == null) {
                if (!this.getObjectsAlreadyMerged().containsKey(changeSet)) {
                    object = descriptor.getObjectBuilder().buildNewInstance();
                    this.getObjectsAlreadyMerged().put(changeSet, object);
                } else {
                    object = this.getObjectsAlreadyMerged().get(changeSet);
                }
            } else {
                object = changeSet.getTargetVersionOfSourceObject(this.getSession(), true);
            }
            this.mergeChanges(object, changeSet);
            Object implementation = descriptor.getObjectBuilder().unwrapObject(object, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(implementation, descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implementation, this.getSession()), changeSet.getWriteLockValue(), this.getSystemTime(), descriptor);
        }
        return null;
    }

    public void mergeOriginalIntoWorkingCopy() {
        this.setMergePolicy(2);
    }

    public void mergeWorkingCopyIntoOriginal() {
        this.setMergePolicy(1);
    }

    public void mergeWorkingCopyIntoRemote() {
        this.setMergePolicy(4);
    }

    public void refreshRemoteObject() {
        this.setMergePolicy(5);
    }

    protected Object registerObjectForMergeCloneIntoWorkingCopy(Object clone) {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
        ClassDescriptor descriptor = unitOfWork.getDescriptor(clone.getClass());
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, unitOfWork);
        Object objectFromCache = unitOfWork.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, descriptor.getJavaClass(), false, descriptor);
        if (objectFromCache == null) {
            objectFromCache = unitOfWork.checkIfAlreadyRegistered(clone, descriptor);
        }
        if (objectFromCache != null) {
            if (unitOfWork.isObjectDeleted(objectFromCache) && (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_merge_removed_entity", new Object[]{clone}));
            }
            return objectFromCache;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        if (existQuery.shouldCheckCacheForDoesExist()) {
            return unitOfWork.internalRegisterObject(clone, descriptor);
        }
        Boolean doesExist = (Boolean)existQuery.checkEarlyReturn(clone, primaryKey, unitOfWork, null);
        if (doesExist == Boolean.FALSE) {
            Object registeredObject = unitOfWork.internalRegisterObject(clone, descriptor);
            this.mergedNewObjects.put(registeredObject, registeredObject);
            return registeredObject;
        }
        Object object = unitOfWork.readObject(clone);
        if (object == null) {
            object = unitOfWork.cloneAndRegisterNewObject(clone);
            this.mergedNewObjects.put(object, object);
        }
        return object;
    }

    public void registerRemovedNewObjectIfRequired(Object removedObject) {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.shouldMergeWorkingCopyIntoOriginal() && unitOfWork.getParent().isUnitOfWork() && unitOfWork.isCloneNewObject(removedObject)) {
                Object originalVersionOfRemovedObject = unitOfWork.getOriginalVersionOfObject(removedObject);
                unitOfWork.addRemovedObject(originalVersionOfRemovedObject);
            }
        }
    }

    public void setCascadePolicy(int cascadePolicy) {
        this.cascadePolicy = cascadePolicy;
    }

    protected void setMergePolicy(int mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public void setForceCascade(boolean forceCascade) {
        this.forceCascade = forceCascade;
    }

    public void setObjectDescriptors(Map objectDescriptors) {
        this.objectDescriptors = objectDescriptors;
    }

    protected void setObjectsAlreadyMerged(Map objectsAlreadyMerged) {
        this.objectsAlreadyMerged = objectsAlreadyMerged;
    }

    public void setQueueNode(LinkedNode node) {
        this.queueNode = node;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setWriteLockQueued(CacheKey writeLockQueued) {
        this.writeLockQueued = writeLockQueued;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeReferences() {
        return !this.shouldMergeCloneIntoWorkingCopy();
    }

    public boolean shouldMergeChangesIntoDistributedCache() {
        return this.getMergePolicy() == 6;
    }

    public boolean shouldMergeCloneIntoWorkingCopy() {
        return this.getMergePolicy() == 3;
    }

    public boolean shouldMergeCloneWithReferencesIntoWorkingCopy() {
        return this.getMergePolicy() == 7;
    }

    public boolean shouldMergeOriginalIntoWorkingCopy() {
        return this.getMergePolicy() == 2;
    }

    public boolean shouldMergeWorkingCopyIntoOriginal() {
        return this.getMergePolicy() == 1;
    }

    public boolean shouldMergeWorkingCopyIntoRemote() {
        return this.getMergePolicy() == 4;
    }

    public boolean shouldRefreshRemoteObject() {
        return this.getMergePolicy() == 5;
    }

    public boolean shouldForceCascade() {
        return this.forceCascade;
    }

    public IdentityHashMap getMergedNewObjects() {
        return this.mergedNewObjects;
    }
}

