/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;

public class ListContainerPolicy
extends CollectionContainerPolicy {
    public ListContainerPolicy() {
    }

    public ListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public ListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public boolean isValidContainer(Object container) {
        return container instanceof List;
    }

    public boolean hasOrder() {
        return true;
    }

    public boolean isListPolicy() {
        return true;
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getRemoveObjectList().remove(changeSetToAdd);
        } else if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getAddOverFlow().add(changeSetToAdd);
        } else {
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToRemove)) {
            if (collectionChangeRecord.getAddOverFlow().contains(changeSetToRemove)) {
                collectionChangeRecord.getAddOverFlow().remove(changeSetToRemove);
            } else {
                collectionChangeRecord.getAddObjectList().remove(changeSetToRemove);
            }
        } else {
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
        }
    }

    public void removeFromWithOrder(int beginIndex, Object container) {
        int size;
        try {
            for (size = this.sizeFor(container) - 1; size >= beginIndex; --size) {
                ((List)container).remove(size);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotRemoveFromContainer(new Integer(size), container, this);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotRemoveFromContainer(new Integer(size), container, this);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotRemoveFromContainer(new Integer(size), container, this);
        }
    }
}

