/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.changetracking;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.annotations.ChangeTrackingType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.MetadataHelper;

public class ChangeTrackingMetadata
extends ORMetadata {
    private Enum m_type;

    public ChangeTrackingMetadata() {
        super("<change-tracking>");
    }

    public ChangeTrackingMetadata(Annotation changeTracking, MetadataAccessibleObject accessibleObject) {
        super(changeTracking, accessibleObject);
        this.m_type = (Enum)MetadataHelper.invokeMethod("value", changeTracking);
    }

    public Enum getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor) {
        descriptor.setHasChangeTracking();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        DeferredChangeDetectionPolicy policy = null;
        if (this.m_type.equals((Object)ChangeTrackingType.ATTRIBUTE)) {
            policy = new AttributeChangeTrackingPolicy();
        } else if (this.m_type.equals((Object)ChangeTrackingType.OBJECT)) {
            policy = new ObjectChangeTrackingPolicy();
        } else if (this.m_type.equals((Object)ChangeTrackingType.DEFERRED)) {
            policy = new DeferredChangeDetectionPolicy();
        } else if (this.m_type.equals((Object)ChangeTrackingType.AUTO)) {
            policy = null;
        }
        classDescriptor.setObjectChangePolicy(policy);
    }

    public void setType(Enum type) {
        this.m_type = type;
    }
}

