/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.annotations.ObjectTypeConverter;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.annotations.StructConverter;
import org.eclipse.persistence.annotations.TypeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataAccessor
extends ORMetadata {
    private boolean m_isProcessed = false;
    private Boolean m_isRelationship;
    private List<ConverterMetadata> m_converters = new ArrayList<ConverterMetadata>();
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters = new ArrayList<ObjectTypeConverterMetadata>();
    private List<StructConverterMetadata> m_structConverters = new ArrayList<StructConverterMetadata>();
    private List<TypeConverterMetadata> m_typeConverters = new ArrayList<TypeConverterMetadata>();
    private List<PropertyMetadata> m_properties = new ArrayList<PropertyMetadata>();
    private MetadataDescriptor m_descriptor;
    private MetadataDescriptor m_owningDescriptor;
    private MetadataProject m_project;
    private String m_name;

    public MetadataAccessor(String xmlElement) {
        super(xmlElement);
    }

    public MetadataAccessor(Annotation annotation, MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project) {
        super(annotation, accessibleObject);
        this.m_project = project;
        this.m_descriptor = descriptor;
    }

    @Override
    public MetadataAnnotatedElement getAccessibleObject() {
        return (MetadataAnnotatedElement)super.getAccessibleObject();
    }

    public String getAccessibleObjectName() {
        return this.getAccessibleObject().getName();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.getAccessibleObject().getAnnotatedElement();
    }

    public String getAnnotatedElementName() {
        return this.getAnnotatedElement().toString();
    }

    protected <T extends Annotation> T getAnnotation(Class annotation) {
        return this.getAccessibleObject().getAnnotation(annotation, this.m_descriptor);
    }

    public String getAttributeName() {
        return this.getAccessibleObject().getAttributeName();
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public Class getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public String getName() {
        return this.m_name;
    }

    protected String getName(DatabaseField field, String defaultName, String context) {
        return this.getName(field.getName(), defaultName, context);
    }

    protected String getName(String name, String defaultName, String context) {
        return MetadataHelper.getName(name, defaultName, context, this.getLogger(), this.getAnnotatedElement().toString());
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public MetadataDescriptor getOwningDescriptor() {
        if (this.m_owningDescriptor == null) {
            return this.getDescriptor();
        }
        return this.m_owningDescriptor;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<PropertyMetadata> getProperties() {
        return this.m_properties;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    protected String getUpperCaseAttributeName() {
        return this.getAttributeName().toUpperCase();
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName(this.getJavaClassName()).toUpperCase();
    }

    protected Integer getValue(Integer value, Integer defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected String getValue(String value, String defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert() {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public void initXMLAccessor(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project) {
        this.m_project = project;
        this.m_descriptor = descriptor;
        this.initXMLObject(accessibleObject);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObjects(this.m_converters, accessibleObject);
        this.initXMLObjects(this.m_objectTypeConverters, accessibleObject);
        this.initXMLObjects(this.m_structConverters, accessibleObject);
        this.initXMLObjects(this.m_typeConverters, accessibleObject);
        this.initXMLObjects(this.m_properties, accessibleObject);
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getAccessibleObject().isAnnotationPresent(annotation, this.m_descriptor);
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isMappingAccessor() {
        return this.isDirect() || this.isRelationship() || this.isEmbedded();
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    public boolean isRelationship() {
        if (this.m_isRelationship == null) {
            this.m_isRelationship = new Boolean(this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne());
        }
        return this.m_isRelationship;
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    @Override
    public void merge(ORMetadata metadata) {
        MetadataAccessor accessor = (MetadataAccessor)metadata;
        this.m_converters = this.mergeORObjectLists(this.m_converters, accessor.getConverters());
        this.m_objectTypeConverters = this.mergeORObjectLists(this.m_objectTypeConverters, accessor.getObjectTypeConverters());
        this.m_structConverters = this.mergeORObjectLists(this.m_structConverters, accessor.getStructConverters());
        this.m_typeConverters = this.mergeORObjectLists(this.m_typeConverters, accessor.getTypeConverters());
        this.m_properties = this.mergeORObjectLists(this.m_properties, accessor.getProperties());
    }

    public abstract void process();

    public void processConverters() {
        this.processCustomConverters();
        this.processObjectTypeConverters();
        this.processTypeConverters();
        this.processStructConverter();
    }

    protected void processCustomConverters() {
        for (ConverterMetadata converter : this.m_converters) {
            this.m_project.addConverter(converter);
        }
        Object converter = this.getAnnotation(Converter.class);
        if (converter != null) {
            this.m_project.addConverter(new ConverterMetadata((Annotation)converter, this.getAccessibleObject()));
        }
    }

    protected void processObjectTypeConverters() {
        for (ObjectTypeConverterMetadata objectTypeConverter : this.m_objectTypeConverters) {
            this.m_project.addConverter(objectTypeConverter);
        }
        Object objectTypeConverter = this.getAnnotation(ObjectTypeConverter.class);
        if (objectTypeConverter != null) {
            this.m_project.addConverter(new ObjectTypeConverterMetadata((Annotation)objectTypeConverter, this.getAccessibleObject()));
        }
    }

    protected List<PrimaryKeyJoinColumnMetadata> processPrimaryKeyJoinColumns(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns) {
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = primaryKeyJoinColumns.values(this.m_descriptor);
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (pkJoinColumns.size() != this.m_descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified(this.getAnnotatedElement());
            }
            for (PrimaryKeyJoinColumnMetadata pkJoinColumn : pkJoinColumns) {
                if (!pkJoinColumn.isPrimaryKeyFieldNotSpecified() && !pkJoinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified(this.getAnnotatedElement());
            }
        } else if (pkJoinColumns.size() > 1) {
            throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified(this.getAnnotatedElement());
        }
        return pkJoinColumns;
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    protected void processStructConverter() {
        for (StructConverterMetadata structConverter : this.m_structConverters) {
            this.m_project.addConverter(structConverter);
        }
        Object converter = this.getAnnotation(StructConverter.class);
        if (converter != null) {
            this.m_project.addConverter(new StructConverterMetadata((Annotation)converter, this.getAccessibleObject()));
        }
    }

    protected void processTable(TableMetadata table, String defaultName) {
        this.getProject().processTable(table, defaultName, this.m_descriptor.getXMLCatalog(), this.m_descriptor.getXMLSchema());
    }

    protected void processTypeConverters() {
        for (TypeConverterMetadata typeConverter : this.m_typeConverters) {
            this.m_project.addConverter(typeConverter);
        }
        Object typeConverter = this.getAnnotation(TypeConverter.class);
        if (typeConverter != null) {
            this.m_project.addConverter(new TypeConverterMetadata((Annotation)typeConverter, this.getAccessibleObject()));
        }
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescriptor(MetadataDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setIsProcessed() {
        this.m_isProcessed = true;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setOwningDescriptor(MetadataDescriptor owningDescriptor) {
        this.m_owningDescriptor = owningDescriptor;
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.m_properties = properties;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }
}

