/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.PersistenceInitializationActivator;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class JavaSECMPInitializer
implements PersistenceInitializationActivator {
    public static Instrumentation globalInstrumentation;
    protected boolean shouldCreateInternalLoader = true;
    protected static JavaSECMPInitializer javaSECMPInitializer;
    protected ClassLoader sessionClassLoader = null;

    public static synchronized JavaSECMPInitializer getJavaSECMPInitializer() {
        if (javaSECMPInitializer == null) {
            javaSECMPInitializer = new JavaSECMPInitializer();
        }
        JavaSECMPInitializer.initializeTopLinkLoggingFile();
        return javaSECMPInitializer;
    }

    public static boolean isSingletonInitialized() {
        return javaSECMPInitializer != null;
    }

    protected JavaSECMPInitializer() {
    }

    protected boolean callPredeploy(SEPersistenceUnitInfo persistenceUnitInfo, Map m, PersistenceInitializationActivator persistenceActivator) {
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        if (persistenceActivator.isPersistenceProviderSupported(providerClassName)) {
            String puName = PersistenceUnitProcessor.buildPersistenceUnitName(persistenceUnitInfo.getPersistenceUnitRootUrl(), persistenceUnitInfo.getPersistenceUnitName());
            EntityManagerSetupImpl emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(puName);
            if (emSetupImpl != null && !emSetupImpl.isUndeployed()) {
                return false;
            }
            Set<String> tempLoaderSet = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo, Thread.currentThread().getContextClassLoader());
            AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", persistenceUnitInfo.getPersistenceUnitName());
            Map mergedProperties = EntityManagerFactoryProvider.mergeMaps(m, persistenceUnitInfo.getProperties());
            String weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", mergedProperties, null);
            if (globalInstrumentation == null) {
                if (weaving == null) {
                    mergedProperties.put("eclipselink.weaving", "false");
                    weaving = "false";
                } else if (weaving.equalsIgnoreCase("true")) {
                    throw new PersistenceException((Throwable)EntityManagerSetupException.wrongWeavingPropertyValue());
                }
            }
            if (weaving != null && (weaving.equalsIgnoreCase("false") || weaving.equalsIgnoreCase("static"))) {
                this.shouldCreateInternalLoader = false;
            }
            ClassLoader tempLoader = this.createTempLoader(tempLoaderSet);
            persistenceUnitInfo.setNewTempClassLoader(tempLoader);
            if (emSetupImpl == null) {
                emSetupImpl = new EntityManagerSetupImpl();
                EntityManagerFactoryProvider.addEntityManagerSetupImpl(puName, emSetupImpl);
            }
            persistenceUnitInfo.setClassLoader(JavaSECMPInitializer.getMainLoader());
            final ClassTransformer transformer = emSetupImpl.predeploy(persistenceUnitInfo, mergedProperties);
            if (transformer != null && globalInstrumentation != null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", persistenceUnitInfo.getPersistenceUnitName());
                globalInstrumentation.addTransformer(new ClassFileTransformer(){

                    @Override
                    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                        return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                    }
                });
            } else if (transformer == null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
            } else if (globalInstrumentation == null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_globalInstrumentation_is_null");
            }
            return true;
        }
        return false;
    }

    protected ClassLoader createTempLoader(Collection col) {
        return this.createTempLoader(col, true);
    }

    protected ClassLoader createTempLoader(Collection col, boolean shouldOverrideLoadClassForCollectionMembers) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof URLClassLoader)) {
            return currentLoader;
        }
        URL[] urlPath = ((URLClassLoader)currentLoader).getURLs();
        TempEntityLoader tempLoader = new TempEntityLoader(urlPath, currentLoader, col, shouldOverrideLoadClassForCollectionMembers);
        AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", tempLoader);
        AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", shouldOverrideLoadClassForCollectionMembers);
        return tempLoader;
    }

    public static ClassLoader getMainLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected void initPersistenceUnits(Archive archive, Map m, PersistenceInitializationActivator persistenceActivator) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.sessionClassLoader)) {
            this.callPredeploy(persistenceUnitInfo, m, persistenceActivator);
        }
    }

    public void initialize(Map m, PersistenceInitializationActivator persistenceActivator) {
        this.sessionClassLoader = JavaSECMPInitializer.getMainLoader();
        Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives();
        for (Archive archive : pars) {
            AbstractSessionLog.getLog().log(2, "cmp_init_initialize", archive);
            this.initPersistenceUnits(archive, m, persistenceActivator);
        }
    }

    protected static void initializeFromAgent(Instrumentation instrumentation) throws Exception {
        JavaSECMPInitializer.initializeTopLinkLoggingFile();
        AbstractSessionLog.getLog().log(2, "cmp_init_initialize_from_agent", null);
        globalInstrumentation = instrumentation;
        javaSECMPInitializer = new JavaSECMPInitializer();
        javaSECMPInitializer.initialize(new HashMap(), javaSECMPInitializer);
    }

    public boolean isPersistenceProviderSupported(String providerClassName) {
        return providerClassName == null || providerClassName.equals("") || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName());
    }

    public static void initializeFromMain(Map m) {
        if (javaSECMPInitializer != null) {
            return;
        }
        JavaSECMPInitializer.getJavaSECMPInitializer().initialize(m, javaSECMPInitializer);
    }

    public static void initializeFromMain() {
        JavaSECMPInitializer.initializeFromMain(new HashMap());
    }

    public static void initializeTopLinkLoggingFile() {
        String loggingFile = System.getProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                AbstractSessionLog.getLog().setWriter(new FileWriter(loggingFile));
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", loggingFile, e);
        }
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound(entityClassName, classLoader, cnfEx);
            }
        }
        return entityClasses;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.getParent().getResources(name);
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            super(urls, parent);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames) {
            this(urls, parent, classNames, true);
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

