/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkCacheKey;

public class UnitOfWorkIdentityMap
extends FullIdentityMap {
    public UnitOfWorkIdentityMap(int size) {
        this.maxSize = size;
        this.cacheKeys = new HashMap(size);
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return new UnitOfWorkCacheKey(primaryKey, object, writeLockValue, readTime);
    }

    public CacheKey acquireDeferredLock(Vector primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireLock(Vector primaryKey, boolean forMerge) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireLockNoWait(Vector primaryKey, boolean forMerge) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey) {
        return this.acquireReadLockOnCacheKeyNoWait(primaryKey);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKey(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    protected CacheKey getCacheKeyWithReadLock(Vector primaryKey) {
        return this.getCacheKey(primaryKey);
    }

    protected CacheKey getCacheKeyIfAbsentPut(CacheKey searchKey) {
        CacheKey cacheKey = this.getCacheKeys().get(searchKey);
        if (cacheKey == null) {
            searchKey.setOwningMap(this);
            this.getCacheKeys().put(searchKey, searchKey);
            return null;
        }
        return cacheKey;
    }

    public Object remove(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        this.getCacheKeys().remove(cacheKey);
        return cacheKey.getObject();
    }

    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue, long readTime) {
        key.setObject(object);
        key.setWriteLockValue(writeLockValue);
        key.setReadTime(readTime);
    }

    public void setWriteLockValue(Vector primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWriteLockValue(writeLockValue);
        }
    }
}

