/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.persistence.logging.SessionLog;

public class DBPlatformHelper {
    private static final String DEFAULTPLATFORM = "org.eclipse.persistence.platform.database.DatabasePlatform";
    private static final String PROPERTY_PATH = "org/eclipse/persistence/internal/helper/";
    private static final String VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME = "org/eclipse/persistence/internal/helper/VendorNameToPlatformMapping.properties";
    private static Properties _nameToVendorPlatform = null;

    public static String getDBPlatform(String vendorName, SessionLog logger) {
        DBPlatformHelper.initializeNameToVendorPlatform(logger);
        String detectedDbPlatform = null;
        if (vendorName != null) {
            detectedDbPlatform = DBPlatformHelper.matchVendorNameInProperties(vendorName, _nameToVendorPlatform, logger);
        }
        if (logger.shouldLog(3)) {
            logger.log(3, "dbPlaformHelper_detectedVendorPlatform", detectedDbPlatform);
        }
        if (detectedDbPlatform == null) {
            if (logger.shouldLog(5)) {
                logger.log(5, "dbPlaformHelper_defaultingPlatform", vendorName, DEFAULTPLATFORM);
            }
            detectedDbPlatform = DEFAULTPLATFORM;
        }
        return detectedDbPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties initializeNameToVendorPlatform(SessionLog logger) {
        Class<DBPlatformHelper> clazz = DBPlatformHelper.class;
        synchronized (DBPlatformHelper.class) {
            if (_nameToVendorPlatform == null) {
                _nameToVendorPlatform = new Properties();
                try {
                    DBPlatformHelper.loadFromResource(_nameToVendorPlatform, VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME, DBPlatformHelper.class.getClassLoader());
                }
                catch (IOException e) {
                    logger.log(6, "dbPlaformHelper_noMappingFound", VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _nameToVendorPlatform;
        }
    }

    private static String matchVendorNameInProperties(String vendorName, Properties nameToVendorPlatform, SessionLog logger) {
        String dbPlatform = null;
        Iterator<Map.Entry<Object, Object>> iterator = nameToVendorPlatform.entrySet().iterator();
        while (dbPlatform == null && iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String regExpr = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (logger.shouldLog(1)) {
                logger.log(1, "dbPlaformHelper_regExprDbPlatform", regExpr, value);
            }
            if (!DBPlatformHelper.matchPattern(regExpr, vendorName, logger)) continue;
            dbPlatform = value;
        }
        return dbPlatform;
    }

    private static boolean matchPattern(String regExp, String target, SessionLog logger) {
        boolean matches;
        block2: {
            matches = false;
            try {
                matches = Pattern.matches(regExp, target);
            }
            catch (PatternSyntaxException e) {
                if (!logger.shouldLog(3)) break block2;
                logger.log(3, "dbPlaformHelper_patternSyntaxException", e);
            }
        }
        return matches;
    }

    private static void loadFromResource(Properties properties, String resourceName, ClassLoader classLoader) throws IOException {
        DBPlatformHelper.load(properties, resourceName, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Properties properties, String resourceName, ClassLoader classLoader) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(DBPlatformHelper.openResourceInputStream(resourceName, classLoader));
        try {
            properties.load(bin);
        }
        finally {
            try {
                ((InputStream)bin).close();
            }
            catch (Exception e) {}
        }
    }

    private static InputStream openResourceInputStream(final String resourceName, final ClassLoader classLoader) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(resourceName);
                }
                return ClassLoader.getSystemResourceAsStream(resourceName);
            }
        });
    }
}

