/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.ResourceBundleProvider;
import org.apache.openjpa.lib.util.SimpleResourceBundleProvider;
import org.apache.openjpa.lib.util.StreamResourceBundleProvider;
import org.apache.openjpa.lib.util.ZipResourceBundleProvider;
import org.apache.openjpa.lib.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.lib.util.concurrent.CopyOnWriteArraySet;

public class Localizer {
    private static final Map _localizers = new ConcurrentHashMap();
    private static final Collection _providers = new CopyOnWriteArraySet(Arrays.asList(new SimpleResourceBundleProvider(), new StreamResourceBundleProvider(), new ZipResourceBundleProvider()));
    private String _file;
    private String _pkg;
    private ResourceBundle _bundle = null;
    private Locale _locale;
    private ClassLoader _loader;

    public static Localizer forPackage(Class cls) {
        return Localizer.forPackage(cls, null);
    }

    public static Localizer forPackage(Class cls, Locale locale) {
        String file;
        String pkg;
        int dot;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int n = dot = cls == null ? -1 : cls.getName().lastIndexOf(46);
        if (dot == -1) {
            pkg = "";
            file = "localizer";
        } else {
            pkg = cls.getName().substring(0, dot);
            file = pkg + ".localizer";
        }
        String key = file + locale.toString();
        Localizer loc = (Localizer)_localizers.get(key);
        if (loc != null) {
            return loc;
        }
        loc = new Localizer(pkg, file, locale, cls == null ? null : (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls)));
        _localizers.put(key, loc);
        return loc;
    }

    public static void addProvider(ResourceBundleProvider provider) {
        _providers.add(provider);
    }

    public static boolean removeProvider(ResourceBundleProvider provider) {
        return _providers.remove(provider);
    }

    private Localizer(String pkg, String f, Locale locale, ClassLoader loader) {
        this._pkg = pkg;
        this._file = f;
        this._locale = locale;
        this._loader = loader;
    }

    private ResourceBundle getBundle() {
        if (this._bundle == null) {
            Iterator itr = _providers.iterator();
            while (itr.hasNext() && this._bundle == null) {
                this._bundle = ((ResourceBundleProvider)itr.next()).findResource(this._file, this._locale, this._loader);
            }
        }
        return this._bundle;
    }

    public Message get(String key) {
        return this.get(key, null);
    }

    public Message getFatal(String key) {
        return this.getFatal(key, null);
    }

    public Message get(String key, Object sub) {
        return this.get(key, new Object[]{sub});
    }

    public Message getFatal(String key, Object sub) {
        return this.getFatal(key, new Object[]{sub});
    }

    public Message get(String key, Object sub1, Object sub2) {
        return this.get(key, new Object[]{sub1, sub2});
    }

    public Message getFatal(String key, Object sub1, Object sub2) {
        return this.getFatal(key, new Object[]{sub1, sub2});
    }

    public Message get(String key, Object sub1, Object sub2, Object sub3) {
        return this.get(key, new Object[]{sub1, sub2, sub3});
    }

    public Message get(String key, Object[] subs) {
        return new Message(this._pkg, this.getBundle(), key, subs, false);
    }

    public Message getFatal(String key, Object[] subs) {
        return new Message(this._pkg, this.getBundle(), key, subs, true);
    }

    public static class Message {
        private final String _pkg;
        private final String _key;
        private final Object[] _subs;
        private final String _localizedMessage;

        private Message(String packageName, ResourceBundle bundle, String key, Object[] subs, boolean fatal) {
            if (bundle == null && fatal) {
                throw new MissingResourceException(key, key, key);
            }
            this._pkg = packageName;
            this._key = key;
            this._subs = subs;
            if (bundle == null) {
                this._localizedMessage = key;
            } else {
                String localized;
                block5: {
                    localized = null;
                    try {
                        localized = bundle.getString(key);
                    }
                    catch (MissingResourceException mre) {
                        if (!fatal) break block5;
                        throw mre;
                    }
                }
                this._localizedMessage = localized == null ? key : localized;
            }
        }

        public String getMessage() {
            return MessageFormat.format(this._localizedMessage, this._subs);
        }

        public String getKey() {
            return this._key;
        }

        public Object[] getSubstitutions() {
            return this._subs;
        }

        public String getPackageName() {
            return this._pkg;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

