/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openjpa.lib.graph.Edge;

public class Graph {
    private final Map _nodes = new LinkedHashMap();

    public void clear() {
        this._nodes.clear();
    }

    public boolean containsNode(Object node) {
        return this._nodes.containsKey(node);
    }

    public Collection getNodes() {
        return this._nodes.keySet();
    }

    public void addNode(Object node) {
        if (node == null) {
            throw new NullPointerException("node = null");
        }
        if (!this.containsNode(node)) {
            this._nodes.put(node, null);
        }
    }

    public boolean removeNode(Object node) {
        boolean rem = this.containsNode(node);
        if (rem) {
            Collection edges = this.getEdgesTo(node);
            Iterator itr = edges.iterator();
            while (itr.hasNext()) {
                this.removeEdge((Edge)itr.next());
            }
            this._nodes.remove(node);
        }
        return rem;
    }

    public Collection getEdges() {
        HashSet all = new HashSet();
        Iterator itr = this._nodes.values().iterator();
        while (itr.hasNext()) {
            Collection edges = (Collection)itr.next();
            if (edges == null) continue;
            all.addAll(edges);
        }
        return all;
    }

    public Collection getEdgesFrom(Object node) {
        Collection edges = (Collection)this._nodes.get(node);
        return edges == null ? Collections.EMPTY_LIST : edges;
    }

    public Collection getEdgesTo(Object node) {
        Collection edges = this.getEdges();
        ArrayList<Edge> to = new ArrayList<Edge>();
        Iterator itr = edges.iterator();
        while (itr.hasNext()) {
            Edge edge = (Edge)itr.next();
            if (!edge.isTo(node)) continue;
            to.add(edge);
        }
        return to;
    }

    public Collection getEdges(Object from, Object to) {
        Collection edges = this.getEdgesFrom(from);
        ArrayList<Edge> matches = new ArrayList<Edge>(edges.size());
        Iterator itr = edges.iterator();
        while (itr.hasNext()) {
            Edge edge = (Edge)itr.next();
            if (!edge.isTo(to)) continue;
            matches.add(edge);
        }
        return matches;
    }

    public void addEdge(Edge edge) {
        if (!this.containsNode(edge.getTo())) {
            throw new IllegalArgumentException(edge.getTo().toString());
        }
        if (!this.containsNode(edge.getFrom())) {
            throw new IllegalArgumentException(edge.getFrom().toString());
        }
        ArrayList<Edge> from = (ArrayList<Edge>)this._nodes.get(edge.getFrom());
        if (from == null) {
            from = new ArrayList<Edge>(3);
            this._nodes.put(edge.getFrom(), from);
        }
        from.add(edge);
        if (!edge.isDirected() && !edge.getFrom().equals(edge.getTo())) {
            ArrayList<Edge> to = (ArrayList<Edge>)this._nodes.get(edge.getTo());
            if (to == null) {
                to = new ArrayList<Edge>(3);
                this._nodes.put(edge.getTo(), to);
            }
            to.add(edge);
        }
    }

    public boolean removeEdge(Edge edge) {
        Collection edges = (Collection)this._nodes.get(edge.getFrom());
        if (edges == null) {
            return false;
        }
        boolean rem = edges.remove(edge);
        if (rem && !edge.isDirected() && (edges = (Collection)this._nodes.get(edge.getTo())) != null) {
            edges.remove(edge);
        }
        return rem;
    }

    public void clearTraversal() {
        Iterator vals = this._nodes.values().iterator();
        while (vals.hasNext()) {
            Collection edges = (Collection)vals.next();
            if (edges == null) continue;
            Iterator ed = edges.iterator();
            while (ed.hasNext()) {
                ((Edge)ed.next()).clearTraversal();
            }
        }
    }
}

