/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.AttachManager;
import org.apache.openjpa.kernel.AttachStrategy;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.DetachState;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OptimisticException;

class VersionAttachStrategy
extends AttachStrategy
implements DetachState {
    private static final Localizer _loc = Localizer.forPackage(VersionAttachStrategy.class);

    VersionAttachStrategy() {
    }

    protected Object getDetachedObjectId(AttachManager manager, Object toAttach) {
        BrokerImpl broker = manager.getBroker();
        ClassMetaData meta = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(ImplHelper.getManagedInstance(toAttach).getClass(), broker.getClassLoader(), true);
        return ApplicationIds.create(ImplHelper.toPersistenceCapable(toAttach, broker.getConfiguration()), meta);
    }

    protected void provideField(Object toAttach, StateManagerImpl sm, int field) {
        sm.provideField(ImplHelper.toPersistenceCapable(toAttach, sm.getContext().getConfiguration()), this, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attach(AttachManager manager, Object toAttach, ClassMetaData meta, PersistenceCapable into, OpenJPAStateManager owner, ValueMetaData ownerMeta, boolean explicit) {
        StateManagerImpl sm;
        if (into == null) {
            into = this.findFromDatabase(manager, toAttach);
        }
        BrokerImpl broker = manager.getBroker();
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(toAttach, meta.getRepository().getConfiguration());
        boolean embedded = ownerMeta != null && ownerMeta.isEmbeddedPC();
        boolean isNew = !broker.isDetached(pc) && into == null;
        Object version = null;
        if (embedded && (isNew || into == null || broker.getStateManager(into) == null)) {
            if (into == null) {
                into = pc.pcNewInstance(null, false);
            }
            sm = (StateManagerImpl)broker.embed(into, null, owner, ownerMeta);
            into = sm.getPersistenceCapable();
        } else if (isNew) {
            sm = this.persist(manager, pc, meta, ApplicationIds.create(pc, meta), explicit);
            into = sm.getPersistenceCapable();
        } else if (!embedded && into == null) {
            Object id = this.getDetachedObjectId(manager, toAttach);
            if (id != null) {
                into = ImplHelper.toPersistenceCapable(broker.find(id, true, null), broker.getConfiguration());
            }
            if (into == null) {
                throw new OptimisticException(_loc.get("attach-version-del", ImplHelper.getManagedInstance(pc).getClass(), id, version)).setFailedObject(toAttach);
            }
            sm = manager.assertManaged(into);
            if (meta.getDescribedType() != sm.getMetaData().getDescribedType()) {
                throw new ObjectNotFoundException(_loc.get("attach-wrongclass", id, toAttach.getClass(), sm.getMetaData().getDescribedType())).setFailedObject(toAttach);
            }
        } else {
            sm = manager.assertManaged(into);
        }
        manager.setAttachedCopy(toAttach, into);
        if (pc == into) {
            this.attachFieldsInPlace(manager, sm);
            return into;
        }
        if (isNew) {
            broker.fireLifecycleEvent(toAttach, null, meta, 0);
        } else {
            manager.fireBeforeAttach(toAttach, meta);
        }
        StateManager smBefore = pc.pcGetStateManager();
        pc.pcReplaceStateManager(sm);
        int detach = isNew ? 2 : broker.getDetachState();
        FetchConfiguration fetch = broker.getFetchConfiguration();
        try {
            FieldMetaData[] fmds = meta.getFields();
            block8: for (int i = 0; i < fmds.length; ++i) {
                switch (detach) {
                    case 2: {
                        this.attachField(manager, toAttach, sm, fmds[i], true);
                        continue block8;
                    }
                    case 0: {
                        if (fetch.requiresFetch(fmds[i]) == 0) continue block8;
                        this.attachField(manager, toAttach, sm, fmds[i], true);
                        continue block8;
                    }
                    case 1: {
                        this.attachField(manager, toAttach, sm, fmds[i], false);
                    }
                }
            }
        }
        finally {
            pc.pcReplaceStateManager(smBefore);
        }
        if (!embedded && !isNew) {
            this.compareVersion(sm, pc);
        }
        return ImplHelper.getManagedInstance(into);
    }

    private void compareVersion(StateManagerImpl sm, PersistenceCapable pc) {
        Object version = pc.pcGetVersion();
        if (version == null) {
            return;
        }
        DelegatingStoreManager store = sm.getBroker().getStoreManager();
        switch (store.compareVersion(sm, version, sm.getVersion())) {
            case 1: {
                sm.setVersion(version);
                break;
            }
            case 2: 
            case 4: {
                sm.setVersion(version);
                throw new OptimisticException(sm.getManagedInstance());
            }
        }
    }

    private void attachFieldsInPlace(AttachManager manager, StateManagerImpl sm) {
        FieldMetaData[] fmds = sm.getMetaData().getFields();
        block6: for (int i = 0; i < fmds.length; ++i) {
            Object[] attached;
            Object cur;
            if (fmds[i].getManagement() != 3) continue;
            switch (fmds[i].getDeclaredTypeCode()) {
                case 15: 
                case 27: {
                    cur = sm.fetchObjectField(i);
                    attached = this.attachInPlace(manager, sm, (ValueMetaData)fmds[i], cur);
                    break;
                }
                case 11: {
                    if (!fmds[i].getElement().isDeclaredTypePC()) continue block6;
                    cur = sm.fetchObjectField(i);
                    attached = this.attachInPlace(manager, sm, fmds[i], (Object[])cur);
                    break;
                }
                case 12: {
                    if (!fmds[i].getElement().isDeclaredTypePC()) continue block6;
                    cur = sm.fetchObjectField(i);
                    attached = this.attachInPlace(manager, sm, fmds[i], (Collection)cur);
                    break;
                }
                case 13: {
                    if (!fmds[i].getElement().isDeclaredTypePC() && !fmds[i].getKey().isDeclaredTypePC()) continue block6;
                    cur = sm.fetchObjectField(i);
                    attached = this.attachInPlace(manager, sm, fmds[i], (Map)cur);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (cur == attached) continue;
            sm.settingObjectField(sm.getPersistenceCapable(), i, cur, attached, 1);
        }
    }

    private Object attachInPlace(AttachManager manager, StateManagerImpl sm, ValueMetaData vmd, Object pc) {
        PersistenceCapable intoPC;
        if (pc == null) {
            return null;
        }
        PersistenceCapable attached = manager.getAttachedCopy(pc);
        if (attached != null) {
            return attached;
        }
        OpenJPAStateManager into = manager.getBroker().getStateManager(pc);
        PersistenceCapable persistenceCapable = intoPC = into == null ? null : into.getPersistenceCapable();
        if (vmd.isEmbedded()) {
            return manager.attach(pc, intoPC, sm, vmd, false);
        }
        return manager.attach(pc, intoPC, null, null, false);
    }

    private Object[] attachInPlace(AttachManager manager, StateManagerImpl sm, FieldMetaData fmd, Object[] arr) {
        if (arr == null) {
            return null;
        }
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.attachInPlace(manager, sm, fmd.getElement(), arr[i]);
        }
        return arr;
    }

    private Collection attachInPlace(AttachManager manager, StateManagerImpl sm, FieldMetaData fmd, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            return coll;
        }
        Collection copy = null;
        if (fmd.getElement().isEmbedded()) {
            copy = (Collection)sm.newFieldProxy(fmd.getIndex());
        } else {
            Iterator itr = coll.iterator();
            while (itr.hasNext()) {
                if (!manager.getBroker().isDetached(itr.next())) continue;
                copy = (Collection)sm.newFieldProxy(fmd.getIndex());
                break;
            }
        }
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            Object attached = this.attachInPlace(manager, sm, fmd.getElement(), itr.next());
            if (copy == null) continue;
            copy.add(attached);
        }
        return copy == null ? coll : copy;
    }

    private Map attachInPlace(AttachManager manager, StateManagerImpl sm, FieldMetaData fmd, Map map) {
        Map.Entry entry;
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map copy = null;
        boolean keyPC = fmd.getKey().isDeclaredTypePC();
        boolean valPC = fmd.getElement().isDeclaredTypePC();
        if (fmd.getKey().isEmbeddedPC() || fmd.getElement().isEmbeddedPC()) {
            copy = (Map)sm.newFieldProxy(fmd.getIndex());
        } else {
            Iterator itr = map.entrySet().iterator();
            while (itr.hasNext()) {
                entry = itr.next();
                if ((!keyPC || !manager.getBroker().isDetached(entry.getKey())) && (!valPC || !manager.getBroker().isDetached(entry.getValue()))) continue;
                copy = (Map)sm.newFieldProxy(fmd.getIndex());
                break;
            }
        }
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            Object key = entry.getKey();
            if (keyPC) {
                key = this.attachInPlace(manager, sm, fmd.getKey(), key);
            }
            Object val = entry.getValue();
            if (valPC) {
                val = this.attachInPlace(manager, sm, fmd.getElement(), val);
            }
            if (copy == null) continue;
            copy.put(key, val);
        }
        return copy == null ? map : copy;
    }

    protected PersistenceCapable findFromDatabase(AttachManager manager, Object pc) {
        Object oid = manager.getBroker().newObjectId(pc.getClass(), manager.getDetachedObjectId(pc));
        if (oid != null) {
            return ImplHelper.toPersistenceCapable(manager.getBroker().find(oid, true, null), manager.getBroker().getConfiguration());
        }
        return null;
    }
}

