/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

public class ClientSynchroMessageConnectionImpl
implements ClientSynchroMessageConnection {
    private transient int[] connectionLock = new int[0];
    private transient MessageConnection connection;
    private transient SynchroCallback callback;
    private transient ClientAdmin clientAdmin = null;
    private transient ServerAdmin serverAdmin = null;
    private transient Subject subject = null;
    private Map env;
    private transient ThreadService threads;
    private transient MessageReader reader;
    private transient long wtimeout;
    private transient HashMap waitingList = new HashMap();
    private transient Message notifResp = null;
    private final transient int[] notifLock = new int[0];
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int FAILED = 4;
    private static final int TERMINATED = 5;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SynchroMessageConnectionImpl");

    public ClientSynchroMessageConnectionImpl(MessageConnection messageConnection, SynchroCallback synchroCallback, Map map) {
        if (messageConnection == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        if (synchroCallback == null) {
            throw new IllegalArgumentException("Null SynchroCallback object.");
        }
        this.connection = messageConnection;
        this.callback = synchroCallback;
        this.env = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map map) throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Establishing the connection.");
                }
                HashMap hashMap = new HashMap();
                if (this.env != null) {
                    hashMap.putAll(this.env);
                }
                if (map != null) {
                    hashMap.putAll(map);
                }
                this.wtimeout = DefaultConfig.getRequestTimeout(hashMap);
                this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(hashMap);
                this.clientAdmin = DefaultConfig.getClientAdmin(hashMap);
                this.state = 2;
                this.stateLock.notifyAll();
                this.connection.connect(hashMap);
                this.connection = this.clientAdmin.connectionOpen(this.connection);
                this.env = hashMap;
                this.reader = new MessageReader();
                this.threads = new ThreadService(1, 1);
                this.threads.handoff(this.reader);
                this.state = 3;
                this.stateLock.notifyAll();
            } else if (this.state == 4 || this.state == 3) {
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Re-establishing the connection...");
                }
                if (this.state == 3) {
                    this.state = 4;
                    this.stateLock.notifyAll();
                }
                this.state = 2;
                this.stateLock.notifyAll();
                if (this.reader != null) {
                    this.reader.stop();
                }
                Object object = this.connectionLock;
                synchronized (this.connectionLock) {
                    this.connection.connect(this.env);
                    this.connection = this.clientAdmin.connectionOpen(this.connection);
                    // ** MonitorExit[var3_4 /* !! */ ] (shouldn't be in output)
                    if (this.logger.traceOn()) {
                        object = "Wakeup the threads which are waiting a response frome the server to inform them of the connection failure.";
                        this.logger.trace("connect", (String)object);
                    }
                    object = new ConnectionClosedException("The connection has been closed by the server.");
                    HashMap hashMap = this.waitingList;
                    synchronized (hashMap) {
                        Iterator iterator = this.waitingList.keySet().iterator();
                        while (iterator.hasNext()) {
                            ResponseMsgWrapper responseMsgWrapper;
                            Long l = (Long)iterator.next();
                            ResponseMsgWrapper responseMsgWrapper2 = responseMsgWrapper = (ResponseMsgWrapper)this.waitingList.get(l);
                            synchronized (responseMsgWrapper2) {
                                if (!responseMsgWrapper.got) {
                                    responseMsgWrapper.got = true;
                                    responseMsgWrapper.msg = object;
                                }
                                responseMsgWrapper.notify();
                            }
                        }
                        this.waitingList.clear();
                    }
                    this.state = 3;
                    this.reader = new MessageReader();
                    this.threads.handoff(this.reader);
                    this.stateLock.notifyAll();
                }
            } else {
                this.checkState();
            }
            {
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            {
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Done");
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOneWay(Message message) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("sendOneWay", "Send a message without response.");
        }
        this.checkState();
        int[] nArray = this.connectionLock;
        synchronized (this.connectionLock) {
            this.connection.writeMessage(message);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Message sendWithReturn(Message message) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("sendWithReturn", "Send a message with response.");
        }
        this.checkState();
        Message message2 = null;
        if (!(message instanceof NotificationRequestMessage)) {
            if (!(message instanceof MBeanServerRequestMessage)) throw new IOException("Unknow message type: " + message);
            if (this.logger.traceOn()) {
                this.logger.trace("sendWithReturn", "Send a MBeanServerRequestMessage.");
            }
        } else {
            if (this.logger.traceOn()) {
                this.logger.trace("sendWithReturn", "Send a NotificationRequestMessage.");
            }
            this.notifResp = null;
            int[] nArray = this.connectionLock;
            // MONITORENTER : this.connectionLock
            this.connection.writeMessage(message);
            // MONITOREXIT : nArray
            nArray = this.notifLock;
            // MONITORENTER : this.notifLock
            while (true) {
                if (this.notifResp != null) {
                    message2 = this.notifResp;
                    this.notifResp = null;
                    // MONITOREXIT : nArray
                    return message2;
                }
                try {
                    this.notifLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.toString());
                    EnvHelp.initCause(interruptedIOException, interruptedException);
                    throw interruptedIOException;
                }
            }
        }
        Long l = new Long(((MBeanServerRequestMessage)message).getMessageId());
        boolean bl = false;
        while (true) {
            ResponseMsgWrapper responseMsgWrapper = new ResponseMsgWrapper();
            Object object = this.waitingList;
            // MONITORENTER : object
            this.waitingList.put(l, responseMsgWrapper);
            // MONITOREXIT : object
            object = this.connectionLock;
            // MONITORENTER : this.connectionLock
            this.connection.writeMessage(message);
            // MONITOREXIT : object
            long l2 = this.wtimeout;
            long l3 = System.currentTimeMillis();
            Object object2 = responseMsgWrapper;
            // MONITORENTER : object2
            while (!responseMsgWrapper.got && l2 > 0L) {
                try {
                    responseMsgWrapper.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                l2 = this.wtimeout - (System.currentTimeMillis() - l3);
            }
            // MONITOREXIT : object2
            object2 = this.waitingList;
            // MONITORENTER : object2
            this.waitingList.remove(l);
            // MONITOREXIT : object2
            if (!responseMsgWrapper.got) {
                if (this.isTerminated()) throw new IOException("The connection has been closed or broken.");
                throw new InterruptedIOException("Waiting response timeout: " + this.wtimeout);
            }
            if (responseMsgWrapper.msg instanceof MBeanServerResponseMessage) {
                return (MBeanServerResponseMessage)responseMsgWrapper.msg;
            }
            if (!(responseMsgWrapper.msg instanceof ConnectionClosedException)) throw new IOException("Got wrong response: " + responseMsgWrapper.msg);
            if (this.isTerminated()) throw (ConnectionClosedException)responseMsgWrapper.msg;
            if (bl) {
                throw (ConnectionClosedException)responseMsgWrapper.msg;
            }
            if (this.logger.traceOn()) {
                this.logger.trace("sendWithReturn", "Got a local ConnectionClosedException, retry.");
            }
            bl = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("close", "Closing this SynchroMessageConnection.");
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 5) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 5;
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Close the callback reader.");
            }
            if (this.reader != null) {
                this.reader.stop();
            }
            if (this.threads != null) {
                this.threads.terminate();
                this.threads = null;
            }
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Closing the underlying connection.");
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.clientAdmin.connectionClosed(this.connection);
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Clean all threads waiting theire responses.");
            }
            HashMap hashMap = this.waitingList;
            synchronized (hashMap) {
                Iterator iterator = this.waitingList.values().iterator();
                while (iterator.hasNext()) {
                    ResponseMsgWrapper responseMsgWrapper = (ResponseMsgWrapper)iterator.next();
                    ConnectionClosedException connectionClosedException = new ConnectionClosedException("The connection has been closed by the server.");
                    ResponseMsgWrapper responseMsgWrapper2 = responseMsgWrapper;
                    synchronized (responseMsgWrapper2) {
                        if (!responseMsgWrapper.got) {
                            responseMsgWrapper.got = true;
                            responseMsgWrapper.msg = connectionClosedException;
                        }
                        responseMsgWrapper.notify();
                    }
                }
                this.waitingList.clear();
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getConnectionId() {
        return this.clientAdmin.getConnectionId();
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    private void checkState() throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 5) {
                throw new IOException("The connection has been closed.");
            }
            long l = this.waitConnectedState;
            long l2 = System.currentTimeMillis();
            while (this.state != 3 && this.state != 5 && l > 0L) {
                try {
                    this.stateLock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                l = this.waitConnectedState - (System.currentTimeMillis() - l2);
            }
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IOException("The connection is not currently established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTerminated() {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 5;
        }
    }

    private class RemoteJob
    implements Runnable {
        private Message msg;

        public RemoteJob(Message message) {
            this.msg = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                if (ClientSynchroMessageConnectionImpl.this.logger.traceOn()) {
                    ClientSynchroMessageConnectionImpl.this.logger.trace("RemoteJob-run", "Receive a new request.");
                }
                try {
                    Message message = ClientSynchroMessageConnectionImpl.this.callback.execute(this.msg);
                    if (message == null) break block10;
                    int[] nArray = ClientSynchroMessageConnectionImpl.this.connectionLock;
                    synchronized (nArray) {
                        ClientSynchroMessageConnectionImpl.this.connection.writeMessage(message);
                    }
                }
                catch (Exception exception) {
                    int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
                    synchronized (nArray) {
                        if (ClientSynchroMessageConnectionImpl.this.state != 3 && ClientSynchroMessageConnectionImpl.this.callback != null) {
                            ClientSynchroMessageConnectionImpl.this.callback.connectionException(exception);
                        }
                    }
                }
            }
        }
    }

    private static class ResponseMsgWrapper {
        public boolean got = false;
        public Object msg = null;

        public void setMsg(Message message) {
            this.got = true;
            this.msg = message;
        }
    }

    private class MessageReader
    implements Runnable {
        private Thread executingThread;
        private boolean executingThreadInterrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object object;
            block20: {
                try {
                    this.executingThread = Thread.currentThread();
                    while (!this.stopped()) {
                        block22: {
                            block23: {
                                Object object2;
                                block21: {
                                    if (ClientSynchroMessageConnectionImpl.this.logger.traceOn()) {
                                        ClientSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "Waiting a coming message...");
                                    }
                                    object = null;
                                    try {
                                        object = ClientSynchroMessageConnectionImpl.this.connection.readMessage();
                                    }
                                    catch (Exception exception) {
                                        if (!this.stopped()) {
                                            try {
                                                ClientSynchroMessageConnectionImpl.this.callback.connectionException(exception);
                                            }
                                            catch (Exception exception2) {}
                                        }
                                        break;
                                    }
                                    if (this.stopped()) break block20;
                                    if (!(object instanceof NotificationResponseMessage)) break block21;
                                    object2 = ClientSynchroMessageConnectionImpl.this.notifLock;
                                    // MONITORENTER : object2
                                    ClientSynchroMessageConnectionImpl.this.notifResp = (NotificationResponseMessage)object;
                                    ClientSynchroMessageConnectionImpl.this.notifLock.notify();
                                    // MONITOREXIT : object2
                                    break block22;
                                }
                                if (!(object instanceof MBeanServerResponseMessage)) break block23;
                                Object object3 = ClientSynchroMessageConnectionImpl.this.waitingList;
                                // MONITORENTER : object3
                                object2 = (ResponseMsgWrapper)ClientSynchroMessageConnectionImpl.this.waitingList.get(new Long(((MBeanServerResponseMessage)object).getMessageId()));
                                // MONITOREXIT : object3
                                if (object2 == null) {
                                    ClientSynchroMessageConnectionImpl.this.checkState();
                                    if (ClientSynchroMessageConnectionImpl.this.logger.traceOn()) {
                                        ClientSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "Receive a MBeanServerResponseMessage but no one is waiting it.");
                                    }
                                    break block22;
                                } else {
                                    Object object4 = object2;
                                    object3 = object4;
                                    // MONITORENTER : object4
                                    ((ResponseMsgWrapper)object2).setMsg((Message)object);
                                    object2.notify();
                                    // MONITOREXIT : object3
                                }
                                break block22;
                            }
                            ClientSynchroMessageConnectionImpl.this.threads.handoff(new RemoteJob((Message)object));
                        }
                        if (!(object instanceof CloseMessage)) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!ClientSynchroMessageConnectionImpl.this.logger.traceOn()) break block20;
                    ClientSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "stops.");
                }
            }
            object = ClientSynchroMessageConnectionImpl.this.stateLock;
            // MONITORENTER : object
            this.executingThreadInterrupted = true;
            // MONITOREXIT : object
            if (!ClientSynchroMessageConnectionImpl.this.logger.traceOn()) return;
            ClientSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "ended.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (ClientSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ClientSynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "be called.");
            }
            int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                if (Thread.currentThread() != this.executingThread && this.executingThread != null && !this.executingThreadInterrupted) {
                    this.executingThreadInterrupted = true;
                    this.executingThread.interrupt();
                }
            }
            if (ClientSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ClientSynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopped() {
            int[] nArray = ClientSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                return ClientSynchroMessageConnectionImpl.this.state != 3 || this.executingThreadInterrupted;
            }
        }
    }
}

