//Please read license.txt for licensing and copyright information

#ifndef WALLET_FUNC_H
#define WALLET_FUNC_H

#include "wallet.h"

CWallet* Wallet_GetDefault();
bool Wallet_IsFromMe(CTransaction& tx);
void Wallet_Erase(uint256 hash);
void Wallet_Sync(const CTransaction& tx, const CBlock* pblock = NULL, bool fUpdate = false);
void Wallet_SetBestChain(const CBlockLocator& loc);
void Wallet_UpdatedTransaction(const uint256& hashTx);
void Wallet_PrintWallets(const CBlock& block);
void Wallet_Inventory(const uint256& hash);
void Wallet_ResendWalletTransactions();
bool Wallet_GetTransaction(const uint256& hashTx, CWalletTx& wtx);
void Wallet_ResendWalletTransactions();
CWallet* Wallet_Get(int nNum);
CWallet* Wallet_Get(const std::string &name);
CWallet* Wallet_IsMine(const CTxOut& txout);

void Wallet_SetDefault(CWallet *pWallet);
void Wallet_SetSelected(CWallet *pWallet);
CWallet* Wallet_GetSelected();
void Wallet_Cleanup(void);

class CWalletLock
{
private:
public:
    CWalletLock(const char* pszFile, int nLine)
    {
        extern CCriticalSection g_WalletLock;
        g_WalletLock.Enter("walletlock", pszFile, nLine);

    }
    ~CWalletLock()  //no need to virtual, what dumb bastard would inherit from this?
    {
        extern CCriticalSection g_WalletLock;

        g_WalletLock.Leave();
    }
};
#define LOCK_WALLET_ACCESS()  CWalletLock _wallet_lock(__FILE__, __LINE__)


#endif
